/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.DavServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class Options
extends DavMethod {
    public static final String OPTIONS = "OPTIONS";

    public String getName() {
        return OPTIONS;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        HttpServletResponse resp = ctxt.getResponse();
        DavServlet.setAllowHeader(resp);
        resp.setContentLength(0);
        try {
            DavResource rs = ctxt.getRequestedResource();
            ctxt.setDavCompliance(DavProtocol.getComplianceString(rs.getComplianceList()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendResponse(ctxt);
    }
}

