/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;

public class Move
extends DavMethod {
    public static final String MOVE = "MOVE";

    public String getName() {
        return MOVE;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        DavResource rs = ctxt.getRequestedResource();
        if (!(rs instanceof MailItemResource)) {
            throw new DavException("cannot copy", 400, null);
        }
        Collection col = this.getDestinationCollection(ctxt);
        MailItemResource mir = (MailItemResource)rs;
        mir.move(ctxt, col);
        this.renameIfNecessary(ctxt, mir, col);
        ctxt.setStatus(204);
    }

    protected void renameIfNecessary(DavContext ctxt, DavResource rs, MailItemResource destCollection) throws DavException {
        int begin;
        String newName;
        if (!(rs instanceof Collection)) {
            return;
        }
        String oldName = ctxt.getItem();
        String dest = this.getDestination(ctxt);
        int end = dest.length();
        if (dest.endsWith("/")) {
            --end;
        }
        if (!oldName.equals(newName = dest.substring((begin = dest.lastIndexOf("/", end - 1)) + 1, end))) {
            rs.rename(ctxt, newName, destCollection);
        }
    }

    protected String getDestination(DavContext ctxt) throws DavException {
        String destination = ctxt.getRequest().getHeader("Destination");
        if (destination == null) {
            throw new DavException("no destination specified", 400, null);
        }
        return destination;
    }

    protected Collection getDestinationCollection(DavContext ctxt) throws DavException {
        String destinationUrl = this.getDestination(ctxt);
        try {
            DavResource r = UrlNamespace.getResourceAtUrl(ctxt, destinationUrl);
            if (r instanceof Collection) {
                return (Collection)r;
            }
            return UrlNamespace.getCollectionAtUrl(ctxt, destinationUrl);
        }
        catch (Exception e) {
            throw new DavException("can't get destination collection", 424);
        }
    }
}

