/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.method.PropPatch;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.Element;

public class MkCalendar
extends DavMethod {
    public static final String MKCALENDAR = "MKCALENDAR";

    public String getName() {
        return MKCALENDAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(DavContext ctxt) throws DavException, IOException {
        block6: {
            Document doc;
            String user = ctxt.getUser();
            String name = ctxt.getItem();
            if (user == null || name == null) {
                throw new DavException("invalid uri", 403, null);
            }
            Element top = null;
            if (ctxt.hasRequestMessage() && !(top = (doc = ctxt.getRequestMessage()).getRootElement()).getName().equals("mkcalendar")) {
                throw new DavException("msg " + top.getName() + " not allowed in MKCALENDAR", 400, null);
            }
            Collection col = UrlNamespace.getCollectionAtUrl(ctxt, ctxt.getPath());
            if (col instanceof CalendarCollection) {
                throw new DavException("can't create calendar under another calendar", 403, null);
            }
            Collection newone = col.mkCol(ctxt, name, (byte)11);
            boolean success = false;
            try {
                PropPatch.handlePropertyUpdate(ctxt, top, newone);
                success = true;
                Object var9_8 = null;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!success) {
                    newone.delete(ctxt);
                }
                throw throwable;
            }
            newone.delete(ctxt);
        }
        ctxt.setStatus(201);
        ctxt.getResponse().addHeader("Cache-Control", "no-cache");
    }

    public void checkPrecondition(DavContext ctxt) throws DavException {
    }

    public void checkPostcondition(DavContext ctxt) throws DavException {
    }
}

