/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.LockMgr;
import com.zimbra.cs.dav.property.LockDiscovery;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Lock
extends DavMethod {
    public static final String LOCK = "LOCK";

    public String getName() {
        return LOCK;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        String owner;
        if (!ctxt.hasRequestMessage()) {
            throw new DavException("no request body", 400, null);
        }
        DavContext.Depth depth = ctxt.getDepth();
        if (depth == DavContext.Depth.one) {
            throw new DavException("invalid depth", 400, null);
        }
        String d = depth == DavContext.Depth.zero ? "0" : depth.toString();
        LockMgr.LockScope scope = LockMgr.LockScope.shared;
        LockMgr.LockType type = LockMgr.LockType.write;
        Document req = ctxt.getRequestMessage();
        Element top = req.getRootElement();
        if (!top.getName().equals("lockinfo")) {
            throw new DavException("msg " + top.getName() + " not allowed in LOCK", 400, null);
        }
        Element e = top.element(DavElements.E_LOCKSCOPE);
        List ls = e.elements();
        for (Element v : ls) {
            if (v.getQName().equals(DavElements.E_EXCLUSIVE)) {
                scope = LockMgr.LockScope.exclusive;
                continue;
            }
            if (v.getQName().equals(DavElements.E_SHARED)) {
                scope = LockMgr.LockScope.shared;
                continue;
            }
            throw new DavException("unrecognized scope element " + v.toString(), 400, null);
        }
        e = top.element(DavElements.E_LOCKTYPE);
        List lt = e.elements();
        for (Element v : lt) {
            if (v.getQName().equals(DavElements.E_WRITE)) {
                type = LockMgr.LockType.write;
                continue;
            }
            throw new DavException("unrecognized type element " + v.toString(), 400, null);
        }
        e = top.element(DavElements.E_OWNER);
        if (e != null && e.elementIterator(DavElements.E_HREF).hasNext()) {
            Element ownerElem = (Element)e.elementIterator(DavElements.E_HREF).next();
            owner = ownerElem.getText();
        } else {
            owner = ctxt.getAuthAccount().getName();
        }
        LockMgr lockmgr = LockMgr.getInstance();
        LockMgr.Lock lock = lockmgr.createLock(ctxt, owner, ctxt.getUri(), type, scope, d);
        ctxt.getDavResponse().addProperty(ctxt, new LockDiscovery(lock));
        ctxt.setStatus(200);
        this.sendResponse(ctxt);
    }
}

