/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public class Get
extends DavMethod {
    public static final String GET = "GET";

    public String getName() {
        return GET;
    }

    protected boolean returnContent() {
        return true;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        DavResource resource = ctxt.getRequestedResource();
        HttpServletResponse resp = ctxt.getResponse();
        String contentType = resource.getContentType(ctxt);
        if (contentType != null) {
            ContentType ct = new ContentType(contentType);
            if (ct.getParameter("charset") == null) {
                ct.setParameter("charset", "utf-8");
            }
            resp.setContentType(ct.toString());
        }
        if (resource.hasEtag()) {
            ctxt.getResponse().setHeader("ETag", resource.getEtag());
        }
        if (!this.returnContent() || !resource.hasContent(ctxt)) {
            return;
        }
        if (ZimbraLog.dav.isDebugEnabled()) {
            ZimbraLog.dav.debug("GET " + ctxt.getUri());
            if (contentType != null && contentType.startsWith("text")) {
                ZimbraLog.dav.debug(new String(ByteUtil.getContent(resource.getContent(ctxt), 0), "UTF-8"));
            }
        }
        ByteUtil.copy(resource.getContent(ctxt), true, (OutputStream)ctxt.getResponse().getOutputStream(), false);
    }
}

