/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.method.Report;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Element;

public class FreeBusyQuery
extends Report {
    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.E_FREE_BUSY_QUERY)) {
            throw new DavException("msg " + query.getName() + " is not free-busy-query", 400, null);
        }
        Element trElem = query.element(DavElements.E_TIME_RANGE);
        if (trElem == null) {
            throw new DavException("need time-range", 400, null);
        }
        TimeRange timeRange = new TimeRange(trElem);
        DavResource rs = ctxt.getRequestedResource();
        if (!(rs instanceof CalendarCollection)) {
            throw new DavException("not a calendar collection", 400, null);
        }
        try {
            String freebusy = ((CalendarCollection)rs).getFreeBusyReport(ctxt, timeRange);
            HttpServletResponse resp = ctxt.getResponse();
            resp.setContentType("text/calendar");
            resp.getOutputStream().write(freebusy.getBytes("UTF-8"));
            ctxt.responseSent();
        }
        catch (ServiceException se) {
            throw new DavException("can't get freebusy report", 500, se);
        }
    }
}

