/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ExpandProperty
extends Report {
    public void handle(DavContext ctxt) throws ServiceException, DavException {
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.E_EXPAND_PROPERTY)) {
            throw new DavException("msg " + query.getName() + " is not expand-property", 400, null);
        }
        DavResource rs = ctxt.getRequestedResource();
        ctxt.setDavCompliance(DavProtocol.getComplianceString(rs.getComplianceList()));
        ctxt.setStatus(207);
        Element resp = ctxt.getDavResponse().getTop(DavElements.E_MULTISTATUS).addElement(DavElements.E_RESPONSE);
        this.expandProperties(ctxt, rs, query, resp);
    }

    private void expandProperties(DavContext ctxt, DavResource rs, Element elem, Element resp) {
        rs.getProperty(DavElements.E_HREF).toElement(ctxt, resp, false);
        Iterator iter = elem.elementIterator(DavElements.E_PROPERTY);
        DavResponse.PropStat propstat = new DavResponse.PropStat();
        while (iter.hasNext()) {
            Element property = (Element)iter.next();
            Prop p = new Prop(property);
            ResourceProperty rp = rs.getProperty(p.getQName());
            if (rp == null) {
                propstat.add(p.getQName(), null, 404);
                continue;
            }
            Iterator subProps = property.elementIterator();
            if (subProps.hasNext()) {
                DavResponse.PropStat sub = new DavResponse.PropStat();
                sub.add(rp);
                Element subElem = DocumentHelper.createElement(DavElements.E_RESPONSE);
                sub.toResponse(ctxt, subElem, false);
                Iterator subPropstats = subElem.elementIterator(DavElements.E_PROPSTAT);
                while (subPropstats.hasNext()) {
                    Element prop;
                    Element subPropstat = (Element)subPropstats.next();
                    Element status = subPropstat.element(DavElements.E_STATUS);
                    if (!status.getText().equals(DavResponse.sStatusTextMap.get(200)) || (prop = subPropstat.element(DavElements.E_PROP)) == null || (prop = prop.element(p.getQName())) == null) continue;
                    Iterator hrefs = prop.elementIterator(DavElements.E_HREF);
                    while (hrefs.hasNext()) {
                        Element href = (Element)hrefs.next();
                        String url = href.getText();
                        if (url == null) continue;
                        try {
                            url = URLDecoder.decode(url, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            ZimbraLog.dav.warn("can't decode url %s", (Object)url, e);
                        }
                        try {
                            DavResource target = UrlNamespace.getResourceAtUrl(ctxt, url);
                            Element targetElem = DocumentHelper.createElement(DavElements.E_RESPONSE);
                            this.expandProperties(ctxt, target, property, targetElem);
                            propstat.add(rp.getName(), targetElem);
                        }
                        catch (DavException e) {
                            ZimbraLog.dav.warn((Object)("can't find resource for " + url), e);
                        }
                    }
                }
                continue;
            }
            propstat.add(rp);
        }
        propstat.toResponse(ctxt, resp, false);
    }

    private static class Prop {
        private String mName;
        private String mNamespace;
        private QName mQName;

        public Prop(Element propElement) {
            this.mName = propElement.attributeValue("name");
            this.mNamespace = propElement.attributeValue("namespace", "DAV:");
            this.mQName = QName.get(this.mName, this.mNamespace);
        }

        public QName getQName() {
            return this.mQName;
        }
    }
}

