/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.service.method.Move;
import java.io.IOException;

public class Copy
extends Move {
    public static final String COPY = "COPY";

    public String getName() {
        return COPY;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        DavResource rs = ctxt.getRequestedResource();
        if (!(rs instanceof MailItemResource)) {
            throw new DavException("cannot copy", 400, null);
        }
        Collection col = this.getDestinationCollection(ctxt);
        MailItemResource mir = (MailItemResource)rs;
        DavResource copy = mir.copy(ctxt, col);
        this.renameIfNecessary(ctxt, copy, col);
        ctxt.setStatus(204);
    }
}

