/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.caldav.Filter;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.CalendarObject;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.QName;

public class CalendarQuery
extends Report {
    public void handle(DavContext ctxt) throws DavException, ServiceException {
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.E_CALENDAR_QUERY)) {
            throw new DavException("msg " + query.getName() + " is not calendar-query", 400, null);
        }
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        QueryContext qctxt = new QueryContext(ctxt, query, reqProp);
        if (qctxt.componentFilter == null) {
            throw new DavException("missing filter element in the request", 400, null);
        }
        DavResource rsc = ctxt.getRequestedResource();
        if (!(rsc instanceof CalendarCollection)) {
            throw new DavException("not a calendar resource", 400, null);
        }
        CalendarCollection cal = (CalendarCollection)rsc;
        TimeRange tr = qctxt.componentFilter.getTimeRange();
        if (tr == null) {
            tr = new TimeRange(rsc.getOwner());
        }
        for (DavResource calItem : cal.getChildren(ctxt, tr)) {
            this.handleCalendarItem(qctxt, calItem);
        }
    }

    private void handleCalendarItem(QueryContext ctxt, DavResource calItem) {
        if (!(calItem instanceof CalendarObject)) {
            return;
        }
        try {
            CalendarObject calobj = (CalendarObject)((Object)calItem);
            if (!calobj.match(ctxt.componentFilter)) {
                return;
            }
            DavResponse resp = ctxt.davCtxt.getDavResponse();
            resp.addResource(ctxt.davCtxt, calItem, ctxt.props, false);
        }
        catch (DavException de) {
            ZimbraLog.dav.error((Object)"can't get calendar item data", de);
        }
    }

    private static class RequestedComponent {
        String name;
        Set<String> props = new HashSet<String>();
        Set<RequestedComponent> comps = new HashSet<RequestedComponent>();

        RequestedComponent(Element elem) {
        }

        void parse(Element elem) {
            this.name = elem.attributeValue("name");
            for (Object o : elem.elements()) {
                if (!(o instanceof Element)) continue;
                Element e = (Element)o;
                QName qname = e.getQName();
                if (qname.equals(DavElements.E_PROP)) {
                    this.props.add(e.attributeValue("name"));
                    continue;
                }
                if (!qname.equals(DavElements.E_COMP)) continue;
                this.comps.add(new RequestedComponent(e));
            }
        }
    }

    private static class QueryContext {
        RequestedComponent requestedComponent;
        Filter.CompFilter componentFilter;
        DavContext davCtxt;
        DavContext.RequestProp props;

        QueryContext(DavContext ctxt, Element query, DavContext.RequestProp rp) throws DavException {
            this.davCtxt = ctxt;
            this.props = rp;
            for (Object o : query.elements()) {
                if (!(o instanceof Element)) continue;
                Element elem = (Element)o;
                QName name = elem.getQName();
                if (name.equals(DavElements.E_FILTER)) {
                    this.parseFilter(elem);
                    continue;
                }
                if (name.equals(DavElements.E_TIMEZONE) || !name.equals(DavElements.E_PROP)) continue;
                for (Object obj : elem.elements()) {
                    if (!(obj instanceof Element) || !(elem = (Element)obj).getQName().equals(DavElements.E_CALENDAR_DATA)) continue;
                    this.parseCalendarData(elem);
                }
            }
        }

        private void parseCalendarData(Element cd) {
            Element comp = cd.element(DavElements.E_COMP);
            if (comp != null) {
                this.requestedComponent = new RequestedComponent(comp);
            }
        }

        private void parseFilter(Element filter) {
            for (Object o : filter.elements()) {
                Element e;
                if (!(o instanceof Element) || !(e = (Element)o).getQName().equals(DavElements.E_COMP_FILTER)) continue;
                this.componentFilter = new Filter.CompFilter(e);
            }
        }
    }
}

