/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.util.ArrayList;
import org.dom4j.Element;

public class CalendarMultiget
extends Report {
    public void handle(DavContext ctxt) throws ServiceException, DavException {
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.E_CALENDAR_MULTIGET)) {
            throw new DavException("msg " + query.getName() + " is not calendar-multiget", 400, null);
        }
        DavResponse resp = ctxt.getDavResponse();
        ArrayList<String> hrefs = new ArrayList<String>();
        for (Object obj : query.elements(DavElements.E_HREF)) {
            if (!(obj instanceof Element)) continue;
            hrefs.add(((Element)obj).getText());
        }
        long ts = System.currentTimeMillis();
        DavResource reqResource = ctxt.getRequestedResource();
        if (!(reqResource instanceof CalendarCollection)) {
            throw new DavException("requested resource is not a calendar collection", 400, null);
        }
        CalendarCollection calResource = (CalendarCollection)reqResource;
        long now = System.currentTimeMillis();
        ZimbraLog.dav.debug("GetRequestedResource: " + (now - ts) + "ms");
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        for (DavResource rs : calResource.getAppointmentsByUids(ctxt, hrefs)) {
            resp.addResource(ctxt, rs, reqProp, false);
        }
        ts = now;
        now = System.currentTimeMillis();
        ZimbraLog.dav.debug("multiget: " + (now - ts) + "ms");
    }
}

