/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.carddav.Filter;
import com.zimbra.cs.dav.resource.AddressObject;
import com.zimbra.cs.dav.resource.AddressbookCollection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.util.Collection;
import org.dom4j.Element;

public class AddressbookQuery
extends Report {
    public void handle(DavContext ctxt) throws DavException, ServiceException {
        DavResource rsc = ctxt.getRequestedResource();
        if (!(rsc instanceof AddressbookCollection)) {
            throw new DavException("not an addressbook resource", 400, null);
        }
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.CardDav.E_ADDRESSBOOK_QUERY)) {
            throw new DavException("msg " + query.getName() + " is not addressbook-query", 400, null);
        }
        Element f = query.element(DavElements.CardDav.E_FILTER);
        if (f == null) {
            throw new DavException("msg " + query.getName() + " is missing filter", 400, null);
        }
        Filter.PropFilter filter = new Filter.PropFilter((Element)f.elementIterator().next());
        Collection<AddressObject> contacts = ((Filter)filter).match(ctxt, (AddressbookCollection)rsc);
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        DavResponse resp = ctxt.getDavResponse();
        resp.createResponse(ctxt);
        for (AddressObject c : contacts) {
            resp.addResource(ctxt, c, reqProp, false);
        }
    }
}

