/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.AddressbookCollection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.dom4j.Element;

public class AddressbookMultiget
extends Report {
    public void handle(DavContext ctxt) throws ServiceException, DavException {
        Element query = ctxt.getRequestMessage().getRootElement();
        if (!query.getQName().equals(DavElements.CardDav.E_ADDRESSBOOK_MULTIGET)) {
            throw new DavException("msg " + query.getName() + " is not addressbook-multiget", 400, null);
        }
        DavResponse resp = ctxt.getDavResponse();
        DavResource reqResource = ctxt.getRequestedResource();
        if (!(reqResource instanceof AddressbookCollection)) {
            throw new DavException("requested resource is not an addressbook collection", 400, null);
        }
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        for (Object obj : query.elements(DavElements.E_HREF)) {
            DavResource rs;
            String href;
            if (!(obj instanceof Element)) continue;
            try {
                href = URLDecoder.decode(((Element)obj).getText(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                href = URLDecoder.decode(((Element)obj).getText());
            }
            if ((rs = UrlNamespace.getResourceAtUrl(ctxt, href)) == null) continue;
            resp.addResource(ctxt, rs, reqProp, false);
        }
    }
}

