/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Report;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclReports
extends Report {
    private static final ArrayList<Pair<QName, Element>> PRINCIPAL_SEARCH_PROPERTIES = new ArrayList();

    @Override
    public void handle(DavContext ctxt) throws DavException, ServiceException {
        ctxt.setStatus(207);
        Element query = ctxt.getRequestMessage().getRootElement();
        if (query.getQName().equals(DavElements.E_PRINCIPAL_PROPERTY_SEARCH)) {
            this.handlePrincipalPropertySearch(ctxt, query);
        } else if (query.getQName().equals(DavElements.E_ACL_PRINCIPAL_PROP_SET)) {
            this.handleAclPrincipalPropSet(ctxt, query);
        } else if (query.getQName().equals(DavElements.E_PRINCIPAL_MATCH)) {
            this.handlePrincipalMatch(ctxt, query);
        } else if (query.getQName().equals(DavElements.E_PRINCIPAL_SEARCH_PROPERTY_SET)) {
            this.handlePrincipalSearchPropertySet(ctxt);
        } else {
            throw new DavException("msg " + query.getName() + " is not an ACL report", 400);
        }
    }

    private void handlePrincipalPropertySearch(DavContext ctxt, Element query) throws DavException, ServiceException {
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        DavResponse resp = ctxt.getDavResponse();
        for (DavResource rs : this.getMatchingResources(ctxt, query)) {
            resp.addResource(ctxt, rs, reqProp, false);
        }
    }

    private ArrayList<DavResource> getMatchingResources(DavContext ctxt, Element query) throws DavException, ServiceException {
        ArrayList<DavResource> ret = new ArrayList<DavResource>();
        boolean applyToPrincipalCollection = query.element(DavElements.E_APPLY_TO_PRINCIPAL_COLLECTION_SET) != null;
        String path = ctxt.getUri();
        if (!applyToPrincipalCollection && !path.startsWith("/principals/users/")) {
            return ret;
        }
        Provisioning.GAL_SEARCH_TYPE type = Provisioning.GAL_SEARCH_TYPE.ALL;
        String queryType = query.attributeValue("type");
        if (queryType != null) {
            if (queryType.compareToIgnoreCase("INDIVIDUAL") == 0) {
                type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
            } else if (queryType.compareToIgnoreCase("RESOURCE") == 0) {
                type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
            }
        }
        List propSearch = query.elements(DavElements.E_PROPERTY_SEARCH);
        for (Object obj : propSearch) {
            if (!(obj instanceof Element)) continue;
            Element ps = (Element)obj;
            Element prop = ps.element(DavElements.E_PROP);
            Element match = ps.element(DavElements.E_MATCH);
            if (prop == null || match == null) continue;
            Element e = (Element)prop.elements().get(0);
            ret.addAll(this.getMatchingPrincipals(ctxt, e.getQName(), match.getText(), type));
        }
        return ret;
    }

    private ArrayList<DavResource> getMatchingPrincipals(DavContext ctxt, QName prop, String match, Provisioning.GAL_SEARCH_TYPE type) throws DavException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        ArrayList<DavResource> ret = new ArrayList<DavResource>();
        Account authAccount = ctxt.getAuthAccount();
        if (prop.equals(DavElements.E_DISPLAYNAME)) {
            Provisioning.SearchGalResult result = prov.searchGal(prov.getDomain(authAccount), match, type, Provisioning.GalMode.zimbra, null);
            for (GalContact ct : result.getMatches()) {
                Account acct;
                String email = (String)ct.getAttrs().get("email");
                if (email == null || (acct = prov.get(Provisioning.AccountBy.name, email)) == null) continue;
                ret.add(UrlNamespace.getPrincipal(ctxt, acct));
            }
        } else if (prop.equals(DavElements.E_CALENDAR_HOME_SET)) {
            Account acct;
            int index = match.lastIndexOf(47);
            if (index > 0) {
                match = match.substring(index + 1);
            }
            if ((acct = prov.get(Provisioning.AccountBy.name, match)) != null) {
                ret.add(UrlNamespace.getPrincipal(ctxt, acct));
            }
        }
        return ret;
    }

    private void handleAclPrincipalPropSet(DavContext ctxt, Element query) throws DavException, ServiceException {
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        DavResponse resp = ctxt.getDavResponse();
        for (DavResource rs : this.getAclPrincipals(ctxt)) {
            resp.addResource(ctxt, rs, reqProp, false);
        }
    }

    private ArrayList<DavResource> getAclPrincipals(DavContext ctxt) throws DavException, ServiceException {
        ArrayList<DavResource> ret = new ArrayList<DavResource>();
        DavResource res = ctxt.getRequestedResource();
        if (!(res instanceof MailItemResource)) {
            return ret;
        }
        List<Acl.Ace> aces = ((MailItemResource)res).getAce(ctxt);
        Provisioning prov = Provisioning.getInstance();
        for (Acl.Ace ace : aces) {
            Account acct;
            if (!ace.hasHref() || (acct = prov.get(Provisioning.AccountBy.id, ace.getZimbraId())) == null) continue;
            ret.add(UrlNamespace.getPrincipal(ctxt, acct));
        }
        return ret;
    }

    private void handlePrincipalMatch(DavContext ctxt, Element query) throws DavException, ServiceException {
        if (ctxt.getDepth() != DavContext.Depth.zero) {
            throw new DavException("non-zero depth", 400);
        }
        ArrayList<DavResource> ret = new ArrayList<DavResource>();
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        DavResponse resp = ctxt.getDavResponse();
        Element principalProp = query.element(DavElements.E_PRINCIPAL_PROPERTY);
        if (principalProp == null) {
            String path = ctxt.getUri();
            if (path.startsWith("/principals/users/")) {
                ret.add(UrlNamespace.getPrincipal(ctxt, ctxt.getAuthAccount()));
            }
        } else {
            DavResource rs;
            Element owner = principalProp.element(DavElements.E_OWNER);
            if (owner != null && (rs = ctxt.getRequestedResource()).isCollection()) {
                ret.addAll(rs.getChildren(ctxt));
            }
        }
        for (DavResource rs : ret) {
            resp.addResource(ctxt, rs, reqProp, false);
        }
    }

    private static void addSearchProperty(QName prop, String desc) {
        Element elem = DocumentHelper.createElement(DavElements.E_DESCRIPTION);
        elem.addAttribute(DavElements.E_LANG, "en-us");
        elem.setText(desc);
        PRINCIPAL_SEARCH_PROPERTIES.add(new Pair<QName, Element>(prop, elem));
    }

    private void handlePrincipalSearchPropertySet(DavContext ctxt) throws DavException, ServiceException {
        if (ctxt.getDepth() != DavContext.Depth.zero) {
            throw new DavException("non-zero depth", 400);
        }
        Element response = ctxt.getDavResponse().getTop(DavElements.E_PRINCIPAL_SEARCH_PROPERTY_SET);
        ctxt.setStatus(200);
        for (Pair<QName, Element> prop : PRINCIPAL_SEARCH_PROPERTIES) {
            Element searchProp = response.addElement(DavElements.E_PRINCIPAL_SEARCH_PROPERTY);
            searchProp.addElement(DavElements.E_PROP).addElement(prop.getFirst());
            searchProp.add(prop.getSecond().createCopy());
        }
    }

    static {
        AclReports.addSearchProperty(DavElements.E_DISPLAYNAME, "Full name");
        AclReports.addSearchProperty(DavElements.E_EMAIL_ADDRESS_SET, "Email Address");
        AclReports.addSearchProperty(DavElements.E_CALENDAR_USER_TYPE, "User type");
        AclReports.addSearchProperty(DavElements.E_CALENDAR_USER_ADDRESS_SET, "Calendar user address");
        AclReports.addSearchProperty(DavElements.E_CALENDAR_HOME_SET, "Calendar home");
    }
}

