/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Acl
extends DavMethod {
    public static final String ACL = "ACL";

    public String getName() {
        return ACL;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        DavResource rs = ctxt.getRequestedResource();
        if (!rs.isCollection() || !(rs instanceof MailItemResource)) {
            throw new DavException("acl not implemented for non-collection resource", 501);
        }
        if (!ctxt.hasRequestMessage()) {
            throw new DavException("empty request", 400);
        }
        Document reqMsg = ctxt.getRequestMessage();
        Element acl = reqMsg.getRootElement();
        if (!acl.getQName().equals(DavElements.E_ACL)) {
            throw new DavException("request does not start with acl element", 400);
        }
        List aceElements = acl.elements(DavElements.E_ACE);
        ArrayList<Acl.Ace> aceList = new ArrayList<Acl.Ace>();
        for (Element ace : aceElements) {
            aceList.add(new Acl.Ace(ace));
        }
        MailItemResource mir = (MailItemResource)rs;
        mir.setAce(ctxt, aceList);
    }
}

