/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DomUtil;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.dav.service.method.Acl;
import com.zimbra.cs.dav.service.method.Copy;
import com.zimbra.cs.dav.service.method.Delete;
import com.zimbra.cs.dav.service.method.Get;
import com.zimbra.cs.dav.service.method.Head;
import com.zimbra.cs.dav.service.method.Lock;
import com.zimbra.cs.dav.service.method.MkCalendar;
import com.zimbra.cs.dav.service.method.MkCol;
import com.zimbra.cs.dav.service.method.Move;
import com.zimbra.cs.dav.service.method.Options;
import com.zimbra.cs.dav.service.method.Post;
import com.zimbra.cs.dav.service.method.PropFind;
import com.zimbra.cs.dav.service.method.PropPatch;
import com.zimbra.cs.dav.service.method.Put;
import com.zimbra.cs.dav.service.method.Report;
import com.zimbra.cs.dav.service.method.Unlock;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.calendar.cache.AccountCtags;
import com.zimbra.cs.mailbox.calendar.cache.AccountKey;
import com.zimbra.cs.mailbox.calendar.cache.CalendarCacheManager;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import com.zimbra.cs.mailbox.calendar.cache.CtagResponseCache;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DavServlet
extends ZimbraServlet {
    public static final String DAV_PATH = "/dav";
    private static Map<String, DavMethod> sMethods;
    private static String[] PROXY_HEADERS;

    public void init() throws ServletException {
        super.init();
        sMethods = new HashMap<String, DavMethod>();
        this.addMethod(new Copy());
        this.addMethod(new Delete());
        this.addMethod(new Get());
        this.addMethod(new Head());
        this.addMethod(new Lock());
        this.addMethod(new MkCol());
        this.addMethod(new Move());
        this.addMethod(new Options());
        this.addMethod(new Post());
        this.addMethod(new Put());
        this.addMethod(new PropFind());
        this.addMethod(new PropPatch());
        this.addMethod(new Unlock());
        this.addMethod(new MkCalendar());
        this.addMethod(new Report());
        this.addMethod(new Acl());
    }

    protected void addMethod(DavMethod method) {
        sMethods.put(method.getName(), method);
    }

    public static void setAllowHeader(HttpServletResponse resp) {
        Set<String> methods = sMethods.keySet();
        StringBuilder buf = new StringBuilder();
        for (String method : methods) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(method);
        }
        DavMethod.setResponseHeader(resp, "Allow", buf.toString());
    }

    private RequestType getAllowedRequestType(HttpServletRequest req) {
        if (!super.isRequestOnAllowedPort(req)) {
            return RequestType.none;
        }
        Server server = null;
        try {
            server = Provisioning.getInstance().getLocalServer();
        }
        catch (Exception e) {
            return RequestType.none;
        }
        boolean allowPassword = server.getBooleanAttr("zimbraCalendarCalDavClearTextPasswordEnabled", true);
        int sslPort = server.getIntAttr("zimbraMailSSLPort", 443);
        int mailPort = server.getIntAttr("zimbraMailPort", 80);
        int incomingPort = req.getLocalPort();
        if (incomingPort == sslPort) {
            return RequestType.both;
        }
        if (incomingPort == mailPort && allowPassword) {
            return RequestType.both;
        }
        return RequestType.authtoken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DavContext ctxt;
        ZimbraLog.clearContext();
        this.addRemoteIpToLoggingContext(req);
        ZimbraLog.addUserAgentToContext(req.getHeader("User-Agent"));
        RequestType rtype = this.getAllowedRequestType(req);
        if (rtype == RequestType.none) {
            resp.sendError(406);
            return;
        }
        NamedEntry authUser = null;
        try {
            AuthToken at = AuthProvider.getAuthToken(req, false);
            if (at != null && at.isExpired()) {
                at = null;
            }
            if (at != null && (rtype == RequestType.both || rtype == RequestType.authtoken)) {
                authUser = Provisioning.getInstance().get(Provisioning.AccountBy.id, at.getAccountId());
            } else if (at == null && (rtype == RequestType.both || rtype == RequestType.password)) {
                authUser = this.basicAuthRequest(req, resp, true);
            }
            if (authUser == null) {
                try {
                    resp.sendError(406);
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            ZimbraLog.addToContext("aname", authUser.getName());
            ctxt = new DavContext(req, resp, (Account)authUser);
        }
        catch (AuthTokenException e) {
            ZimbraLog.dav.error((Object)"error getting authenticated user", e);
            resp.sendError(500);
            return;
        }
        catch (ServiceException e) {
            ZimbraLog.dav.error((Object)"error getting authenticated user", e);
            resp.sendError(500);
            return;
        }
        DavMethod method = sMethods.get(req.getMethod());
        if (method == null) {
            DavServlet.setAllowHeader(resp);
            resp.sendError(405);
            return;
        }
        long t0 = System.currentTimeMillis();
        if (ZimbraLog.dav.isDebugEnabled()) {
            try {
                FileUploadServlet.Upload upload = ctxt.getUpload();
                if (upload.getSize() > 0L && upload.getContentType().startsWith("text")) {
                    ZimbraLog.dav.debug("REQUEST:\n" + new String(ByteUtil.readInput(upload.getInputStream(), -1, 2048), "UTF-8"));
                }
            }
            catch (Exception e) {
                ZimbraLog.dav.debug((Object)"ouch", e);
            }
        }
        CacheStates cache = null;
        try {
            block33: {
                try {
                    cache = this.checkCachedResponse(ctxt, (Account)authUser);
                    if (ctxt.isResponseSent() || this.isProxyRequest(ctxt, method)) break block33;
                    method.checkPrecondition(ctxt);
                    method.handle(ctxt);
                    method.checkPostcondition(ctxt);
                    if (ctxt.isResponseSent()) break block33;
                    resp.setStatus(ctxt.getStatus());
                }
                catch (DavException e) {
                    block34: {
                        if (e.getCause() instanceof MailServiceException.NoSuchItemException || e.getStatus() == 404) {
                            ZimbraLog.dav.info(ctxt.getUri() + " not found");
                        } else if (e.getStatus() == 302 || e.getStatus() == 301) {
                            ZimbraLog.dav.info("sending redirect");
                        }
                        try {
                            if (e.isStatusSet()) {
                                resp.setStatus(e.getStatus());
                                if (e.hasErrorMessage()) {
                                    e.writeErrorMsg((OutputStream)resp.getOutputStream());
                                }
                                ZimbraLog.dav.info("sending http error %d because: %s", e.getStatus(), e.getMessage());
                                if (e.getCause() != null) {
                                    ZimbraLog.dav.debug((Object)"exception: ", e.getCause());
                                }
                                break block34;
                            }
                            ZimbraLog.dav.error((Object)("error handling method " + method.getName()), e);
                            resp.sendError(500);
                        }
                        catch (IllegalStateException ise) {
                            ZimbraLog.dav.debug((Object)"can't write error msg", ise);
                        }
                    }
                    Object var13_14 = null;
                    long t1 = System.currentTimeMillis();
                    ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
                    this.cacheCleanUp(ctxt, cache);
                    ctxt.cleanup();
                    return;
                }
                catch (ServiceException e) {
                    if (e instanceof MailServiceException.NoSuchItemException) {
                        ZimbraLog.dav.info(ctxt.getUri() + " not found");
                        resp.sendError(404);
                        Object var13_15 = null;
                        long t1 = System.currentTimeMillis();
                        ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
                        this.cacheCleanUp(ctxt, cache);
                        ctxt.cleanup();
                        return;
                    }
                    ZimbraLog.dav.error((Object)("error handling method " + method.getName()), e);
                    resp.sendError(500);
                    Object var13_16 = null;
                    long t1 = System.currentTimeMillis();
                    ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
                    this.cacheCleanUp(ctxt, cache);
                    ctxt.cleanup();
                    return;
                }
                catch (Exception e) {
                    ZimbraLog.dav.error((Object)("error handling method " + method.getName()), e);
                    try {
                        resp.sendError(500);
                    }
                    catch (Exception ex) {
                    }
                    Object var13_17 = null;
                    long t1 = System.currentTimeMillis();
                    ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
                    this.cacheCleanUp(ctxt, cache);
                    ctxt.cleanup();
                    return;
                }
            }
            Object var13_13 = null;
            long t1 = System.currentTimeMillis();
            ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
            this.cacheCleanUp(ctxt, cache);
            ctxt.cleanup();
            return;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            long t1 = System.currentTimeMillis();
            ZimbraLog.dav.info("DavServlet operation " + method.getName() + " to " + req.getPathInfo() + " (depth: " + ctxt.getDepth().name() + ") finished in " + (t1 - t0) + "ms");
            this.cacheCleanUp(ctxt, cache);
            ctxt.cleanup();
            throw throwable;
        }
    }

    public static String getDavUrl(String user) throws DavException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        if (account == null) {
            throw new DavException("unknown user " + user, 404, null);
        }
        return DavServlet.getServiceUrl(account, DAV_PATH);
    }

    private boolean isCtagRequest(DavContext ctxt) throws DavException {
        String httpMethod = ctxt.getRequest().getMethod();
        if ("PROPFIND".equalsIgnoreCase(httpMethod)) {
            Document doc = ctxt.getRequestMessage();
            Element top = doc.getRootElement();
            if (top == null || !top.getQName().equals(DavElements.E_PROPFIND)) {
                return false;
            }
            Element prop = top.element(DavElements.E_PROP);
            if (prop == null) {
                return false;
            }
            Iterator iter = prop.elementIterator();
            while (iter.hasNext()) {
                prop = (Element)iter.next();
                if (!prop.getQName().equals(DavElements.E_GETCTAG)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheStates checkCachedResponse(DavContext ctxt, Account authUser) throws IOException, DavException, ServiceException {
        CacheStates cache = new CacheStates();
        if (cache.ctagCacheEnabled && this.isCtagRequest(ctxt)) {
            cache.ctagResponseCache = CalendarCacheManager.getInstance().getCtagResponseCache();
            cache.gzipAccepted = ctxt.isGzipAccepted();
            String targetUser = ctxt.getUser();
            Account targetAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, targetUser);
            boolean ownAcct = targetAcct != null && targetAcct.getId().equals(authUser.getId());
            String parentPath = ctxt.getPath();
            DavContext.KnownUserAgent knownUA = ctxt.getKnownUserAgent();
            if (ownAcct && knownUA != null && parentPath != null) {
                AccountKey accountKey = new AccountKey(targetAcct.getId());
                AccountCtags allCtagsData = CalendarCacheManager.getInstance().getCtags(accountKey);
                if (allCtagsData != null) {
                    boolean validRoot = true;
                    int rootFolderId = 1;
                    if (!"/".equals(parentPath)) {
                        CtagInfo calInfoRoot = allCtagsData.getByPath(parentPath);
                        if (calInfoRoot != null) {
                            rootFolderId = calInfoRoot.getId();
                        } else {
                            validRoot = false;
                        }
                    }
                    if (validRoot) {
                        String currentCalListVer;
                        cache.ctagCacheKey = new CtagResponseCache.CtagResponseCacheKey(targetAcct.getId(), knownUA.toString(), rootFolderId);
                        CtagResponseCache.CtagResponseCacheValue ctagResponse = cache.ctagResponseCache.get(cache.ctagCacheKey);
                        if (ctagResponse != null && (currentCalListVer = allCtagsData.getVersion()).equals(ctagResponse.getVersion())) {
                            boolean cacheHit = true;
                            Map<Integer, String> oldCtags = ctagResponse.getCtags();
                            for (Map.Entry<Integer, String> entry : oldCtags.entrySet()) {
                                int calFolderId = entry.getKey();
                                String ctag = entry.getValue();
                                CtagInfo calInfoCurr = allCtagsData.getById(calFolderId);
                                if (calInfoCurr == null) {
                                    cacheHit = false;
                                    break;
                                }
                                if (ctag.equals(calInfoCurr.getCtag())) continue;
                                cacheHit = false;
                                break;
                            }
                            if (cacheHit) {
                                ZimbraLog.dav.debug("CTAG REQUEST CACHE HIT");
                                ctxt.setStatus(207);
                                HttpServletResponse response = ctxt.getResponse();
                                response.setStatus(ctxt.getStatus());
                                response.setContentType("text/xml; charset=\"UTF-8\"");
                                byte[] respData = ctagResponse.getResponseBody();
                                response.setContentLength(ctagResponse.getRawLength());
                                byte[] unzipped = null;
                                if (ZimbraLog.dav.isDebugEnabled() || ctagResponse.isGzipped() && !cache.gzipAccepted) {
                                    if (ctagResponse.isGzipped()) {
                                        ByteArrayInputStream bais = new ByteArrayInputStream(respData);
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        GZIPInputStream gzis = null;
                                        try {
                                            gzis = new GZIPInputStream((InputStream)bais, respData.length);
                                            ByteUtil.copy(gzis, false, baos, true);
                                            Object var24_26 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var24_27 = null;
                                            ByteUtil.closeStream(gzis);
                                            throw throwable;
                                        }
                                        ByteUtil.closeStream(gzis);
                                        unzipped = baos.toByteArray();
                                    } else {
                                        unzipped = respData;
                                    }
                                    if (ZimbraLog.dav.isDebugEnabled()) {
                                        ZimbraLog.dav.debug("RESPONSE:\n" + new String(unzipped, "UTF-8"));
                                    }
                                }
                                if (!ctagResponse.isGzipped()) {
                                    response.getOutputStream().write(respData);
                                } else if (cache.gzipAccepted) {
                                    response.addHeader("Content-Encoding", "gzip");
                                    response.getOutputStream().write(respData);
                                } else {
                                    assert (unzipped != null);
                                    response.getOutputStream().write(unzipped);
                                }
                                ctxt.responseSent();
                            }
                        }
                        if (!ctxt.isResponseSent()) {
                            CtagInfo ctagRoot;
                            cache.cacheThisCtagResponse = true;
                            cache.acctVerSnapshot = allCtagsData.getVersion();
                            cache.ctagsSnapshot = new HashMap<Integer, String>();
                            Collection<CtagInfo> childCals = allCtagsData.getChildren(rootFolderId);
                            if (rootFolderId != 1 && (ctagRoot = allCtagsData.getById(rootFolderId)) != null) {
                                cache.ctagsSnapshot.put(rootFolderId, ctagRoot.getCtag());
                            }
                            for (CtagInfo calInfo : childCals) {
                                cache.ctagsSnapshot.put(calInfo.getId(), calInfo.getCtag());
                            }
                        }
                    }
                }
                if (!ctxt.isResponseSent()) {
                    ZimbraLog.dav.debug("CTAG REQUEST CACHE MISS");
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheCleanUp(DavContext ctxt, CacheStates cache) throws IOException {
        if (cache.ctagCacheEnabled && cache.cacheThisCtagResponse && ctxt.getStatus() == 207) {
            boolean responseGzipped;
            assert (cache.ctagCacheKey != null && cache.acctVerSnapshot != null && !cache.ctagsSnapshot.isEmpty());
            DavResponse dresp = ctxt.getDavResponse();
            ByteArrayOutputStream baosRaw = null;
            try {
                baosRaw = new ByteArrayOutputStream();
                dresp.writeTo(baosRaw);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ByteUtil.closeStream(baosRaw);
                throw throwable;
            }
            ByteUtil.closeStream(baosRaw);
            byte[] respData = baosRaw.toByteArray();
            int rawLen = respData.length;
            boolean forceGzip = true;
            boolean bl = responseGzipped = forceGzip || cache.gzipAccepted;
            if (responseGzipped) {
                ByteArrayOutputStream baosGzipped = new ByteArrayOutputStream();
                GZIPOutputStream gzos = null;
                try {
                    gzos = new GZIPOutputStream(baosGzipped);
                    gzos.write(respData);
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    ByteUtil.closeStream(gzos);
                    throw throwable;
                }
                ByteUtil.closeStream(gzos);
                respData = baosGzipped.toByteArray();
            }
            CtagResponseCache.CtagResponseCacheValue ctagCacheVal = new CtagResponseCache.CtagResponseCacheValue(respData, rawLen, responseGzipped, cache.acctVerSnapshot, cache.ctagsSnapshot);
            try {
                cache.ctagResponseCache.put(cache.ctagCacheKey, ctagCacheVal);
            }
            catch (ServiceException e) {
                ZimbraLog.dav.warn((Object)"Unable to cache ctag response", e);
            }
        }
    }

    private boolean isProxyRequest(DavContext ctxt, DavMethod m) throws IOException, DavException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        ItemId target = null;
        String extraPath = null;
        String requestPath = ctxt.getPath();
        try {
            if (ctxt.getUser() == null) {
                return false;
            }
            if (requestPath == null || requestPath.length() < 2) {
                return false;
            }
            Account account = prov.getAccountByName(ctxt.getUser());
            if (account == null) {
                return false;
            }
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
            Pair<Folder, String> match = mbox.getFolderByPathLongestMatch(ctxt.getOperationContext(), 1, requestPath);
            Folder targetFolder = match.getFirst();
            if (!(targetFolder instanceof Mountpoint)) {
                return false;
            }
            Mountpoint mp = (Mountpoint)targetFolder;
            target = new ItemId(mp.getOwnerId(), mp.getRemoteId());
            extraPath = match.getSecond();
        }
        catch (ServiceException e) {
            ZimbraLog.dav.debug((Object)"can't get path", e);
            return false;
        }
        if (extraPath == null && (m.getName().equals("PROPFIND") && ctxt.getDepth() == DavContext.Depth.zero || m.getName().equals("PROPPATCH") || m.getName().equals("DELETE"))) {
            return false;
        }
        String prefix = ctxt.getPath();
        if (extraPath != null) {
            prefix = prefix.substring(0, prefix.indexOf(extraPath));
        }
        prefix = URLUtil.urlEscape("/dav/" + ctxt.getUser() + prefix);
        Account acct = prov.getAccountById(target.getAccountId());
        if (acct == null) {
            return false;
        }
        Server server = prov.getServer(acct);
        if (server == null) {
            return false;
        }
        AuthToken authToken = AuthProvider.getAuthToken(ctxt.getAuthAccount());
        ZMailbox.Options zoptions = new ZMailbox.Options(authToken.toZAuthToken(), AccountUtil.getSoapUri(acct));
        zoptions.setNoSession(true);
        zoptions.setTargetAccount(target.getAccountId());
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
        ZFolder f = zmbx.getFolderById("" + target.toString());
        if (f == null) {
            return false;
        }
        String path = f.getPath();
        String newPrefix = URLUtil.urlEscape("/dav/" + acct.getName() + f.getPath());
        if (ctxt.hasRequestMessage()) {
            Document req = ctxt.getRequestMessage();
            for (Object hrefObj : req.getRootElement().elements(DavElements.E_HREF)) {
                if (!(hrefObj instanceof Element)) continue;
                Element href = (Element)hrefObj;
                String v = href.getText();
                href.setText(newPrefix + "/" + v.substring(v.lastIndexOf(47) + 1));
            }
        }
        String url = DavServlet.getProxyUrl(ctxt.getRequest(), server, DAV_PATH) + URLUtil.urlEscape("/" + acct.getName() + path + "/" + (extraPath == null ? "" : extraPath));
        HttpState state = new HttpState();
        authToken.encode(state, false, server.getAttr("zimbraServiceHostname"));
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        client.setState(state);
        HttpMethod method = m.toHttpMethod(ctxt, url);
        for (String h : PROXY_HEADERS) {
            String hval = ctxt.getRequest().getHeader(h);
            if (hval == null) continue;
            method.addRequestHeader(h, hval);
        }
        int statusCode = client.executeMethod(method);
        ctxt.getResponse().setStatus(statusCode);
        ctxt.setStatus(statusCode);
        InputStream in = method.getResponseBodyAsStream();
        switch (statusCode) {
            case 207: {
                try {
                    Document response = com.zimbra.common.soap.Element.getSAXReader().read(in);
                    Element top = response.getRootElement();
                    for (Object responseObj : top.elements(DavElements.E_RESPONSE)) {
                        Element href;
                        String v;
                        if (!(responseObj instanceof Element) || !(v = (href = ((Element)responseObj).element(DavElements.E_HREF)).getText()).startsWith(newPrefix)) continue;
                        href.setText(prefix + v.substring(newPrefix.length() + 1));
                    }
                    if (ZimbraLog.dav.isDebugEnabled()) {
                        ZimbraLog.dav.debug("PROXY RESPONSE:\n" + new String(DomUtil.getBytes(response), "UTF-8"));
                    }
                    DomUtil.writeDocumentToStream(response, (OutputStream)ctxt.getResponse().getOutputStream());
                    ctxt.responseSent();
                    break;
                }
                catch (DocumentException e) {
                    ZimbraLog.dav.warn((Object)"proxy request failed", e);
                    return false;
                }
            }
            default: {
                if (in != null) {
                    ByteUtil.copy(in, true, (OutputStream)ctxt.getResponse().getOutputStream(), false);
                }
                ctxt.responseSent();
            }
        }
        return true;
    }

    static {
        PROXY_HEADERS = new String[]{"DAV", "Depth", "Content-Type", "ETag", "If-Match"};
    }

    private static class CacheStates {
        boolean ctagCacheEnabled = MemcachedConnector.isConnected();
        boolean gzipAccepted = false;
        boolean cacheThisCtagResponse = false;
        CtagResponseCache.CtagResponseCacheKey ctagCacheKey = null;
        String acctVerSnapshot = null;
        Map<Integer, String> ctagsSnapshot = null;
        CtagResponseCache ctagResponseCache = null;

        private CacheStates() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        password,
        authtoken,
        both,
        none;

    }
}

