/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.DomUtil;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.DavResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavResponse {
    public static Map<Integer, String> sStatusTextMap = new HashMap<Integer, String>();
    private Document mResponse = DocumentHelper.createDocument();

    public Element getTop(QName topName) {
        Element top = this.mResponse.getRootElement();
        if (top == null) {
            top = this.mResponse.addElement(topName);
        }
        return top;
    }

    public void addProperty(DavContext ctxt, ResourceProperty prop) throws DavException {
        Element top = this.mResponse.addElement(DavElements.E_PROP);
        prop.toElement(ctxt, top, false);
    }

    public void addResource(DavContext ctxt, DavResource rs, DavContext.RequestProp props, boolean includeChildren) throws DavException {
        ctxt.setStatus(207);
        ctxt.setDavCompliance(DavProtocol.getComplianceString(rs.getComplianceList()));
        this.addResourceTo(ctxt, rs, props, includeChildren);
        if (rs.isCollection() && includeChildren) {
            for (DavResource child : rs.getChildren(ctxt)) {
                this.addResource(ctxt, child, props, includeChildren);
            }
        }
    }

    public void addResourceTo(DavContext ctxt, DavResource rs, DavContext.RequestProp props, boolean includeChildren) throws DavException {
        if (!rs.isValid()) {
            this.addStatus(ctxt, rs.getUri(), 404);
            return;
        }
        Element top = this.getTop(DavElements.E_MULTISTATUS).addElement(DavElements.E_RESPONSE);
        rs.getProperty(DavElements.E_HREF).toElement(ctxt, top, false);
        Collection<QName> propNames = props.isAllProp() ? rs.getAllPropertyNames() : props.getProps();
        PropStat propstat = new PropStat();
        Map<QName, DavException> errPropMap = props.getErrProps();
        for (QName name : propNames) {
            ResourceProperty prop = rs.getProperty(name, props);
            if (errPropMap.containsKey(name)) {
                DavException ex = errPropMap.get(name);
                propstat.add(name, ex.getMessage(), ex.getStatus());
                continue;
            }
            if (prop == null) {
                propstat.add(name, null, 404);
                continue;
            }
            propstat.add(prop);
        }
        propstat.toResponse(ctxt, top, props.isNameOnly());
    }

    public void addResources(DavContext ctxt, Collection<DavResource> rss, DavContext.RequestProp props) throws DavException {
        ctxt.setStatus(207);
        boolean first = true;
        for (DavResource rs : rss) {
            if (first) {
                ctxt.setDavCompliance(DavProtocol.getComplianceString(rs.getComplianceList()));
            }
            this.addResourceTo(ctxt, rs, props, false);
            first = false;
        }
    }

    public void addStatus(DavContext ctxt, String href, int status) {
        ctxt.setStatus(207);
        Element resp = this.getTop(DavElements.E_MULTISTATUS).addElement(DavElements.E_RESPONSE);
        resp.addElement(DavElements.E_HREF).setText(href);
        resp.addElement(DavElements.E_STATUS).setText(sStatusTextMap.get(status));
    }

    public void createResponse(DavContext ctxt) {
        ctxt.setStatus(207);
        this.getTop(DavElements.E_MULTISTATUS);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (ZimbraLog.dav.isDebugEnabled()) {
            ZimbraLog.dav.debug("RESPONSE:\n" + new String(DomUtil.getBytes(this.mResponse), "UTF-8"));
        }
        DomUtil.writeDocumentToStream(this.mResponse, out);
    }

    static {
        sStatusTextMap.put(100, "HTTP/1.1 100 Continue");
        sStatusTextMap.put(101, "HTTP/1.1 101 Switching Protocols");
        sStatusTextMap.put(200, "HTTP/1.1 200 OK");
        sStatusTextMap.put(201, "HTTP/1.1 201 Created");
        sStatusTextMap.put(202, "HTTP/1.1 202 Accepted");
        sStatusTextMap.put(203, "HTTP/1.1 203 Non-Authoritative Information");
        sStatusTextMap.put(204, "HTTP/1.1 204 No Content");
        sStatusTextMap.put(205, "HTTP/1.1 205 Reset Content");
        sStatusTextMap.put(206, "HTTP/1.1 206 Partial Content");
        sStatusTextMap.put(300, "HTTP/1.1 300 Multiple Choices");
        sStatusTextMap.put(301, "HTTP/1.1 301 Moved Permanently");
        sStatusTextMap.put(302, "HTTP/1.1 302 Found");
        sStatusTextMap.put(303, "HTTP/1.1 303 See Other");
        sStatusTextMap.put(304, "HTTP/1.1 304 Not Modified");
        sStatusTextMap.put(305, "HTTP/1.1 305 Use Proxy");
        sStatusTextMap.put(307, "HTTP/1.1 307 Temporary Redirect");
        sStatusTextMap.put(400, "HTTP/1.1 400 Bad Request");
        sStatusTextMap.put(401, "HTTP/1.1 401 Unauthorized");
        sStatusTextMap.put(402, "HTTP/1.1 402 Payment Required");
        sStatusTextMap.put(403, "HTTP/1.1 403 Forbidden");
        sStatusTextMap.put(404, "HTTP/1.1 404 Not Found");
        sStatusTextMap.put(405, "HTTP/1.1 405 Method Not Allowed");
        sStatusTextMap.put(406, "HTTP/1.1 406 Not Acceptable");
        sStatusTextMap.put(407, "HTTP/1.1 407 Proxy Authentication Required");
        sStatusTextMap.put(408, "HTTP/1.1 408 Request Time-out");
        sStatusTextMap.put(409, "HTTP/1.1 409 Conflict");
        sStatusTextMap.put(410, "HTTP/1.1 410 Gone");
        sStatusTextMap.put(411, "HTTP/1.1 411 Length Required");
        sStatusTextMap.put(412, "HTTP/1.1 412 Precondition Failed");
        sStatusTextMap.put(413, "HTTP/1.1 413 Reques Entity Too Large");
        sStatusTextMap.put(414, "HTTP/1.1 414 Request-URI Too Large");
        sStatusTextMap.put(415, "HTTP/1.1 415 Unsupported Media Type");
        sStatusTextMap.put(416, "HTTP/1.1 416 Requested range not satisfiable");
        sStatusTextMap.put(417, "HTTP/1.1 417 Expectation Failed");
        sStatusTextMap.put(500, "HTTP/1.1 500 Internal Server Error");
        sStatusTextMap.put(501, "HTTP/1.1 501 Not Implemented");
        sStatusTextMap.put(502, "HTTP/1.1 502 Bad Gateway");
        sStatusTextMap.put(503, "HTTP/1.1 503 Service Unavailable");
        sStatusTextMap.put(504, "HTTP/1.1 504 Gateway Time-out");
        sStatusTextMap.put(505, "HTTP/1.1 505 HTTP Version not supported");
        sStatusTextMap.put(102, "HTTP/1.1 102 Processing");
        sStatusTextMap.put(207, "HTTP/1.1 207 Multi-Status");
        sStatusTextMap.put(422, "HTTP/1.1 422 Unprocessable Entity");
        sStatusTextMap.put(423, "HTTP/1.1 423 Locked");
        sStatusTextMap.put(424, "HTTP/1.1 424 Failed Dependency");
        sStatusTextMap.put(507, "HTTP/1.1 507 Insufficient Storage");
    }

    public static class PropStat {
        private HashMap<Integer, Element> mMap;
        private ArrayList<ResourceProperty> mProps = new ArrayList();

        public PropStat() {
            this.mMap = new HashMap();
        }

        public void toResponse(DavContext ctxt, Element response, boolean nameOnly) {
            Element propElem = this.findProp(200);
            for (ResourceProperty prop : this.mProps) {
                prop.toElement(ctxt, propElem, nameOnly);
            }
            for (Integer code : this.mMap.keySet()) {
                response.add(this.mMap.get(code));
            }
        }

        public void add(ResourceProperty prop) {
            this.mProps.add(prop);
        }

        public void add(QName name, String msg, int code) {
            Element e = this.findProp(code).addElement(name);
            if (msg != null) {
                e.setText(msg);
            }
        }

        public void add(QName name, Element value) {
            value.detach();
            Element prop = this.findProp(200);
            Branch e = null;
            for (Object obj : prop.elements()) {
                if (!(obj instanceof Element) || !((Element)obj).getQName().equals(name)) continue;
                e = (Element)obj;
                break;
            }
            if (e == null) {
                e = prop.addElement(name);
            }
            e.add(value);
        }

        private Element findProp(int status) {
            Element propstat = this.findPropstat(status);
            return propstat.element(DavElements.E_PROP);
        }

        private Element findPropstat(int status) {
            Element propStat = this.mMap.get(status);
            if (propStat == null) {
                propStat = DocumentHelper.createElement(DavElements.E_PROPSTAT);
                propStat.addElement(DavElements.E_STATUS).setText(sStatusTextMap.get(status));
                propStat.addElement(DavElements.E_PROP);
                this.mMap.put(status, propStat);
            }
            return propStat;
        }
    }
}

