/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.service.DavResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.io.XMLWriter;

public abstract class DavMethod {
    protected static final int STATUS_OK = 200;

    public abstract String getName();

    public abstract void handle(DavContext var1) throws DavException, IOException, ServiceException;

    public void checkPrecondition(DavContext ctxt) throws DavException {
    }

    public void checkPostcondition(DavContext ctxt) throws DavException {
    }

    public String toString() {
        return "DAV method " + this.getName();
    }

    public String getMethodName() {
        return this.getName();
    }

    protected void sendResponse(DavContext ctxt) throws IOException {
        if (ctxt.isResponseSent()) {
            return;
        }
        HttpServletResponse resp = ctxt.getResponse();
        resp.setStatus(ctxt.getStatus());
        String compliance = ctxt.getDavCompliance();
        if (compliance != null) {
            DavMethod.setResponseHeader(resp, "DAV", compliance);
        }
        if (ctxt.hasResponseMessage()) {
            resp.setContentType("text/xml; charset=\"UTF-8\"");
            DavResponse respMsg = ctxt.getDavResponse();
            respMsg.writeTo((OutputStream)resp.getOutputStream());
        }
        ctxt.responseSent();
    }

    public static void setResponseHeader(HttpServletResponse resp, String name, String value) {
        while (value != null) {
            String val = value;
            if (value.length() > 70) {
                int index = value.lastIndexOf(44, 70);
                if (index == -1) {
                    ZimbraLog.dav.warn("header value is too long for %s : %s", name, value);
                    return;
                }
                val = value.substring(0, index);
                value = value.substring(index + 1).trim();
            } else {
                value = null;
            }
            resp.addHeader(name, val);
        }
    }

    public HttpMethod toHttpMethod(DavContext ctxt, String targetUrl) throws IOException, DavException {
        if (ctxt.getUpload() != null && ctxt.getUpload().getSize() > 0L) {
            PostMethod method = new PostMethod(targetUrl){

                public String getName() {
                    return DavMethod.this.getMethodName();
                }
            };
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (ctxt.hasRequestMessage()) {
                XMLWriter writer = new XMLWriter(baos);
                writer.write(ctxt.getRequestMessage());
            } else {
                ByteUtil.copy(ctxt.getUpload().getInputStream(), true, baos, false);
            }
            ByteArrayRequestEntity reqEntry = new ByteArrayRequestEntity(baos.toByteArray());
            method.setRequestEntity(reqEntry);
            return method;
        }
        return new GetMethod(targetUrl){

            public String getName() {
                return DavMethod.this.getMethodName();
            }
        };
    }
}

