/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.property.CalDavProperty;
import com.zimbra.cs.dav.property.CardDavProperty;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.Principal;
import com.zimbra.cs.dav.resource.RemoteCollection;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends Principal {
    private static QName[] SUPPORTED_REPORTS = new QName[]{DavElements.E_ACL_PRINCIPAL_PROP_SET, DavElements.E_PRINCIPAL_MATCH, DavElements.E_PRINCIPAL_PROPERTY_SEARCH, DavElements.E_PRINCIPAL_SEARCH_PROPERTY_SET, DavElements.E_EXPAND_PROPERTY};
    private static final String CALENDAR_PROXY_READ = "calendar-proxy-read";
    private static final String CALENDAR_PROXY_WRITE = "calendar-proxy-write";

    public User(DavContext ctxt, Account account, String url) throws ServiceException {
        super(account, url);
        this.mAccount = account;
        String user = this.getOwner();
        this.addProperty(CalDavProperty.getCalendarHomeSet(user));
        this.addProperty(CalDavProperty.getCalendarUserType(this));
        this.addProperty(CalDavProperty.getScheduleInboxURL(user));
        this.addProperty(CalDavProperty.getScheduleOutboxURL(user));
        if (ctxt.getAuthAccount().equals(account) && ctxt.useIcalDelegation()) {
            this.addProperty(new CalendarProxyReadFor(this.mAccount));
            this.addProperty(new CalendarProxyWriteFor(this.mAccount));
            this.addProperty(new ProxyGroupMembership());
        }
        this.addProperty(Acl.getPrincipalUrl(this));
        ArrayList<String> addrs = new ArrayList<String>();
        for (String addr : account.getMailDeliveryAddress()) {
            addrs.add(addr);
        }
        for (String alias : account.getMailAlias()) {
            addrs.add(alias);
        }
        addrs.add(url);
        this.addProperty(CalDavProperty.getCalendarUserAddressSet(addrs));
        this.addProperty(CardDavProperty.getAddressbookHomeSet(user));
        this.setProperty(DavElements.E_HREF, url);
        String cn = account.getAttr("cn");
        if (cn == null) {
            cn = account.getName();
        }
        this.setProperty(DavElements.E_DISPLAYNAME, cn);
        this.mUri = url;
    }

    @Override
    public Collection<DavResource> getChildren(DavContext ctxt) throws DavException {
        ArrayList<DavResource> proxies = new ArrayList<DavResource>();
        if (ctxt.useIcalDelegation()) {
            try {
                proxies.add(new CalendarProxyRead(this.getOwner(), this.mUri));
                proxies.add(new CalendarProxyWrite(this.getOwner(), this.mUri));
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return proxies;
    }

    @Override
    public void delete(DavContext ctxt) throws DavException {
        throw new DavException("cannot delete this resource", 403, null);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public void patchProperties(DavContext ctxt, Collection<Element> set, Collection<QName> remove) throws DavException, IOException {
    }

    @Override
    protected QName[] getSupportedReports() {
        return SUPPORTED_REPORTS;
    }

    private class CalendarProxyWriteFor
    extends ProxyProperty {
        public CalendarProxyWriteFor(Account acct) {
            super(DavElements.E_CALENDAR_PROXY_WRITE_FOR);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element proxy = super.toElement(ctxt, parent, true);
            if (nameOnly) {
                return proxy;
            }
            ArrayList<Pair<Mountpoint, ZFolder>> mps = this.getMountpoints(ctxt);
            for (Pair<Mountpoint, ZFolder> folder : mps) {
                try {
                    Account owner;
                    short rights = ACL.stringToRights(folder.getSecond().getEffectivePerms());
                    if ((rights & 2) <= 0 || (owner = Provisioning.getInstance().get(Provisioning.AccountBy.id, folder.getFirst().getOwnerId())) == null) continue;
                    proxy.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(User.this.mAccount, owner));
                }
                catch (ServiceException se) {
                    ZimbraLog.dav.warn((Object)"can't convert rights", se);
                }
            }
            return proxy;
        }
    }

    private class CalendarProxyReadFor
    extends ProxyProperty {
        public CalendarProxyReadFor(Account acct) {
            super(DavElements.E_CALENDAR_PROXY_READ_FOR);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element proxy = super.toElement(ctxt, parent, true);
            if (nameOnly) {
                return proxy;
            }
            ArrayList<Pair<Mountpoint, ZFolder>> mps = this.getMountpoints(ctxt);
            for (Pair<Mountpoint, ZFolder> folder : mps) {
                try {
                    Account owner;
                    short rights = ACL.stringToRights(folder.getSecond().getEffectivePerms());
                    if ((rights & 2) != 0 || (rights & 1) <= 0 || (owner = Provisioning.getInstance().get(Provisioning.AccountBy.id, folder.getFirst().getOwnerId())) == null) continue;
                    proxy.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(User.this.mAccount, owner));
                }
                catch (ServiceException se) {
                    ZimbraLog.dav.warn((Object)"can't convert rights", se);
                }
            }
            return proxy;
        }
    }

    private class ProxyGroupMemberSet
    extends ResourceProperty {
        private boolean mReadOnly;

        public ProxyGroupMemberSet(boolean readOnly) {
            super(DavElements.E_GROUP_MEMBER_SET);
            this.mReadOnly = readOnly;
            this.setProtected(true);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element group = super.toElement(ctxt, parent, nameOnly);
            if (nameOnly) {
                return group;
            }
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(User.this.mAccount);
                Folder f = mbox.getFolderById(ctxt.getOperationContext(), 10);
                if (f == null) {
                    return group;
                }
                ACL acl = f.getEffectiveACL();
                if (acl == null) {
                    return group;
                }
                for (ACL.Grant g : acl.getGrants()) {
                    if (g.getGranteeType() != 1) continue;
                    boolean bl = this.mReadOnly ? (g.getGrantedRights() & 1) != 0 && (g.getGrantedRights() & 2) == 0 : (g.getGrantedRights() & 2) != 0;
                    boolean match = bl;
                    if (!match) continue;
                    Account user = Provisioning.getInstance().get(Provisioning.AccountBy.id, g.getGranteeId());
                    group.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(User.this.mAccount, user));
                }
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"can't get mailbox", se);
            }
            return group;
        }
    }

    private class ProxyGroupMembership
    extends ProxyProperty {
        public ProxyGroupMembership() {
            super(DavElements.E_GROUP_MEMBERSHIP);
            this.setProtected(true);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element group = super.toElement(ctxt, parent, true);
            if (nameOnly) {
                return group;
            }
            ArrayList<Pair<Mountpoint, ZFolder>> mps = this.getMountpoints(ctxt);
            for (Pair<Mountpoint, ZFolder> folder : mps) {
                try {
                    Account owner;
                    short rights = ACL.stringToRights(folder.getSecond().getEffectivePerms());
                    if ((rights & 2) > 0) {
                        owner = Provisioning.getInstance().get(Provisioning.AccountBy.id, folder.getFirst().getOwnerId());
                        if (owner == null) continue;
                        group.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(User.this.mAccount, owner) + User.CALENDAR_PROXY_WRITE);
                        continue;
                    }
                    if ((rights & 1) <= 0 || (owner = Provisioning.getInstance().get(Provisioning.AccountBy.id, folder.getFirst().getOwnerId())) == null) continue;
                    group.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(User.this.mAccount, owner) + User.CALENDAR_PROXY_READ);
                }
                catch (ServiceException se) {
                    ZimbraLog.dav.warn((Object)"can't convert rights", se);
                }
            }
            return group;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProxyProperty
    extends ResourceProperty {
        public ProxyProperty(QName name) {
            super(name);
        }

        protected ArrayList<Pair<Mountpoint, ZFolder>> getMountpoints(DavContext ctxt) {
            ArrayList<Pair<Mountpoint, ZFolder>> mps = new ArrayList<Pair<Mountpoint, ZFolder>>();
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(User.this.mAccount);
                for (MailItem item : mbox.getItemList(ctxt.getOperationContext(), (byte)13)) {
                    Mountpoint mp = (Mountpoint)item;
                    ZAuthToken zat = AuthProvider.getAuthToken(ctxt.getAuthAccount()).toZAuthToken();
                    ZMailbox zmbx = RemoteCollection.getRemoteMailbox(zat, mp.getOwnerId());
                    ZFolder folder = zmbx.getFolderById(mp.getTarget().toString(User.this.mAccount));
                    if (folder == null) continue;
                    mps.add(new Pair<Mountpoint, ZFolder>(mp, folder));
                }
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"can't get mailbox", se);
            }
            return mps;
        }
    }

    private class CalendarProxyWrite
    extends Principal {
        public CalendarProxyWrite(String user2, String url) throws ServiceException {
            super(user2, url + User.CALENDAR_PROXY_WRITE);
            this.addResourceType(DavElements.E_CALENDAR_PROXY_WRITE);
            this.addProperty(Acl.getPrincipalUrl(this));
            this.addProperty(new ProxyGroupMemberSet(false));
        }

        public boolean isCollection() {
            return true;
        }
    }

    private class CalendarProxyRead
    extends Principal {
        public CalendarProxyRead(String user2, String url) throws ServiceException {
            super(user2, url + User.CALENDAR_PROXY_READ);
            this.addResourceType(DavElements.E_CALENDAR_PROXY_READ);
            this.addProperty(Acl.getPrincipalUrl(this));
            this.addProperty(new ProxyGroupMemberSet(true));
        }

        public boolean isCollection() {
            return true;
        }
    }
}

