/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.AddressObject;
import com.zimbra.cs.dav.resource.AddressbookCollection;
import com.zimbra.cs.dav.resource.Attachment;
import com.zimbra.cs.dav.resource.BrowseWrapper;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.CalendarObject;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.Notebook;
import com.zimbra.cs.dav.resource.PhantomResource;
import com.zimbra.cs.dav.resource.Principal;
import com.zimbra.cs.dav.resource.RemoteCalendarCollection;
import com.zimbra.cs.dav.resource.RemoteCollection;
import com.zimbra.cs.dav.resource.ScheduleInbox;
import com.zimbra.cs.dav.resource.ScheduleOutbox;
import com.zimbra.cs.dav.resource.SearchWrapper;
import com.zimbra.cs.dav.resource.User;
import com.zimbra.cs.dav.service.DavServlet;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlNamespace {
    public static final String ATTACHMENTS_PREFIX = "/attachments";
    public static final String PRINCIPALS = "principals";
    public static final String PRINCIPAL_USERS = "users";
    public static final String PRINCIPALS_PATH = "/principals/users/";
    public static final String ACL_USER = "/principals/users/";
    public static final String ACL_GUEST = "/principals/guests/";
    public static final String ACL_GROUP = "/principals/groups/";
    public static final String ACL_COS = "/principals/cos/";
    public static final String ACL_DOMAIN = "/principals/domain/";
    private static LRUMap sRenamedResourceMap = new LRUMap(100);

    public static UrlComponents parseUrl(String url) {
        int delim;
        UrlComponents uc = new UrlComponents();
        int index = url.indexOf("/dav");
        if (index > 0 && (delim = (url = url.substring(index + "/dav".length())).indexOf(47, 1)) > 0) {
            uc.user = url.substring(1, delim);
            url = url.substring(delim);
        }
        uc.path = url;
        try {
            uc.path = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ZimbraLog.dav.debug("can't decode url %s", (Object)url, e);
        }
        return uc;
    }

    public static Collection getCollectionAtUrl(DavContext ctxt, String url) throws DavException {
        DavResource rsc;
        int index;
        UrlComponents uc = UrlNamespace.parseUrl(url);
        int lastPos = uc.path.length() - 1;
        if (uc.path.endsWith("/")) {
            --lastPos;
        }
        String path = (index = uc.path.lastIndexOf(47, lastPos)) == -1 ? "/" : uc.path.substring(0, index);
        String user = uc.user;
        if (user == null) {
            user = ctxt.getUser();
        }
        if ((rsc = UrlNamespace.getResourceAt(ctxt, user, path)) instanceof Collection) {
            return (Collection)rsc;
        }
        throw new DavException("invalid uri", 404, null);
    }

    public static DavResource getResourceAtUrl(DavContext ctxt, String url) throws DavException {
        if (url.indexOf("/principals/users/") >= 0) {
            return UrlNamespace.getPrincipalAtUrl(ctxt, url);
        }
        UrlComponents uc = UrlNamespace.parseUrl(url);
        if (uc.user == null || uc.path == null) {
            throw new DavException("invalid uri", 404, null);
        }
        return UrlNamespace.getResourceAt(ctxt, uc.user, uc.path);
    }

    public static DavResource getPrincipalAtUrl(DavContext ctxt, String url) throws DavException {
        ZimbraLog.dav.debug("getPrincipalAtUrl");
        String name = ctxt.getAuthAccount().getName();
        if (url != null) {
            int index = url.indexOf("/principals/users/");
            if (index == -1 || url.endsWith("/principals/users/")) {
                try {
                    return new Principal(ctxt.getAuthAccount(), url);
                }
                catch (ServiceException se) {
                    throw new DavException("invalid uri", 404, se);
                }
            }
            name = url.substring(index += "/principals/users/".length());
            if (name.indexOf(47) > 0) {
                name = name.substring(0, name.indexOf(47));
            }
            ZimbraLog.dav.debug("name: " + name);
        } else {
            url = "/";
        }
        try {
            Account a = Provisioning.getInstance().get(Provisioning.AccountBy.name, name);
            if (a == null) {
                throw new DavException("user not found", 404, null);
            }
            return new User(ctxt, a, url);
        }
        catch (ServiceException se) {
            throw new DavException("user not found", 404, null);
        }
    }

    public static DavResource getPrincipal(DavContext ctxt, Account acct) throws DavException {
        try {
            return new User(ctxt, acct, UrlNamespace.getPrincipalUrl(acct.getName()));
        }
        catch (ServiceException se) {
            throw new DavException("user not found", 404, null);
        }
    }

    public static DavResource getResourceAt(DavContext ctxt, String user, String path) throws DavException {
        ZimbraLog.dav.debug("getResource at " + user + " " + path);
        if (path == null) {
            throw new DavException("invalid uri", 404, null);
        }
        java.util.Collection<DavResource> rss = UrlNamespace.getResources(ctxt, user, path, false);
        if (rss.size() > 0) {
            return rss.iterator().next();
        }
        return null;
    }

    public static java.util.Collection<DavResource> getResources(DavContext ctxt, String user, String path, boolean includeChildren) throws DavException {
        DavResource resource;
        ArrayList<DavResource> rss;
        block12: {
            rss = new ArrayList<DavResource>();
            if (user.equals("")) {
                try {
                    rss.add(new Principal(ctxt.getAuthAccount(), "/dav"));
                    return rss;
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            String target = path.toLowerCase();
            resource = null;
            if (target.startsWith(ATTACHMENTS_PREFIX)) {
                resource = UrlNamespace.getPhantomResource(ctxt, user);
            } else {
                try {
                    resource = UrlNamespace.getMailItemResource(ctxt, user, path);
                }
                catch (ServiceException se) {
                    if (path.length() == 1 && path.charAt(0) == '/' && se.getCode().equals("service.PERM_DENIED")) {
                        ctxt.setCollectionPath("/");
                        try {
                            return UrlNamespace.getFolders(ctxt, user);
                        }
                        catch (ServiceException e) {
                            ZimbraLog.dav.warn((Object)("can't get folders for " + user), e);
                            break block12;
                        }
                    }
                    ZimbraLog.dav.warn((Object)("can't get mail item resource for " + user + ", " + path), se);
                }
            }
        }
        if (resource != null) {
            rss.add(resource);
        }
        if (resource != null && includeChildren) {
            rss.addAll(resource.getChildren(ctxt));
        }
        return rss;
    }

    public static DavResource getResourceByItemId(DavContext ctxt, String user, int id) throws ServiceException, DavException {
        MailItem item = UrlNamespace.getMailItemById(ctxt, user, id);
        return UrlNamespace.getResourceFromMailItem(ctxt, item);
    }

    public static String getAclUrl(String principal, String type) throws DavException {
        Account account = null;
        Provisioning prov = Provisioning.getInstance();
        try {
            account = prov.get(Provisioning.AccountBy.id, principal);
            StringBuilder buf = new StringBuilder();
            buf.append(type);
            if (account != null) {
                buf.append(account.getName());
            } else {
                buf.append(principal);
            }
            return UrlNamespace.getAbsoluteUrl(null, buf.toString());
        }
        catch (ServiceException e) {
            throw new DavException("cannot create ACL URL for principal " + principal, 500, e);
        }
    }

    public static String getRawResourceUrl(DavResource rs) {
        return "/dav/" + rs.getOwner() + rs.getUri();
    }

    public static String getResourceUrl(DavResource rs) {
        return URLUtil.urlEscape(UrlNamespace.getRawResourceUrl(rs));
    }

    public static String getPrincipalUrl(Account account) {
        return UrlNamespace.getPrincipalUrl(account, account);
    }

    private static boolean onSameServer(Account thisOne, Account thatOne) {
        if (thisOne.getId().equals(thatOne.getId())) {
            return true;
        }
        try {
            Provisioning prov = Provisioning.getInstance();
            Server mine = prov.getServer(thisOne);
            Server theirs = prov.getServer(thatOne);
            if (mine != null && theirs != null) {
                return mine.getId().equals(theirs.getId());
            }
        }
        catch (Exception e) {
            ZimbraLog.dav.warn("can't get domain or server for %s %s", (Object)thisOne.getId(), (Object)thatOne.getId(), e);
        }
        return true;
    }

    public static String getPrincipalUrl(Account authAccount, Account targetAccount) {
        String url = UrlNamespace.getPrincipalUrl(targetAccount.getName());
        if (!UrlNamespace.onSameServer(authAccount, targetAccount)) {
            try {
                url = UrlNamespace.getAbsoluteUrl(targetAccount, url);
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)("can't generate absolute url for " + targetAccount.getName()), se);
            }
        }
        return url;
    }

    public static String getPrincipalUrl(String user) {
        return URLUtil.urlEscape("/principals/users/" + user + "/");
    }

    public static String getPrincipalCollectionUrl(Account acct) throws ServiceException {
        return URLUtil.urlEscape("/principals/users/");
    }

    public static String getResourceUrl(Account user, String path) throws ServiceException {
        return UrlNamespace.getAbsoluteUrl(user, "/dav/" + user.getName() + path);
    }

    private static String getAbsoluteUrl(Account user, String path) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Domain domain = null;
        Server server = prov.getLocalServer();
        if (user != null) {
            domain = prov.getDomain(user);
            server = prov.getServer(user);
        }
        return DavServlet.getServiceUrl(server, domain, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRenamedResource(String user, String path, DavResource rsc) {
        LRUMap lRUMap = sRenamedResourceMap;
        synchronized (lRUMap) {
            sRenamedResourceMap.put(new Pair<String, String>(user, path.toLowerCase()), new Pair<DavResource, Long>(rsc, System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavResource checkRenamedResource(String user, String path) {
        Pair<String, String> key = new Pair<String, String>(user, path.toLowerCase());
        DavResource rsc = null;
        LRUMap lRUMap = sRenamedResourceMap;
        synchronized (lRUMap) {
            Pair item = (Pair)sRenamedResourceMap.get(key);
            if (item != null) {
                long age = System.currentTimeMillis() - (Long)item.getSecond();
                if (age > 900000L) {
                    sRenamedResourceMap.remove(key);
                } else {
                    rsc = (DavResource)item.getFirst();
                }
            }
        }
        return rsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DavResource getMailItemResource(DavContext ctxt, String user, String path) throws ServiceException, DavException {
        void var9_12;
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        if (account == null) {
            throw new DavException("no such accout " + user, 404, null);
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        String id = null;
        int index = path.indexOf(63);
        if (index > 0) {
            Map<String, String> params = HttpUtil.getURIParams(path.substring(index + 1));
            path = path.substring(0, index);
            id = params.get("id");
        }
        OperationContext octxt = ctxt.getOperationContext();
        Object var9_9 = null;
        if (path.equals("/")) {
            Folder folder = mbox.getFolderByPath(octxt, "/");
        } else if (id != null) {
            MailItem mailItem = mbox.getItemById(octxt, Integer.parseInt(id), (byte)-1);
        }
        if (var9_12 != null) {
            return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_12);
        }
        try {
            return UrlNamespace.getResourceFromMailItem(ctxt, mbox.getItemByPath(octxt, path));
        }
        catch (MailServiceException.NoSuchItemException e) {
            void var9_20;
            DavResource rs = UrlNamespace.checkRenamedResource(user, path);
            if (rs != null) {
                return rs;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            index = path.lastIndexOf(47);
            String folderPath = path.substring(0, index);
            Folder f = null;
            if (index != -1) {
                try {
                    f = mbox.getFolderByPath(octxt, folderPath);
                }
                catch (MailServiceException.NoSuchItemException e2) {
                    // empty catch block
                }
            }
            if (f == null) return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
            if (path.toLowerCase().endsWith(".ics")) {
                String uid = path.substring(index + 1, path.length() - ".ics".length());
                if ((index = uid.indexOf(44)) > 0) {
                    id = uid.substring(index + 1);
                    MailItem mailItem = mbox.getItemById(octxt, Integer.parseInt(id), (byte)-1);
                    return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                } else {
                    CalendarItem calendarItem = mbox.getCalendarItemByUid(octxt, uid);
                }
                return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
            }
            if (path.toLowerCase().endsWith(".vcf")) {
                try {
                    ZimbraQueryResults zqr;
                    String uid;
                    block30: {
                        ZimbraHit hit;
                        uid = URLDecoder.decode(path.substring(index + 1, path.length() - ".vcf".length()), "UTF-8");
                        index = uid.indexOf(58);
                        if (index > 0) {
                            Contact contact = mbox.getContactById(octxt, Integer.parseInt(uid.substring(index + 1)));
                            return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                        }
                        zqr = null;
                        StringBuilder query = new StringBuilder();
                        query.append("#").append("vcardUID").append(":");
                        query.append(uid);
                        zqr = mbox.search(ctxt.getOperationContext(), query.toString(), new byte[]{6}, SortBy.NAME_ASCENDING, 10);
                        if (!zqr.hasNext() || !((hit = zqr.getNext()) instanceof ContactHit)) break block30;
                        Contact contact = ((ContactHit)hit).getContact();
                    }
                    Object var18_33 = null;
                    if (zqr == null) return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                    try {
                        zqr.doneWithSearchResults();
                        return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                    }
                    catch (ServiceException e3) {}
                    return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                    {
                        catch (Exception e4) {
                            ZimbraLog.dav.error((Object)("can't search for: uid=" + uid), e4);
                            Object var18_34 = null;
                            if (zqr == null) return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                            try {
                                zqr.doneWithSearchResults();
                                return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                            }
                            catch (ServiceException e3) {}
                            return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_35 = null;
                        if (zqr == null) throw throwable;
                        try {
                            zqr.doneWithSearchResults();
                            throw throwable;
                        }
                        catch (ServiceException e3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                catch (UnsupportedEncodingException e5) {
                    ZimbraLog.dav.warn("Can't decode URL %s", path);
                }
                return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
            }
            if (f.getId() != 2) return UrlNamespace.getResourceFromMailItem(ctxt, (MailItem)var9_20);
            ctxt.setPathInfo(path.substring(index + 1));
            return UrlNamespace.getResourceFromMailItem(ctxt, f);
        }
    }

    private static java.util.Collection<DavResource> getFolders(DavContext ctxt, String user) throws ServiceException, DavException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        if (account == null) {
            throw new DavException("no such accout " + user, 404, null);
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        OperationContext octxt = ctxt.getOperationContext();
        ArrayList<DavResource> rss = new ArrayList<DavResource>();
        for (Folder f : mbox.getVisibleFolders(octxt)) {
            rss.add(UrlNamespace.getResourceFromMailItem(ctxt, f));
        }
        return rss;
    }

    private static DavResource getCalendarItemForMessage(DavContext ctxt, Message msg) throws ServiceException {
        Mailbox mbox = msg.getMailbox();
        if (msg.isInvite() && msg.hasCalendarItemInfos()) {
            Message.CalendarItemInfo calItemInfo = msg.getCalendarItemInfo(0);
            try {
                Invite invite = calItemInfo.getInvite();
                if (invite == null && calItemInfo.getCalendarItemId() != 0) {
                    CalendarItem item = mbox.getCalendarItemById(ctxt.getOperationContext(), calItemInfo.getCalendarItemId());
                    invite = calItemInfo.getInvite();
                    int compNum = calItemInfo.getComponentNo();
                    invite = item.getInvite(msg.getId(), compNum);
                }
                if (invite != null) {
                    String path = CalendarObject.CalendarPath.generate(ctxt, msg.getPath(), invite.getUid(), msg.getId());
                    return new CalendarObject.ScheduleMessage(ctxt, path, ctxt.getUser(), invite, msg);
                }
            }
            catch (MailServiceException.NoSuchItemException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static DavResource getResourceFromMailItem(DavContext ctxt, MailItem item) throws DavException {
        DavResource resource = null;
        if (item == null) {
            return resource;
        }
        byte itemType = item.getType();
        try {
            switch (itemType) {
                case 13: {
                    Mountpoint mp = (Mountpoint)item;
                    byte viewType = mp.getDefaultView();
                    if (!ctxt.useIcalDelegation() && viewType == 11) {
                        resource = new RemoteCalendarCollection(ctxt, mp);
                        break;
                    }
                    resource = new RemoteCollection(ctxt, mp);
                    break;
                }
                case 1: {
                    Folder f = (Folder)item;
                    byte viewType = f.getDefaultView();
                    if (f.getId() == 2 && ctxt.isSchedulingEnabled()) {
                        resource = new ScheduleInbox(ctxt, f);
                        break;
                    }
                    if (f.getId() == 5 && ctxt.isSchedulingEnabled()) {
                        resource = new ScheduleOutbox(ctxt, f);
                        break;
                    }
                    if (viewType == 11 || viewType == 15) {
                        resource = UrlNamespace.getCalendarCollection(ctxt, f);
                        break;
                    }
                    if (viewType == 6) {
                        resource = new AddressbookCollection(ctxt, f);
                        break;
                    }
                    resource = new Collection(ctxt, f);
                    break;
                }
                case 8: 
                case 14: {
                    resource = new Notebook(ctxt, (Document)item);
                    break;
                }
                case 11: 
                case 15: {
                    resource = new CalendarObject.LocalCalendarObject(ctxt, (CalendarItem)item);
                    break;
                }
                case 5: {
                    resource = UrlNamespace.getCalendarItemForMessage(ctxt, (Message)item);
                    break;
                }
                case 6: {
                    resource = new AddressObject(ctxt, (Contact)item);
                }
            }
        }
        catch (ServiceException e) {
            resource = null;
            ZimbraLog.dav.info((Object)"cannot create DavResource", e);
        }
        return resource;
    }

    private static MailItemResource getCalendarCollection(DavContext ctxt, Folder f) throws ServiceException, DavException {
        String[] homeSets = Provisioning.getInstance().getConfig().getMultiAttr("zimbraCalendarCalDavAlternateCalendarHomeSet");
        if (homeSets.length > 0 && (f.getId() == 10 || f.getId() == 15)) {
            return new Collection(ctxt, f);
        }
        if (f.getDefaultView() == 11 && !ctxt.getAuthAccount().isFeatureCalendarEnabled()) {
            return new Collection(ctxt, f);
        }
        if (f.getDefaultView() == 15 && !ctxt.getAuthAccount().isFeatureTasksEnabled()) {
            return new Collection(ctxt, f);
        }
        return new CalendarCollection(ctxt, f);
    }

    private static DavResource getPhantomResource(DavContext ctxt, String user) throws DavException {
        PhantomResource resource;
        String target = ctxt.getPath();
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(target, "/");
        int numTokens = tok.countTokens();
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        switch (numTokens) {
            case 1: 
            case 2: {
                resource = new BrowseWrapper(target, user, tokens);
                break;
            }
            case 3: {
                if (((String)tokens.get(1)).equals("by-date")) {
                    resource = new SearchWrapper(target, user, tokens);
                    break;
                }
                resource = new BrowseWrapper(target, user, tokens);
                break;
            }
            case 4: {
                if (((String)tokens.get(1)).equals("by-date")) {
                    resource = new Attachment(target, user, tokens, ctxt);
                    break;
                }
                resource = new SearchWrapper(target, user, tokens);
                break;
            }
            case 5: {
                resource = new Attachment(target, user, tokens, ctxt);
                break;
            }
            default: {
                resource = null;
            }
        }
        return resource;
    }

    private static MailItem getMailItemById(DavContext ctxt, String user, int id) throws DavException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        if (account == null) {
            throw new DavException("no such accout " + user, 404, null);
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        return mbox.getItemById(ctxt.getOperationContext(), id, (byte)-1);
    }

    public static Account getPrincipal(String principalUrl) throws ServiceException {
        int index = principalUrl.indexOf("/principals/users/");
        if (index == -1) {
            return null;
        }
        String acct = principalUrl.substring(index + "/principals/users/".length());
        Provisioning prov = Provisioning.getInstance();
        return prov.get(Provisioning.AccountBy.name, acct);
    }

    public static class UrlComponents {
        public String user;
        public String path;
    }
}

