/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.resource.Attachment;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.PhantomResource;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchWrapper
extends PhantomResource {
    protected static final long DAY_IN_MS = 86400000L;
    protected static final long WEEK_IN_MS = 604800000L;
    protected static final long MONTH_IN_MS = 2419200000L;
    protected static final int SEARCH_LIMIT = 100;
    private String mContentType = null;
    private StringBuilder mQuery = new StringBuilder();
    private static HashMap<String, String> sCTMap = new HashMap();

    public SearchWrapper(String uri, String owner) {
        this(uri, owner, SearchWrapper.parseUri(uri));
    }

    public SearchWrapper(String uri, String owner, List<String> tokens) {
        super(uri, owner, tokens);
        this.mQuery.append("has:attachment ");
        String prevToken = null;
        for (String token : tokens) {
            this.buildQuery(prevToken, token);
            prevToken = token;
        }
    }

    private void buildQuery(String prevTerm, String term) {
        if (term.equals("today")) {
            this.mQuery.append("after:\"-1day\" ");
        } else if (term.equals("last-week")) {
            this.mQuery.append("after:\"-1week\" ");
        } else if (term.equals("last-month")) {
            this.mQuery.append("after:\"-1month\" ");
        } else if (term.equals("last-year")) {
            this.mQuery.append("after:\"-1year\" ");
        } else if ("by-sender".equals(prevTerm)) {
            this.mQuery.append("from:(@" + term + ") ");
        } else if ("by-type".equals(prevTerm)) {
            this.mQuery.append("attachment:\"" + term + "\" ");
            if (!term.equals("any")) {
                this.mContentType = SearchWrapper.getActualContentType(term);
            }
        }
    }

    private static String getActualContentType(String str) {
        String v = sCTMap.get(str);
        if (v != null) {
            return v;
        }
        return str;
    }

    @Override
    public InputStream getContent(DavContext ctxt) {
        return null;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<DavResource> getChildren(DavContext ctxt) {
        ArrayList<DavResource> children = new ArrayList<DavResource>();
        String user = ctxt.getUser();
        Provisioning prov = Provisioning.getInstance();
        ZimbraQueryResults zqr = null;
        Account account = prov.get(Provisioning.AccountBy.name, user);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        SearchParams params = new SearchParams();
        params.setQueryStr(this.mQuery.toString());
        params.setTypes(SEARCH_TYPES);
        params.setSortBy(SortBy.NAME_ASCENDING);
        params.setMode(Mailbox.SearchResultMode.NORMAL);
        params.setPrefetch(true);
        params.setChunkSize(100);
        params.setLimit(100);
        zqr = mbox.search(SoapProtocol.Soap12, ctxt.getOperationContext(), params);
        while (zqr.hasNext()) {
            ZimbraHit hit = zqr.getNext();
            if (!(hit instanceof MessageHit)) continue;
            this.addAttachmentResources((MessageHit)hit, children);
        }
        Object var11_11 = null;
        if (zqr == null) return children;
        try {
            zqr.doneWithSearchResults();
            return children;
        }
        catch (ServiceException e2) {}
        return children;
        {
            catch (Exception e) {
                ZimbraLog.dav.error((Object)("can't search: uri=" + this.getUri()), e);
                Object var11_12 = null;
                if (zqr == null) return children;
                try {
                    zqr.doneWithSearchResults();
                    return children;
                }
                catch (ServiceException e2) {}
                return children;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (zqr == null) throw throwable;
            try {
                zqr.doneWithSearchResults();
                throw throwable;
            }
            catch (ServiceException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void addAttachmentResources(MessageHit hit, List<DavResource> children) {
        try {
            Message msg = hit.getMessage();
            List<MPartInfo> parts = Mime.getParts(msg.getMimeMessage());
            for (MPartInfo p : parts) {
                String name = p.getFilename();
                String ct = p.getContentType();
                if (this.mContentType != null && ct != null && !ct.startsWith(this.mContentType) || name == null || name.length() <= 0) continue;
                children.add(new Attachment(this.getUri() + name, this.getOwner(), msg.getDate(), p.getSize()));
            }
        }
        catch (Exception e) {
            ZimbraLog.dav.error((Object)("can't get attachments from msg: itemid:" + hit.getItemId()), e);
        }
    }

    static {
        sCTMap.put("ppt", "application/vnd.ms-powerpoint");
        sCTMap.put("excel", "application/vnd.ms-excel");
        sCTMap.put("word", "application/msword");
        sCTMap.put("pdf", "application/pdf");
    }
}

