/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyQuery;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.util.AccountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.dom4j.Element;

public class ScheduleOutbox
extends Collection {
    public ScheduleOutbox(DavContext ctxt, Folder f) throws DavException, ServiceException {
        super(ctxt, f);
        this.addResourceType(DavElements.E_SCHEDULE_OUTBOX);
    }

    public void handlePost(DavContext ctxt) throws DavException, IOException, ServiceException {
        String originator = ctxt.getRequest().getHeader("Originator");
        Enumeration recipients = ctxt.getRequest().getHeaders("Recipient");
        InputStream in = ctxt.getUpload().getInputStream();
        ZCalendar.ZVCalendar vcalendar = ZCalendar.ZCalendarBuilder.build(in, "utf-8");
        Iterator<ZCalendar.ZComponent> iter = vcalendar.getComponentIterator();
        ZCalendar.ZComponent req = null;
        while (iter.hasNext() && (req = iter.next()).getTok() == ZCalendar.ICalTok.VTIMEZONE) {
            req = null;
        }
        if (req == null) {
            throw new DavException("empty request", 400);
        }
        ZimbraLog.dav.debug("originator: " + originator);
        ArrayList<String> rcptArray = new ArrayList<String>();
        while (recipients.hasMoreElements()) {
            String rcpt = (String)recipients.nextElement();
            if (rcpt.indexOf(44) > 0) {
                String[] rcpts = rcpt.split(",");
                Collections.addAll(rcptArray, rcpts);
                continue;
            }
            rcptArray.add(rcpt);
        }
        Element scheduleResponse = ctxt.getDavResponse().getTop(DavElements.E_SCHEDULE_RESPONSE);
        block6: for (String rcpt : rcptArray) {
            rcpt = rcpt.trim();
            ZimbraLog.dav.debug("recipient email: " + rcpt);
            Element resp = scheduleResponse.addElement(DavElements.E_CALDAV_RESPONSE);
            switch (req.getTok()) {
                case VFREEBUSY: {
                    this.handleFreebusyRequest(ctxt, req, originator, rcpt, resp);
                    continue block6;
                }
                case VEVENT: {
                    this.handleEventRequest(ctxt, vcalendar, req, originator, rcpt, resp);
                    continue block6;
                }
            }
            throw new DavException("unrecognized request: " + (Object)((Object)req.getTok()), 400);
        }
    }

    private void handleFreebusyRequest(DavContext ctxt, ZCalendar.ZComponent vfreebusy, String originator, String rcpt, Element resp) throws DavException, ServiceException {
        long end;
        long start;
        ZCalendar.ZProperty dtstartProp = vfreebusy.getProperty(ZCalendar.ICalTok.DTSTART);
        ZCalendar.ZProperty dtendProp = vfreebusy.getProperty(ZCalendar.ICalTok.DTEND);
        ZCalendar.ZProperty durationProp = vfreebusy.getProperty(ZCalendar.ICalTok.DURATION);
        if (dtstartProp == null || dtendProp == null && durationProp == null) {
            throw new DavException("missing dtstart or dtend/duration in the schedule request", 400, null);
        }
        try {
            ParsedDateTime startTime = ParsedDateTime.parseUtcOnly(dtstartProp.getValue());
            start = startTime.getUtcTime();
            if (dtendProp != null) {
                end = ParsedDateTime.parseUtcOnly(dtendProp.getValue()).getUtcTime();
            } else {
                ParsedDuration dur = ParsedDuration.parse(durationProp.getValue());
                ParsedDateTime endTime = startTime.add(dur);
                end = endTime.getUtcTime();
            }
        }
        catch (ParseException pe) {
            throw new DavException("can't parse date", 400, pe);
        }
        ZimbraLog.dav.debug("rcpt: " + rcpt + ", start: " + new Date(start) + ", end: " + new Date(end));
        FreeBusy fb = null;
        if (ctxt.isFreebusyEnabled()) {
            FreeBusyQuery fbQuery = new FreeBusyQuery(ctxt.getRequest(), ctxt.getAuthAccount(), start, end, null);
            fbQuery.addEmailAddress(this.getAddressFromPrincipalURL(rcpt), -1);
            java.util.Collection<FreeBusy> fbResult = fbQuery.getResults();
            if (fbResult.size() > 0) {
                fb = fbResult.iterator().next();
            }
        }
        if (fb != null) {
            String fbMsg = fb.toVCalendar(FreeBusy.Method.REPLY, originator, rcpt, null);
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("2.0;Success");
            resp.addElement(DavElements.E_CALENDAR_DATA).setText(fbMsg);
        } else {
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("5.3;No f/b for the user");
        }
    }

    private void handleEventRequest(DavContext ctxt, ZCalendar.ZVCalendar cal, ZCalendar.ZComponent req, String originator, String rcpt, Element resp) throws ServiceException, DavException {
        String subject;
        InternetAddress sender;
        InternetAddress from;
        if (!ctxt.isSchedulingEnabled()) {
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("5.3;No scheduling for the user");
            return;
        }
        ArrayList<Address> recipients = new ArrayList<Address>();
        try {
            from = AccountUtil.getFriendlyEmailAddress(this.getMailbox(ctxt).getAccount());
            if (originator.toLowerCase().startsWith("mailto:")) {
                originator = originator.substring(7);
            }
            sender = new InternetAddress(originator);
            if (rcpt.toLowerCase().startsWith("mailto:")) {
                rcpt = rcpt.substring(7);
            }
            InternetAddress to = new InternetAddress(rcpt);
            recipients.add((Address)to);
        }
        catch (AddressException e) {
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("3.7;" + rcpt);
            return;
        }
        String status = req.getPropVal(ZCalendar.ICalTok.STATUS, "");
        String method = cal.getPropVal(ZCalendar.ICalTok.METHOD, "REQUEST");
        if (method.equals("REQUEST")) {
            ZCalendar.ZProperty organizerProp = req.getProperty(ZCalendar.ICalTok.ORGANIZER);
            if (organizerProp != null) {
                String organizerStr = this.getAddressFromPrincipalURL(new ZOrganizer(organizerProp).getAddress());
                if (!AccountUtil.addressMatchesAccount(this.getMailbox(ctxt).getAccount(), organizerStr)) {
                    ZimbraLog.dav.debug("scheduling appointment on behalf of %s", organizerStr);
                }
            }
            subject = "Meeting Request: ";
        } else if (method.equals("REPLY")) {
            ZCalendar.ZProperty attendeeProp = req.getProperty(ZCalendar.ICalTok.ATTENDEE);
            if (attendeeProp == null) {
                throw new DavException("missing property ATTENDEE", 400);
            }
            ZAttendee attendee = new ZAttendee(attendeeProp);
            String partStat = attendee.getPartStat();
            subject = partStat.equals("AC") ? "Accepted: " : (partStat.equals("TE") ? "Tentative: " : (partStat.equals("DE") ? "Declined: " : "Meeting Reply: "));
        } else {
            subject = "Meeting: ";
        }
        if (status.equals("CANCELLED")) {
            subject = "Meeting Cancelled: ";
        }
        subject = subject + req.getPropVal(ZCalendar.ICalTok.SUMMARY, "");
        String desc = req.getPropVal(ZCalendar.ICalTok.DESCRIPTION, "");
        String descHtml = req.getDescriptionHtml();
        String uid = req.getPropVal(ZCalendar.ICalTok.UID, null);
        if (uid == null) {
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("3.1;UID");
            return;
        }
        try {
            MimeMessage mm = CalendarMailSender.createCalendarMessage((Address)from, (Address)sender, recipients, subject, desc, descHtml, uid, cal);
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(ctxt.getAuthAccount());
            mbox.getMailSender().sendMimeMessage(ctxt.getOperationContext(), mbox, true, mm, null, null, null, null, null, true, false);
        }
        catch (ServiceException e) {
            resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
            resp.addElement(DavElements.E_REQUEST_STATUS).setText("5.1");
            return;
        }
        resp.addElement(DavElements.E_RECIPIENT).setText(rcpt);
        resp.addElement(DavElements.E_REQUEST_STATUS).setText("2.0;Success");
    }

    protected String getAddressFromPrincipalURL(String url) throws ServiceException, DavException {
        if ((url = url.trim()).startsWith("http://")) {
            int pos = url.indexOf("/service/dav/");
            if (pos != -1) {
                int start = pos + 13;
                int end = url.indexOf("/", start);
                String userId = end == -1 ? url.substring(start) : url.substring(start, end);
                Account organizer = Provisioning.getInstance().get(Provisioning.AccountBy.name, userId);
                if (organizer == null) {
                    throw new DavException("user not found: " + userId, 400, null);
                }
                return organizer.getName();
            }
        } else if (url.toLowerCase().startsWith("mailto:")) {
            while (url.toLowerCase().startsWith("mailto:")) {
                url = url.substring(7);
            }
        }
        return url;
    }
}

