/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.dav.property.CalDavProperty;
import com.zimbra.cs.dav.resource.CalendarCollection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleInbox
extends CalendarCollection {
    protected static final byte[] SEARCH_TYPES = new byte[]{5};

    public ScheduleInbox(DavContext ctxt, Folder f) throws DavException, ServiceException {
        super(ctxt, f);
        this.addResourceType(DavElements.E_SCHEDULE_INBOX);
        String user = this.getOwner();
        this.addProperty(CalDavProperty.getCalendarFreeBusySet(user, this.getCalendarFolders(ctxt)));
    }

    @Override
    public Collection<DavResource> getChildren(DavContext ctxt, TimeRange tr) throws DavException {
        try {
            return this.getAppointmentsByUids(ctxt, null);
        }
        catch (ServiceException se) {
            ZimbraLog.dav.error((Object)("can't get schedule messages in folder " + this.getId()), se);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<DavResource> getAppointmentsByUids(DavContext ctxt, List<String> hrefs) throws ServiceException, DavException {
        ArrayList<DavResource> result = new ArrayList<DavResource>();
        if (!ctxt.isSchedulingEnabled()) {
            return result;
        }
        Account target = null;
        Provisioning prov = Provisioning.getInstance();
        if (ctxt.getPathInfo() != null) {
            target = prov.getAccountByName(ctxt.getPathInfo());
        }
        String query = "is:invite is:unread inid:" + this.getId() + " after:\"-1month\" ";
        Mailbox mbox = this.getMailbox(ctxt);
        ZimbraQueryResults zqr = null;
        zqr = mbox.search(ctxt.getOperationContext(), query, SEARCH_TYPES, SortBy.NAME_ASCENDING, 100);
        while (zqr.hasNext()) {
            DavResource rs;
            Account apptRcpt;
            ZimbraHit hit = zqr.getNext();
            if (!(hit instanceof MessageHit)) continue;
            Message msg = ((MessageHit)hit).getMessage();
            if (target == null && msg.getCalendarIntendedFor() != null || !msg.isInvite() || !msg.hasCalendarItemInfos() || "REPLY".equals(msg.getCalendarItemInfo(0).getInvite().getMethod()) || target != null && (msg.getCalendarIntendedFor() == null || (apptRcpt = prov.getAccountByName(msg.getCalendarIntendedFor())) == null || !apptRcpt.getId().equals(target.getId())) || (rs = UrlNamespace.getResourceFromMailItem(ctxt, msg)) == null) continue;
            String href = UrlNamespace.getRawResourceUrl(rs);
            if (hrefs == null || hrefs.contains(href)) {
                result.add(rs);
                continue;
            }
            result.add(new DavResource.InvalidResource(href, this.getOwner()));
        }
        Object var14_14 = null;
        if (zqr == null) return result;
        try {
            zqr.doneWithSearchResults();
            return result;
        }
        catch (ServiceException e2) {}
        return result;
        {
            catch (Exception e) {
                ZimbraLog.dav.error((Object)("can't search: uri=" + this.getUri()), e);
                Object var14_15 = null;
                if (zqr == null) return result;
                try {
                    zqr.doneWithSearchResults();
                    return result;
                }
                catch (ServiceException e2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (zqr == null) throw throwable;
            try {
                zqr.doneWithSearchResults();
                throw throwable;
            }
            catch (ServiceException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public void patchProperties(DavContext ctxt, Collection<Element> set, Collection<QName> remove) throws DavException, IOException {
        ArrayList<Element> newSet = null;
        for (Element el : set) {
            if (!el.getQName().equals(DavElements.E_CALENDAR_FREE_BUSY_SET)) continue;
            Iterator hrefs = el.elementIterator(DavElements.E_HREF);
            ArrayList<String> urls = new ArrayList<String>();
            while (hrefs.hasNext()) {
                urls.add(((Element)hrefs.next()).getText());
            }
            try {
                this.updateCalendarFreeBusySet(ctxt, urls);
            }
            catch (ServiceException e) {
                ctxt.getResponseProp().addPropError(DavElements.E_CALENDAR_FREE_BUSY_SET, new DavException("error", 424));
            }
            catch (DavException e) {
                ctxt.getResponseProp().addPropError(DavElements.E_CALENDAR_FREE_BUSY_SET, e);
            }
            if (newSet == null) {
                newSet = new ArrayList<Element>(set);
            }
            newSet.remove(el);
        }
        if (newSet != null) {
            set = newSet;
        }
        super.patchProperties(ctxt, set, remove);
    }

    private void updateCalendarFreeBusySet(DavContext ctxt, ArrayList<String> urls) throws ServiceException, DavException {
        String prefix = "/dav/" + this.getOwner();
        Mailbox mbox = this.getMailbox(ctxt);
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        for (Folder f : this.getCalendarFolders(ctxt)) {
            folders.put(f.getPath(), f);
        }
        for (String url : urls) {
            Folder f;
            if (!url.startsWith(prefix)) continue;
            String path = url.substring(prefix.length());
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((f = (Folder)folders.remove(path)) == null) {
                DavResource rs = UrlNamespace.checkRenamedResource(this.getOwner(), path);
                if (rs == null || !rs.isCollection()) {
                    throw new DavException("folder not found " + url, 424);
                }
                f = mbox.getFolderById(ctxt.getOperationContext(), ((MailItemResource)rs).getId());
            }
            if ((f.getFlagBitmask() & Flag.BITMASK_EXCLUDE_FREEBUSY) == 0) continue;
            ZimbraLog.dav.debug("clearing EXCLUDE_FREEBUSY for " + path);
            mbox.alterTag(ctxt.getOperationContext(), f.getId(), (byte)1, -21, false);
        }
        if (!folders.isEmpty()) {
            for (Folder f : folders.values()) {
                ZimbraLog.dav.debug("setting EXCLUDE_FREEBUSY for " + f.getPath());
                mbox.alterTag(ctxt.getOperationContext(), f.getId(), (byte)1, -21, true);
            }
        }
    }

    private Collection<Folder> getCalendarFolders(DavContext ctxt) throws ServiceException, DavException {
        ArrayList<Folder> calendars = new ArrayList<Folder>();
        Mailbox mbox = this.getMailbox(ctxt);
        for (Folder f : mbox.getFolderList(ctxt.getOperationContext(), SortBy.NONE)) {
            if (f instanceof Mountpoint || f.getDefaultView() != 11 && f.getDefaultView() != 15) continue;
            calendars.add(f);
        }
        return calendars;
    }
}

