/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCollection
extends Collection {
    protected String mRemoteOwnerId;
    protected int mRemoteId;
    protected String mCtag;

    public RemoteCollection(DavContext ctxt, Mountpoint mp) throws DavException, ServiceException {
        super(ctxt, mp);
        this.mRemoteOwnerId = mp.getOwnerId();
        this.mRemoteId = mp.getRemoteId();
        this.addResourceType(DavElements.E_MOUNTPOINT);
        this.getMountpointTarget(ctxt);
        this.mMailboxId = 0L;
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mRemoteOwnerId);
        if (target != null && Provisioning.onLocalServer(target)) {
            this.mMailboxId = MailboxManager.getInstance().getMailboxByAccount(target).getId();
        }
    }

    @Override
    public void delete(DavContext ctxt) throws DavException {
        throw new DavException("cannot delete this resource", 403, null);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public int getId() {
        return this.mRemoteId;
    }

    @Override
    public java.util.Collection<DavResource> getChildren(DavContext ctxt) throws DavException {
        return Collections.emptyList();
    }

    @Override
    public DavResource createItem(DavContext ctxt, String name) throws DavException, IOException {
        throw new DavException("request should be proxied", 500);
    }

    static ZMailbox getRemoteMailbox(ZAuthToken zat, String ownerId) throws ServiceException {
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, ownerId);
        if (target == null) {
            return null;
        }
        ZMailbox.Options zoptions = new ZMailbox.Options(zat, AccountUtil.getSoapUri(target));
        zoptions.setNoSession(true);
        zoptions.setTargetAccount(ownerId);
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        return ZMailbox.getMailbox(zoptions);
    }

    protected void getMountpointTarget(DavContext ctxt) throws ServiceException {
        ZAuthToken zat = AuthProvider.getAuthToken(ctxt.getAuthAccount()).toZAuthToken();
        ZMailbox zmbx = RemoteCollection.getRemoteMailbox(zat, this.mRemoteOwnerId);
        if (zmbx == null) {
            return;
        }
        ZFolder folder = zmbx.getFolder(new ItemId(this.mRemoteOwnerId, this.mRemoteId).toString(this.mOwnerId));
        if (folder == null) {
            return;
        }
        this.mCtag = CtagInfo.makeCtag(folder);
        this.setProperty(DavElements.E_GETCTAG, this.mCtag);
        short rights = ACL.stringToRights(folder.getEffectivePerms());
        this.addProperty(Acl.getCurrentUserPrivilegeSet(rights));
        this.addProperty(Acl.getMountpointTargetPrivilegeSet(rights));
        String targetUrl = UrlNamespace.getResourceUrl(Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mRemoteOwnerId), folder.getPath() + "/");
        ResourceProperty mp = new ResourceProperty(DavElements.E_MOUNTPOINT_TARGET_URL);
        mp.addChild(DavElements.E_HREF).setText(targetUrl);
        this.addProperty(mp);
    }
}

