/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.CalDavProperty;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.RemoteCollection;
import com.zimbra.cs.mailbox.Mountpoint;
import java.util.Locale;

public class RemoteCalendarCollection
extends RemoteCollection {
    public RemoteCalendarCollection(DavContext ctxt, Mountpoint mp) throws DavException, ServiceException {
        super(ctxt, mp);
        Account acct = mp.getAccount();
        this.addResourceType(DavElements.E_CALENDAR);
        Locale lc = acct.getLocale();
        String description = L10nUtil.getMessage(L10nUtil.MsgKey.caldavCalendarDescription, lc, acct.getAttr("displayName"), mp.getName());
        ResourceProperty desc = new ResourceProperty(DavElements.E_CALENDAR_DESCRIPTION);
        desc.setMessageLocale(lc);
        desc.setStringValue(description);
        desc.setVisible(false);
        this.addProperty(desc);
        this.addProperty(CalDavProperty.getSupportedCalendarComponentSet(mp.getDefaultView()));
        this.addProperty(CalDavProperty.getSupportedCalendarData());
        this.addProperty(CalDavProperty.getSupportedCollationSet());
        this.addProperty(this.getIcalColorProperty());
        this.setProperty(DavElements.E_ALTERNATE_URI_SET, null, true);
        this.setProperty(DavElements.E_GROUP_MEMBER_SET, null, true);
        this.setProperty(DavElements.E_GROUP_MEMBERSHIP, null, true);
    }
}

