/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.DavResource;

public class Principal
extends DavResource {
    protected Account mAccount;

    public Principal(Account authUser, String mainUrl) throws ServiceException {
        this(Principal.getOwner(authUser, mainUrl), mainUrl);
    }

    public Principal(String user, String mainUrl) throws ServiceException {
        super(mainUrl, user);
        if (!mainUrl.endsWith("/")) {
            mainUrl = mainUrl + "/";
        }
        this.setProperty(DavElements.E_HREF, mainUrl);
        this.setProperty(DavElements.E_GROUP_MEMBER_SET, null, true);
        this.setProperty(DavElements.E_GROUP_MEMBERSHIP, null, true);
        this.addResourceType(DavElements.E_PRINCIPAL);
        this.mUri = mainUrl;
    }

    public static String getOwner(Account acct, String url) throws ServiceException {
        String owner = acct.getName();
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        String defaultDomain = config.getAttr("zimbraDefaultDomainName", null);
        if (url.indexOf(64) < 0 && defaultDomain != null && defaultDomain.equalsIgnoreCase(acct.getDomainName())) {
            owner = owner.substring(0, owner.indexOf(64));
        }
        return owner;
    }

    public void delete(DavContext ctxt) throws DavException {
        throw new DavException("cannot delete this resource", 403, null);
    }

    public boolean isCollection() {
        return false;
    }

    public Account getAccount() {
        return this.mAccount;
    }
}

