/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.DavResource;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhantomResource
extends DavResource {
    protected static final String BY_DATE = "by-date";
    protected static final String BY_TYPE = "by-type";
    protected static final String BY_SENDER = "by-sender";
    protected static final String TODAY = "today";
    protected static final String WEEK = "last-week";
    protected static final String MONTH = "last-month";
    protected static final String YEAR = "last-year";
    protected static final String ALL = "all";
    protected List<String> mTokens;
    protected long mNow;
    protected static final byte[] SEARCH_TYPES = new byte[]{5};

    PhantomResource(String uri, String owner, List<String> tokens) {
        super(uri, owner);
        this.mTokens = tokens;
        this.mNow = System.currentTimeMillis();
        this.setCreationDate(this.mNow);
        this.setLastModifiedDate(this.mNow);
        this.setProperty("getcontentlength", "0");
        this.setProperty("displayname", tokens.get(tokens.size() - 1));
    }

    protected static List<String> parseUri(String uri) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(uri, "/");
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l;
    }

    @Override
    public void delete(DavContext ctxt) throws DavException {
        throw new DavException("cannot delete this resource", 403, null);
    }
}

