/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.wiki.WikiPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Notebook
extends MailItemResource {
    private Document mDoc;
    private WikiPage.WikiContext mWctxt;

    public Notebook(DavContext ctxt, Document doc) throws ServiceException {
        super(ctxt, doc);
        this.mDoc = doc;
        this.mWctxt = new WikiPage.WikiContext(ctxt.getOperationContext(), null);
        this.setCreationDate(doc.getDate());
        this.setLastModifiedDate(doc.getChangeDate());
        this.setProperty("displayname", doc.getName());
        this.setProperty("getcontentlength", Long.toString(doc.getSize()));
        this.setProperty("getcontenttype", doc.getContentType());
    }

    public InputStream getRawContent(DavContext ctxt) throws IOException, DavException {
        try {
            if (this.mDoc.getType() == 8) {
                return this.mDoc.getContentStream();
            }
            WikiPage page = WikiPage.create(this.mDoc);
            String val = page.getTemplate(this.mWctxt).getComposedPage(this.mWctxt, this.mDoc, "_Template");
            StringBuilder buf = new StringBuilder();
            buf.append("<html><head>");
            buf.append("<title>").append(this.mDoc.getName()).append("</title>");
            buf.append("<link rel='stylesheet' type='text/css' href='/zimbra/css/wiki.css'>");
            buf.append("</head><body style='margin:0px'>").append(val).append("</body></html>");
            return new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
        }
        catch (ServiceException se) {
            throw new DavException("cannot get contents", 500, se);
        }
    }

    public boolean isCollection() {
        return false;
    }
}

