/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.service.formatter.VCard;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailItemResource
extends DavResource {
    protected int mFolderId;
    protected int mId;
    protected byte mType;
    protected MailItem.Color mColor;
    protected String mEtag;
    protected String mSubject;
    protected String mPath;
    protected long mModifiedDate;
    protected String mOwnerId;
    protected Map<QName, Element> mDeadProps;
    private static final String CONFIG_KEY = "caldav";
    private static final int PROP_LENGTH_LIMIT = 1024;
    private static final String BLUE = "#0252D4FF";
    private static final String CYAN = "#008284FF";
    private static final String GREEN = "#2CA10BFF";
    private static final String PURPLE = "#492BA1FF";
    private static final String RED = "#E51717FF";
    private static final String YELLOW = "#848200FF";
    private static final String PINK = "#B027AEFF";
    private static final String GRAY = "#848284FF";
    private static final String ORANGE = "#F57802FF";
    private static final String DEFAULT_COLOR = "#F57802FF";
    protected static final String[] COLOR_MAP = new String[]{"#F57802FF", "#0252D4FF", "#008284FF", "#2CA10BFF", "#492BA1FF", "#E51717FF", "#848200FF", "#B027AEFF", "#848284FF", "#F57802FF"};
    protected static final ArrayList<String> COLOR_LIST = new ArrayList();

    public MailItemResource(DavContext ctxt, MailItem item) throws ServiceException {
        this(ctxt, MailItemResource.getItemPath(ctxt, item), item);
    }

    public MailItemResource(DavContext ctxt, String path, MailItem item) throws ServiceException {
        super(path, ctxt.getUser());
        this.mFolderId = item.getFolderId();
        this.mId = item.getId();
        this.mType = item.getType();
        this.mEtag = MailItemResource.getEtag(item);
        this.mSubject = item.getSubject();
        this.mPath = item.getPath();
        this.mModifiedDate = item.getChangeDate();
        this.mOwnerId = item.getAccount().getId();
        try {
            this.mDeadProps = this.getDeadProps(ctxt, item);
        }
        catch (Exception e) {
            ZimbraLog.dav.warn((Object)("can't get dead properties for MailItem id=" + this.mId), e);
        }
        this.setProperty("getetag", this.mEtag);
        if (this.mModifiedDate > 0L) {
            this.setLastModifiedDate(this.mModifiedDate);
        }
        this.mColor = item.getRgbColor();
        this.setProperty(DavElements.E_DISPLAYNAME, item.getName());
        this.addProperty(Acl.getPrincipalUrl(this));
        if (ctxt.isSchedulingEnabled()) {
            this.mDavCompliance.add(DavProtocol.Compliance.calendar_schedule);
        }
    }

    public MailItemResource(String path, String acct) {
        super(path, acct);
    }

    private static String getItemPath(DavContext ctxt, MailItem item) throws ServiceException {
        String path = ctxt.getCollectionPath();
        path = path != null ? path + item.getName() : ctxt.getPath();
        if (!(item.getType() != 6 && item.getType() != 1 && item.getType() != 13 || path.endsWith("/"))) {
            path = path + "/";
        }
        if (item.getType() == 6) {
            path = path + VCard.getUid((Contact)item) + ".vcf";
        }
        return path;
    }

    @Override
    public boolean hasEtag() {
        return true;
    }

    @Override
    public String getEtag() {
        return this.mEtag;
    }

    @Override
    public String getName() {
        return this.mSubject;
    }

    protected Mailbox getMailbox(DavContext ctxt) throws ServiceException, DavException {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, this.mOwnerId);
        if (account == null) {
            throw new DavException("no such account " + this.mOwnerId, 404, null);
        }
        return MailboxManager.getInstance().getMailboxByAccount(account);
    }

    protected MailItem getMailItem(DavContext ctxt) throws ServiceException, DavException {
        Mailbox mbox = this.getMailbox(ctxt);
        return mbox.getItemById(ctxt.getOperationContext(), this.mId, (byte)-1);
    }

    @Override
    public void delete(DavContext ctxt) throws DavException {
        if (this.mId == 0) {
            throw new DavException("cannot delete resource", 403, null);
        }
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            mbox.move(ctxt.getOperationContext(), this.mId, (byte)-1, 3);
        }
        catch (ServiceException se) {
            int resCode = se instanceof MailServiceException.NoSuchItemException ? 404 : 403;
            throw new DavException("cannot delete item", resCode, se);
        }
    }

    public void move(DavContext ctxt, Collection dest) throws DavException {
        if (this.mFolderId == dest.getId()) {
            return;
        }
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            mbox.move(ctxt.getOperationContext(), this.mId, (byte)-1, dest.getId());
        }
        catch (ServiceException se) {
            int resCode = se instanceof MailServiceException.NoSuchItemException ? 404 : 403;
            throw new DavException("cannot move item", resCode, se);
        }
    }

    public DavResource copy(DavContext ctxt, Collection dest) throws DavException {
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            MailItem item = mbox.copy(ctxt.getOperationContext(), this.mId, (byte)-1, dest.getId());
            return UrlNamespace.getResourceFromMailItem(ctxt, item);
        }
        catch (ServiceException se) {
            int resCode = se instanceof MailServiceException.NoSuchItemException ? 404 : 403;
            throw new DavException("cannot copy item", resCode, se);
        }
    }

    @Override
    public void rename(DavContext ctxt, String newName, DavResource destCollection) throws DavException {
        if (!(destCollection instanceof MailItemResource)) {
            return;
        }
        MailItemResource dest = (MailItemResource)destCollection;
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            if (this.isCollection()) {
                mbox.rename(ctxt.getOperationContext(), this.mId, (byte)1, newName, dest.mId);
            } else {
                mbox.rename(ctxt.getOperationContext(), this.mId, this.mType, newName, dest.mId);
            }
        }
        catch (ServiceException se) {
            int resCode = se instanceof MailServiceException.NoSuchItemException ? 404 : 403;
            throw new DavException("cannot rename item", resCode, se);
        }
    }

    public int getId() {
        return this.mId;
    }

    private Map<QName, Element> getDeadProps(DavContext ctxt, MailItem item) throws DocumentException, IOException, DavException, ServiceException {
        HashMap<QName, Element> props = new HashMap<QName, Element>();
        Mailbox mbox = item.getMailbox();
        Metadata data = mbox.getConfig(ctxt.getOperationContext(), CONFIG_KEY);
        if (data == null) {
            return props;
        }
        String configVal = data.get(Integer.toString(item.getId()), null);
        if (configVal == null) {
            return props;
        }
        if (configVal.length() == 0) {
            return props;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(configVal.getBytes("UTF-8"));
        Document doc = com.zimbra.common.soap.Element.getSAXReader().read(in);
        Element e = doc.getRootElement();
        if (e == null) {
            return props;
        }
        for (Object obj : e.elements()) {
            if (!(obj instanceof Element)) continue;
            Element elem = (Element)obj;
            elem.detach();
            props.put(elem.getQName(), elem);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void patchProperties(DavContext ctxt, java.util.Collection<Element> set, java.util.Collection<QName> remove) throws DavException, IOException {
        for (QName n : remove) {
            this.mDeadProps.remove(n);
        }
        for (Element e : set) {
            QName name = e.getQName();
            if (name.equals(DavElements.E_DISPLAYNAME) && (this.mType == 1 || this.mType == 13)) {
                try {
                    String val = e.getText();
                    String uri = this.getUri();
                    Mailbox mbox = this.getMailbox(ctxt);
                    mbox.rename(ctxt.getOperationContext(), this.mId, this.mType, val, this.mFolderId);
                    this.setProperty("displayname", val);
                    UrlNamespace.addToRenamedResource(this.getOwner(), uri, this);
                    UrlNamespace.addToRenamedResource(this.getOwner(), uri.substring(0, uri.length() - 1), this);
                }
                catch (ServiceException se) {
                    ctxt.getResponseProp().addPropError(DavElements.E_DISPLAYNAME, new DavException(se.getMessage(), 424));
                }
                this.mDeadProps.remove(name);
                continue;
            }
            if (name.equals(DavElements.E_CALENDAR_COLOR) && (this.mType == 1 || this.mType == 13)) {
                String colorStr = e.getText();
                MailItem.Color color = new MailItem.Color(colorStr.substring(0, 7));
                byte col = (byte)COLOR_LIST.indexOf(colorStr);
                if (col >= 0) {
                    color.setColor(col);
                }
                try {
                    Mailbox mbox = this.getMailbox(ctxt);
                    mbox.setColor(ctxt.getOperationContext(), new int[]{this.mId}, this.mType, color);
                }
                catch (ServiceException se) {
                    ctxt.getResponseProp().addPropError(DavElements.E_CALENDAR_COLOR, new DavException(se.getMessage(), 424));
                }
                this.mDeadProps.remove(name);
                continue;
            }
            this.mDeadProps.put(name, e);
        }
        String configVal = "";
        if (this.mDeadProps.size() > 0) {
            Document doc = DocumentHelper.createDocument();
            Element top = doc.addElement(CONFIG_KEY);
            for (Map.Entry<QName, Element> entry : this.mDeadProps.entrySet()) {
                top.add(entry.getValue().detach());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = OutputFormat.createCompactFormat();
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(doc);
            configVal = new String(out.toByteArray(), "UTF-8");
            if (configVal.length() > 1024) {
                for (Map.Entry<QName, Element> entry : this.mDeadProps.entrySet()) {
                    ctxt.getResponseProp().addPropError(entry.getKey(), new DavException("prop length exceeded", 507));
                }
            }
        }
        try {
            Mailbox mbox;
            Mailbox mailbox = mbox = this.getMailbox(ctxt);
            synchronized (mailbox) {
                Metadata data = mbox.getConfig(ctxt.getOperationContext(), CONFIG_KEY);
                if (data == null) {
                    data = new Metadata();
                }
                data.put(Integer.toString(this.mId), configVal);
                mbox.setConfig(ctxt.getOperationContext(), CONFIG_KEY, data);
            }
        }
        catch (ServiceException se) {
            throw new DavException("unable to patch properties", 403, se);
        }
    }

    @Override
    public ResourceProperty getProperty(QName prop) {
        Element e;
        ResourceProperty rp = null;
        if (this.mDeadProps != null && (e = this.mDeadProps.get(prop)) != null) {
            rp = new ResourceProperty(e);
        }
        if (rp == null) {
            rp = super.getProperty(prop);
        }
        return rp;
    }

    public static String getEtag(MailItem item) {
        return MailItemResource.getEtag(Long.toString(item.getModifiedSequence()), Long.toString(item.getSavedSequence()));
    }

    public static String getEtag(String modMetadata, String modContent) {
        return "\"" + modMetadata + "-" + modContent + "\"";
    }

    public void setAce(DavContext ctxt, List<Acl.Ace> aceList) throws ServiceException, DavException {
        ACL acl = new ACL();
        for (Acl.Ace ace : aceList) {
            acl.grantAccess(ace.getZimbraId(), ace.getGranteeType(), ace.getRights(), null);
        }
        Mailbox mbox = this.getMailbox(ctxt);
        mbox.setPermissions(ctxt.getOperationContext(), this.getId(), acl);
    }

    public List<Acl.Ace> getAce(DavContext ctxt) throws ServiceException, DavException {
        ArrayList<Acl.Ace> aces = new ArrayList<Acl.Ace>();
        Mailbox mbox = this.getMailbox(ctxt);
        MailItem item = mbox.getItemById(ctxt.getOperationContext(), this.mId, (byte)-1);
        Folder f = null;
        f = item.getType() == 1 ? (Folder)item : mbox.getFolderById(ctxt.getOperationContext(), item.getParentId());
        for (ACL.Grant g : f.getEffectiveACL().getGrants()) {
            if (!g.hasGrantee()) continue;
            aces.add(new Acl.Ace(g.getGranteeId(), g.getGrantedRights(), g.getGranteeType()));
        }
        return aces;
    }

    protected ResourceProperty getIcalColorProperty() {
        ResourceProperty color = new ResourceProperty(DavElements.E_CALENDAR_COLOR);
        if (this.mColor.getRgb() == 0L) {
            color.setStringValue("#F57802FF");
        } else if (this.mColor.hasMapping()) {
            color.setStringValue(COLOR_MAP[this.mColor.getMappedColor()]);
        } else {
            color.setStringValue(this.mColor.toString() + "FF");
        }
        return color;
    }

    static {
        Collections.addAll(COLOR_LIST, COLOR_MAP);
    }
}

