/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.httpclient.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DavResource {
    protected String mUri;
    protected String mOwner;
    protected Map<QName, ResourceProperty> mProps;
    protected Collection<DavProtocol.Compliance> mDavCompliance;
    protected boolean mNewlyCreated = false;

    public DavResource(String uri, String owner) {
        this.mOwner = owner;
        this.mProps = new HashMap<QName, ResourceProperty>();
        this.mUri = uri;
        if (this.isCollection() && !this.mUri.endsWith("/")) {
            this.mUri = this.mUri + "/";
        }
        this.mDavCompliance = new TreeSet<DavProtocol.Compliance>();
        this.mDavCompliance.add(DavProtocol.Compliance.one);
        this.mDavCompliance.add(DavProtocol.Compliance.two);
        this.mDavCompliance.add(DavProtocol.Compliance.three);
        this.mDavCompliance.add(DavProtocol.Compliance.access_control);
        this.mDavCompliance.add(DavProtocol.Compliance.calendar_access);
        this.mDavCompliance.add(DavProtocol.Compliance.version_control);
        this.mDavCompliance.add(DavProtocol.Compliance.calendar_proxy);
        this.mDavCompliance.add(DavProtocol.Compliance.calendarserver_principal_property_search);
        this.mDavCompliance.add(DavProtocol.Compliance.addressbook);
        this.mDavCompliance.add(DavProtocol.Compliance.extended_mkcol);
        ResourceProperty rtype = new ResourceProperty(DavElements.E_RESOURCETYPE);
        rtype.setProtected(true);
        rtype.setVisible(true);
        this.addProperty(rtype);
        ResourceProperty href = new ResourceProperty(DavElements.E_HREF);
        href.setProtected(true);
        try {
            href.setStringValue(UrlNamespace.getResourceUrl(this));
        }
        catch (Exception e) {
            ZimbraLog.dav.error((Object)"can't generate href", e);
        }
        this.addProperty(href);
        if (this.hasEtag()) {
            this.setProperty(DavElements.E_GETETAG, this.getEtag(), true);
        }
        if (this.isCollection()) {
            this.addResourceType(DavElements.E_COLLECTION);
        }
        this.addProperty(Acl.getPrincipalCollectionSet());
        this.addProperty(Acl.getCurrentUserPrincipal());
        QName[] supportedReports = this.getSupportedReports();
        if (supportedReports.length > 0) {
            ResourceProperty sr = new ResourceProperty(DavElements.E_SUPPORTED_REPORT_SET);
            this.addProperty(sr);
            sr.setProtected(true);
            sr.setVisible(true);
            Element e = null;
            for (QName n : supportedReports) {
                e = DocumentHelper.createElement(DavElements.E_SUPPORTED_REPORT);
                e.addElement(DavElements.E_REPORT).addElement(n);
                sr.getChildren().add(e);
            }
        }
    }

    public void setHref(String href) {
        this.getProperty(DavElements.E_HREF).setStringValue(URLUtil.urlEscape(href));
    }

    public boolean isValid() {
        return true;
    }

    public boolean isNewlyCreated() {
        return this.mNewlyCreated;
    }

    public boolean equals(Object another) {
        if (another instanceof DavResource) {
            DavResource that = (DavResource)another;
            return this.mUri.equals(that.mUri) && this.mOwner.equals(that.mOwner);
        }
        return false;
    }

    public Collection<DavProtocol.Compliance> getComplianceList() {
        return this.mDavCompliance;
    }

    public ResourceProperty getProperty(String propName) {
        return this.getProperty(QName.get(propName, DavElements.WEBDAV_NS));
    }

    public ResourceProperty getProperty(QName prop) {
        return this.mProps.get(prop);
    }

    public ResourceProperty getProperty(Element prop) {
        if (prop == null) {
            return null;
        }
        return this.getProperty(prop.getQName());
    }

    public ResourceProperty getProperty(QName prop, DavContext.RequestProp request) {
        if (request.getProp(prop) == null) {
            return this.getProperty(prop);
        }
        return this.getProperty(request.getProp(prop));
    }

    public Set<QName> getAllPropertyNames() {
        HashSet<QName> ret = new HashSet<QName>();
        for (QName key : this.mProps.keySet()) {
            if (!this.mProps.get(key).isVisible()) continue;
            ret.add(key);
        }
        return ret;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public boolean hasContent(DavContext ctxt) {
        if (this.isWebRequest(ctxt)) {
            return true;
        }
        try {
            return this.getContentLength() > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getContentType(DavContext ctxt) {
        if (this.isWebRequest(ctxt)) {
            return "text/plain";
        }
        ResourceProperty prop = this.getProperty(DavElements.E_GETCONTENTTYPE);
        if (prop != null) {
            return prop.getStringValue();
        }
        return null;
    }

    public int getContentLength() {
        ResourceProperty prop = this.getProperty(DavElements.E_GETCONTENTLENGTH);
        if (prop != null) {
            return Integer.parseInt(prop.getStringValue());
        }
        return 0;
    }

    protected void setCreationDate(long ts) {
        this.setProperty("creationdate", DateUtil.toISO8601(new Date(ts)));
    }

    protected void setLastModifiedDate(long ts) {
        this.setProperty("getlastmodified", DateUtil.toRFC822Date(new Date(ts)));
    }

    protected void addProperty(ResourceProperty prop) {
        this.mProps.put(prop.getName(), prop);
    }

    protected void addProperties(Set<ResourceProperty> props) {
        for (ResourceProperty p : props) {
            this.mProps.put(p.getName(), p);
        }
    }

    protected void setProperty(String key, String val) {
        this.setProperty(QName.get(key, DavElements.WEBDAV_NS), val);
    }

    protected void setProperty(QName key, String val) {
        this.setProperty(key, val, false);
    }

    protected void setProperty(QName key, String val, boolean isProtected) {
        ResourceProperty prop = this.mProps.get(key);
        if (prop == null) {
            prop = new ResourceProperty(key);
            this.mProps.put(key, prop);
        }
        prop.setProtected(isProtected);
        prop.setStringValue(val);
    }

    public boolean isAccessControlled() {
        return true;
    }

    public InputStream getContent(DavContext ctxt) throws IOException, DavException {
        if (this.isWebRequest(ctxt)) {
            return this.getTextContent(ctxt);
        }
        return this.getRawContent(ctxt);
    }

    public abstract boolean isCollection();

    public abstract void delete(DavContext var1) throws DavException;

    public String getName() {
        return this.getUri();
    }

    public Collection<DavResource> getChildren(DavContext ctxt) throws DavException {
        return Collections.emptyList();
    }

    public boolean hasEtag() {
        return false;
    }

    public String getEtag() {
        return null;
    }

    public String getLastModifiedDate() {
        ResourceProperty rp = this.getProperty("getlastmodified");
        if (rp != null) {
            return rp.getStringValue();
        }
        return new Date(0L).toString();
    }

    public void patchProperties(DavContext ctxt, Collection<Element> set, Collection<QName> remove) throws DavException, IOException {
        throw new DavException("PROPPATCH not supported on " + this.getUri(), 424, null);
    }

    protected void addResourceType(QName type) {
        ResourceProperty rtype = this.getProperty(DavElements.E_RESOURCETYPE);
        rtype.addChild(type);
    }

    public void handlePost(DavContext ctxt) throws DavException, IOException, ServiceException {
        throw new DavException("the resource does not handle POST", 403);
    }

    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return this.mUri;
    }

    public DavResource copy(DavContext ctxt, DavResource dest) throws DavException {
        throw new DavException("not supported", 406);
    }

    public void rename(DavContext ctxt, String newName, DavResource destCollection) throws DavException {
        throw new DavException("not supported", 406);
    }

    protected boolean isWebRequest(DavContext ctxt) {
        String userAgent = ctxt.getRequest().getHeader("User-Agent");
        return userAgent != null && (userAgent.indexOf("MSIE") >= 0 || userAgent.indexOf("Mozilla") >= 0);
    }

    protected InputStream getRawContent(DavContext ctxt) throws DavException, IOException {
        return null;
    }

    protected QName[] getSupportedReports() {
        return new QName[0];
    }

    protected InputStream getTextContent(DavContext ctxt) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("Request\n\n");
        buf.append("\tAuthenticated user:\t").append(ctxt.getAuthAccount().getName()).append("\n");
        buf.append("\tCurrent date:\t\t").append(new Date(System.currentTimeMillis())).append("\n");
        buf.append("\nResource\n\n");
        buf.append("\tName:\t\t\t").append(this.getName()).append("\n");
        buf.append("\tPath:\t\t\t").append(this.getUri()).append("\n");
        buf.append("\tDate:\t\t\t").append(this.getLastModifiedDate()).append("\n");
        try {
            Provisioning prov = Provisioning.getInstance();
            Account account = prov.get(Provisioning.AccountBy.name, this.getOwner());
            buf.append("\tOwner account name:\t").append(account.getName()).append("\n");
        }
        catch (ServiceException se) {
            // empty catch block
        }
        buf.append("\nProperties\n\n");
        Element e = DocumentHelper.createElement(DavElements.E_PROP);
        for (ResourceProperty rp : this.mProps.values()) {
            rp.toElement(ctxt, e, false);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setTrimText(false);
        format.setOmitEncoding(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLWriter writer = new XMLWriter(baos, format);
        writer.write(e);
        buf.append(new String(baos.toByteArray()));
        return new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
    }

    public static class InvalidResource
    extends DavResource {
        public InvalidResource(String uri, String owner) {
            super(uri, owner);
        }

        public InputStream getContent(DavContext ctxt) {
            return null;
        }

        public void delete(DavContext ctxt) {
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isValid() {
            return false;
        }
    }
}

