/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.Acl;
import com.zimbra.cs.dav.resource.AddressObject;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.Notebook;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.formatter.VCard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
extends MailItemResource {
    protected byte mView;
    protected byte mType;
    protected long mMailboxId;

    public Collection(DavContext ctxt, Folder f) throws DavException, ServiceException {
        super(ctxt, f);
        this.setCreationDate(f.getDate());
        this.setLastModifiedDate(f.getChangeDate());
        this.setProperty("displayname", f.getName());
        this.setProperty("getcontentlength", "0");
        this.mId = f.getId();
        this.mView = f.getDefaultView();
        this.mType = f.getType();
        this.addProperties(Acl.getAclProperties(this, f));
        this.mMailboxId = f.getMailboxId();
    }

    private Collection(String name, String acct) throws DavException {
        super(name, acct);
        long now = System.currentTimeMillis();
        this.setCreationDate(now);
        this.setLastModifiedDate(now);
        this.setProperty("displayname", name.substring(1));
        this.setProperty("getcontentlength", "0");
        try {
            this.addProperties(Acl.getAclProperties(this, null));
        }
        catch (ServiceException se) {
            // empty catch block
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return this.mMailboxId != 0L;
    }

    @Override
    public java.util.Collection<DavResource> getChildren(DavContext ctxt) throws DavException {
        ArrayList<DavResource> children = new ArrayList<DavResource>();
        try {
            ctxt.setCollectionPath(this.getUri());
            List<MailItem> items = this.getChildrenMailItem(ctxt);
            for (MailItem item : items) {
                DavResource rs = UrlNamespace.getResourceFromMailItem(ctxt, item);
                if (rs == null) continue;
                children.add(rs);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.dav.error((Object)("can't get children from folder: id=" + this.mId), e);
        }
        if (this.isRootCollection()) {
            children.add(new Collection("/attachments", this.getOwner()));
        }
        return children;
    }

    private List<MailItem> getChildrenMailItem(DavContext ctxt) throws DavException, ServiceException {
        Mailbox mbox = this.getMailbox(ctxt);
        ArrayList<MailItem> ret = new ArrayList<MailItem>();
        ret.addAll(mbox.getItemList(ctxt.getOperationContext(), (byte)1, this.mId));
        ret.addAll(mbox.getItemList(ctxt.getOperationContext(), (byte)13, this.mId));
        ret.addAll(mbox.getItemList(ctxt.getOperationContext(), (byte)8, this.mId));
        ret.addAll(mbox.getItemList(ctxt.getOperationContext(), (byte)14, this.mId));
        ret.addAll(mbox.getItemList(ctxt.getOperationContext(), (byte)6, this.mId));
        return ret;
    }

    public Collection mkCol(DavContext ctxt, String name) throws DavException {
        return this.mkCol(ctxt, name, this.mView);
    }

    public Collection mkCol(DavContext ctxt, String name, byte view) throws DavException {
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            Folder f = mbox.createFolder(ctxt.getOperationContext(), name, this.mId, view, 0, (byte)0, null);
            return (Collection)UrlNamespace.getResourceFromMailItem(ctxt, f);
        }
        catch (ServiceException e) {
            if (e.getCode().equals("mail.ALREADY_EXISTS")) {
                throw new DavException("item already exists", 409, e);
            }
            if (e.getCode().equals("service.PERM_DENIED")) {
                throw new DavException("permission denied", 403, e);
            }
            throw new DavException("can't create", 500, e);
        }
    }

    public DavResource createItem(DavContext ctxt, String name) throws DavException, IOException {
        Mailbox mbox = null;
        try {
            mbox = this.getMailbox(ctxt);
        }
        catch (ServiceException e) {
            throw new DavException("cannot get mailbox", 500, null);
        }
        FileUploadServlet.Upload upload = ctxt.getUpload();
        String ctype = upload.getContentType();
        if (ctype != null && ctype.startsWith("text/vcard")) {
            return this.createVCard(ctxt, name);
        }
        String author = ctxt.getAuthAccount().getName();
        try {
            MailItem item = mbox.getItemByPath(ctxt.getOperationContext(), ctxt.getPath());
            if (item.getType() != 8 && item.getType() != 14) {
                throw new DavException("no DAV resource for " + MailItem.getNameForType(item.getType()), 406, null);
            }
            Document doc = mbox.addDocumentRevision(ctxt.getOperationContext(), item.getId(), upload.getInputStream(), author, name);
            return new Notebook(ctxt, doc);
        }
        catch (ServiceException e) {
            if (!(e instanceof MailServiceException.NoSuchItemException)) {
                throw new DavException("cannot get item ", 500, null);
            }
            try {
                Document doc = mbox.createDocument(ctxt.getOperationContext(), this.mId, name, ctype, author, upload.getInputStream());
                Notebook notebook = new Notebook(ctxt, doc);
                notebook.mNewlyCreated = true;
                return notebook;
            }
            catch (ServiceException se) {
                throw new DavException("cannot create ", 500, se);
            }
        }
    }

    protected DavResource createVCard(DavContext ctxt, String name) throws DavException, IOException {
        FileUploadServlet.Upload upload = ctxt.getUpload();
        String buf = new String(ByteUtil.getContent(upload.getInputStream(), (int)upload.getSize()), "utf-8");
        Mailbox mbox = null;
        try {
            mbox = this.getMailbox(ctxt);
            DavResource res = null;
            for (VCard vcard : VCard.parseVCard(buf)) {
                if (vcard.fields.isEmpty()) continue;
                String uid = vcard.uid;
                Contact c = null;
                if (uid != null) {
                    vcard.fields.put("vcardUID", uid);
                    res = UrlNamespace.getResourceAt(ctxt, ctxt.getUser(), ctxt.getPath());
                }
                if (res == null) {
                    String ifnonematch = ctxt.getRequest().getHeader("If-None-Match");
                    if (ifnonematch == null) {
                        throw new DavException("item does not exists", 409);
                    }
                    c = mbox.createContact(ctxt.getOperationContext(), vcard.asParsedContact(), this.mId, null);
                    res = new AddressObject(ctxt, c);
                    res.mNewlyCreated = true;
                    continue;
                }
                String etag = ctxt.getRequest().getHeader("If-Match");
                String itemEtag = res.getEtag();
                if (etag != null && !etag.equals(itemEtag)) {
                    throw new DavException("item etag does not match", 409);
                }
                mbox.modifyContact(ctxt.getOperationContext(), ((MailItemResource)res).getId(), vcard.asParsedContact());
                res = UrlNamespace.getResourceAt(ctxt, ctxt.getUser(), ctxt.getPath());
            }
            return res;
        }
        catch (ServiceException e) {
            throw new DavException("cannot parse vcard ", 500, e);
        }
    }

    @Override
    public void delete(DavContext ctxt) throws DavException {
        String user = ctxt.getUser();
        String path = ctxt.getPath();
        if (user == null || path == null) {
            throw new DavException("invalid uri", 404, null);
        }
        try {
            Mailbox mbox = this.getMailbox(ctxt);
            mbox.delete(ctxt.getOperationContext(), this.mId, this.mType);
        }
        catch (ServiceException e) {
            throw new DavException("cannot get item", 404, e);
        }
    }

    protected boolean isRootCollection() {
        return this.mId == 1;
    }
}

