/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.caldav.Filter;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.dav.property.CalDavProperty;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public interface CalendarObject {
    public static final String CAL_EXTENSION = ".ics";

    public String getUid();

    public boolean match(Filter var1);

    public String getVcalendar(DavContext var1, Filter var2) throws IOException, DavException;

    public static class LocalCalendarObject
    extends MailItemResource
    implements CalendarObject {
        private String mUid;
        private Invite[] mInvites;
        private TimeZoneMap mTzmap;
        private long mMailboxId;
        private long mStart;
        private long mEnd;

        public LocalCalendarObject(DavContext ctxt, CalendarItem calItem) throws ServiceException {
            this(ctxt, calItem, false);
        }

        public LocalCalendarObject(DavContext ctxt, CalendarItem calItem, boolean newItem) throws ServiceException {
            this(ctxt, CalendarPath.generate(ctxt, calItem.getPath(), calItem.getUid(), -1), calItem);
            this.mNewlyCreated = newItem;
        }

        public LocalCalendarObject(DavContext ctxt, String path, CalendarItem calItem) throws ServiceException {
            super(ctxt, path, calItem);
            this.mUid = calItem.getUid();
            this.mInvites = calItem.getInvites();
            this.mTzmap = calItem.getTimeZoneMap();
            Invite defInv = calItem.getDefaultInviteOrNull();
            if (defInv != null) {
                this.setProperty("displayname", defInv.getName());
            }
            this.setProperty("getcontenttype", "text/calendar");
            this.setProperty("getcontentlength", Long.toString(calItem.getSize()));
            this.addProperty(CalDavProperty.getCalendarData(this));
            if (this.mInvites[0].hasRecurId() && this.mInvites.length > 1) {
                ArrayList<Invite> newList = new ArrayList<Invite>();
                ArrayList<Invite> exceptions = new ArrayList<Invite>();
                for (Invite i : this.mInvites) {
                    if (i.hasRecurId()) {
                        exceptions.add(i);
                        continue;
                    }
                    newList.add(i);
                }
                newList.addAll(exceptions);
                this.mInvites = newList.toArray(new Invite[0]);
            }
            this.mMailboxId = calItem.getMailboxId();
            this.mStart = calItem.getStartTime();
            this.mEnd = calItem.getEndTime();
        }

        public boolean match(Filter filter) {
            TimeRange range = filter.getTimeRange();
            if (range != null && !range.matches(this.mMailboxId, this.mId, this.mStart, this.mEnd)) {
                return false;
            }
            for (Invite inv : this.mInvites) {
                try {
                    ZCalendar.ZComponent vcomp = inv.newToVComponent(false, false);
                    if (!filter.match(vcomp)) continue;
                    return true;
                }
                catch (ServiceException se) {
                    ZimbraLog.dav.warn((Object)"cannot convert to ICalendar", se);
                }
            }
            return false;
        }

        public String getVcalendar(DavContext ctxt, Filter filter) throws IOException, DavException {
            StringBuilder buf = new StringBuilder();
            buf.append("BEGIN:VCALENDAR\r\n");
            buf.append("VERSION:").append("2.0").append("\r\n");
            buf.append("PRODID:").append("Zimbra-Calendar-Provider").append("\r\n");
            Iterator<ICalTimeZone> iter = this.mTzmap.tzIterator();
            while (iter.hasNext()) {
                ICalTimeZone tz = iter.next();
                CharArrayWriter wr = new CharArrayWriter();
                tz.newToVTimeZone().toICalendar(wr, true);
                wr.flush();
                buf.append(wr.toCharArray());
                wr.close();
            }
            Account acct = ctxt.getAuthAccount();
            boolean allowPrivateAccess = false;
            try {
                Mailbox mbox = this.getMailbox(ctxt);
                OperationContext octxt = ctxt.getOperationContext();
                Folder folder = mbox.getFolderById(octxt, this.mFolderId);
                allowPrivateAccess = CalendarItem.allowPrivateAccess(folder, ctxt.getAuthAccount(), octxt.isUsingAdminPrivileges());
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"cannot determine private access status", se);
            }
            buf.append(Vcalendar.toString(acct, this.mInvites, filter, allowPrivateAccess));
            buf.append("END:VCALENDAR\r\n");
            return buf.toString();
        }

        public InputStream getRawContent(DavContext ctxt) throws IOException, DavException {
            return new ByteArrayInputStream(this.getVcalendar(ctxt, null).getBytes("UTF-8"));
        }

        public boolean isCollection() {
            return false;
        }

        public String getUid() {
            return this.mUid;
        }

        public boolean hasContent(DavContext ctxt) {
            return true;
        }
    }

    public static class LightWeightCalendarObject
    extends DavResource
    implements CalendarObject {
        private long mMailboxId;
        private int mId;
        private String mUid;
        private String mEtag;
        private long mStart;
        private long mEnd;

        public LightWeightCalendarObject(String path, String owner, CalendarItem.CalendarMetadata data) {
            super(CalendarPath.generate(null, path, data.uid, -1), owner);
            this.mMailboxId = data.mailboxId;
            this.mId = data.itemId;
            this.mUid = data.uid;
            this.mStart = data.start_time;
            this.mEnd = data.end_time;
            this.mEtag = MailItemResource.getEtag(Integer.toString(data.mod_metadata), Integer.toString(data.mod_content));
            this.setProperty("getetag", this.mEtag);
            this.addProperty(CalDavProperty.getCalendarData(this));
        }

        public String getUid() {
            return this.mUid;
        }

        public boolean match(Filter filter) {
            TimeRange range = filter.getTimeRange();
            if (range == null) {
                return true;
            }
            return range.matches(this.mMailboxId, this.mId, this.mStart, this.mEnd);
        }

        public String getEtag() {
            return this.mEtag;
        }

        public String getVcalendar(DavContext ctxt, Filter filter) throws IOException, DavException {
            ZimbraLog.dav.debug("constructing full resource");
            return this.getFullResource(ctxt).getVcalendar(ctxt, filter);
        }

        public InputStream getContent(DavContext ctxt) throws IOException, DavException {
            return new ByteArrayInputStream(this.getVcalendar(ctxt, null).getBytes("UTF-8"));
        }

        public boolean isCollection() {
            return false;
        }

        public void delete(DavContext ctxt) throws DavException {
        }

        private CalendarObject getFullResource(DavContext ctxt) throws DavException {
            String user = null;
            Account acct = ctxt.getOperationContext().getAuthenticatedUser();
            if (acct != null) {
                user = acct.getName();
            }
            try {
                DavResource rs = UrlNamespace.getResourceByItemId(ctxt, user, this.mId);
                if (rs instanceof LocalCalendarObject) {
                    return (LocalCalendarObject)rs;
                }
                throw new DavException("not a calendar item", 400);
            }
            catch (ServiceException se) {
                throw new DavException("can't fetch item", se);
            }
        }

        public boolean hasContent(DavContext ctxt) {
            return true;
        }
    }

    public static class ScheduleMessage
    extends MailItemResource
    implements CalendarObject {
        private Invite mInvite;

        public ScheduleMessage(DavContext ctxt, String path, String owner, Invite inv, Message msg) throws ServiceException {
            super(ctxt, path, msg);
            this.mInvite = inv;
            this.addProperty(CalDavProperty.getCalendarData(this));
        }

        public String getUid() {
            return this.mInvite.getUid();
        }

        public boolean match(Filter filter) {
            return true;
        }

        public String getVcalendar(DavContext ctxt, Filter filter) throws IOException, DavException {
            StringBuilder buf = new StringBuilder();
            buf.append("BEGIN:VCALENDAR\r\n");
            buf.append("VERSION:").append("2.0").append("\r\n");
            buf.append("PRODID:").append("Zimbra-Calendar-Provider").append("\r\n");
            buf.append("METHOD:").append(this.mInvite.getMethod()).append("\r\n");
            Account acct = ctxt.getAuthAccount();
            boolean allowPrivateAccess = false;
            try {
                Mailbox mbox = this.getMailbox(ctxt);
                OperationContext octxt = ctxt.getOperationContext();
                Folder folder = mbox.getFolderById(octxt, this.mFolderId);
                allowPrivateAccess = CalendarItem.allowPrivateAccess(folder, ctxt.getAuthAccount(), octxt.isUsingAdminPrivileges());
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"cannot determine private access status", se);
            }
            buf.append(Vcalendar.toString(acct, this.mInvite, filter, allowPrivateAccess));
            buf.append("END:VCALENDAR\r\n");
            return buf.toString();
        }

        public InputStream getContent(DavContext ctxt) throws IOException, DavException {
            return new ByteArrayInputStream(this.getVcalendar(ctxt, null).getBytes("UTF-8"));
        }

        public boolean isCollection() {
            return false;
        }
    }

    public static class CalendarPath {
        public static String generate(DavContext ctxt, String itemPath, String uid, int extra) {
            if (ctxt != null) {
                if (ctxt.getCollectionPath() != null) {
                    itemPath = ctxt.getCollectionPath();
                } else if (ctxt.getPathInfo() != null) {
                    itemPath = itemPath + ctxt.getPathInfo();
                }
            }
            StringBuilder path = new StringBuilder();
            path.append(itemPath);
            if (path.charAt(path.length() - 1) != '/') {
                path.append("/");
            }
            path.append(uid);
            if (extra >= 0) {
                path.append(",").append(extra);
            }
            path.append(CalendarObject.CAL_EXTENSION);
            return path.toString();
        }
    }

    public static class Vcalendar {
        private static Invite getFixedUpCopy(Invite inv, Account acct) throws ServiceException {
            ZAttendee attendee = inv.getMatchingAttendee(acct);
            if (attendee != null && attendee.hasRsvp() && attendee.getRsvp().booleanValue() && "NE".equals(attendee.getPartStat())) {
                Invite copy = inv.newCopy();
                ZCalendar.ZProperty prop = new ZCalendar.ZProperty("X-APPLE-NEEDS-REPLY");
                prop.setValue("TRUE");
                copy.addXProp(prop);
                return copy;
            }
            return inv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String toString(Account acct, Invite inv, Filter filter, boolean allowPrivateAccess) throws IOException {
            CharArrayWriter wr = null;
            try {
                wr = new CharArrayWriter();
                Invite fixedInv = Vcalendar.getFixedUpCopy(inv, acct);
                ZCalendar.ZComponent comp = fixedInv.newToVComponent(false, allowPrivateAccess);
                if (filter == null || filter.match(comp)) {
                    comp.toICalendar(wr, true);
                }
                wr.flush();
                String string = wr.toString();
                Object var9_10 = null;
                if (wr != null) {
                    wr.close();
                }
                return string;
            }
            catch (ServiceException se) {
                try {
                    ZimbraLog.dav.warn((Object)"cannot convert to iCalendar", se);
                    String string = "";
                    Object var9_11 = null;
                    if (wr != null) {
                        wr.close();
                    }
                    return string;
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var9_12 = null;
                        if (wr == null) break block7;
                        wr.close();
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String toString(Account acct, Invite[] invites, Filter filter, boolean allowPrivateAccess) throws IOException {
            CharArrayWriter wr = null;
            try {
                Object fixedInvs;
                wr = new CharArrayWriter();
                if (!LC.calendar_apple_ical_compatible_canceled_instances.booleanValue()) {
                    for (Invite inv : invites) {
                        Invite fixedInv = Vcalendar.getFixedUpCopy(inv, acct);
                        ZCalendar.ZComponent comp = fixedInv.newToVComponent(false, allowPrivateAccess);
                        if (filter != null && !filter.match(comp)) continue;
                        comp.toICalendar(wr, true);
                    }
                } else {
                    fixedInvs = new Invite[invites.length];
                    for (int i = 0; i < invites.length; ++i) {
                        fixedInvs[i] = Vcalendar.getFixedUpCopy(invites[i], acct);
                    }
                    boolean appleICalExdateHack = LC.calendar_apple_ical_compatible_canceled_instances.booleanValue();
                    ZCalendar.ZComponent[] vcomps = Invite.toVComponents(fixedInvs, allowPrivateAccess, false, appleICalExdateHack);
                    if (vcomps != null) {
                        for (ZCalendar.ZComponent vcomp : vcomps) {
                            if (filter != null && !filter.match(vcomp)) continue;
                            vcomp.toICalendar(wr, true);
                        }
                    }
                }
                wr.flush();
                fixedInvs = wr.toString();
                Object var13_19 = null;
                if (wr != null) {
                    wr.close();
                }
                return fixedInvs;
            }
            catch (ServiceException se) {
                try {
                    ZimbraLog.dav.warn((Object)"cannot convert to iCalendar", se);
                    String string = "";
                    Object var13_20 = null;
                    if (wr != null) {
                        wr.close();
                    }
                    return string;
                }
                catch (Throwable throwable) {
                    block12: {
                        Object var13_21 = null;
                        if (wr == null) break block12;
                        wr.close();
                    }
                    throw throwable;
                }
            }
        }
    }
}

