/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.dav.property.CalDavProperty;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.CalendarObject;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.dav.service.DavServlet;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarCollection
extends Collection {
    protected Map<String, DavResource> mAppts;
    protected boolean mMetadataOnly;
    protected String mCtag;
    private static final HashSet<QName> sMetaProps = new HashSet();

    public CalendarCollection(DavContext ctxt, Folder f) throws DavException, ServiceException {
        super(ctxt, f);
        Account acct = f.getAccount();
        if (f.getDefaultView() == 11 || f.getDefaultView() == 15) {
            this.addResourceType(DavElements.E_CALENDAR);
        }
        if (f.getId() == 10) {
            this.addResourceType(DavElements.E_DEFAULT_CALENDAR);
        }
        Locale lc = acct.getLocale();
        String description = L10nUtil.getMessage(L10nUtil.MsgKey.caldavCalendarDescription, lc, acct.getAttr("displayName"), f.getName());
        ResourceProperty desc = new ResourceProperty(DavElements.E_CALENDAR_DESCRIPTION);
        desc.setMessageLocale(lc);
        desc.setStringValue(description);
        desc.setVisible(false);
        this.addProperty(desc);
        this.addProperty(CalDavProperty.getSupportedCalendarComponentSet(f.getDefaultView()));
        this.addProperty(CalDavProperty.getSupportedCalendarData());
        this.addProperty(CalDavProperty.getSupportedCollationSet());
        this.mCtag = CtagInfo.makeCtag(f);
        this.setProperty(DavElements.E_GETCTAG, this.mCtag);
        this.addProperty(this.getIcalColorProperty());
        this.setProperty(DavElements.E_ALTERNATE_URI_SET, null, true);
        this.setProperty(DavElements.E_GROUP_MEMBER_SET, null, true);
        this.setProperty(DavElements.E_GROUP_MEMBERSHIP, null, true);
    }

    @Override
    public java.util.Collection<DavResource> getChildren(DavContext ctxt) throws DavException {
        return this.getChildren(ctxt, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.util.Collection<DavResource> getChildren(DavContext ctxt, TimeRange range) throws DavException {
        boolean fetchAppts;
        Map<String, DavResource> requestedAppts = null;
        boolean bl = fetchAppts = range != null || this.mAppts == null;
        if (fetchAppts) {
            try {
                requestedAppts = this.getAppointmentMap(ctxt, range);
                if (range != null || !this.needCalendarData(ctxt)) return requestedAppts.values();
                this.mAppts = requestedAppts;
                return requestedAppts.values();
            }
            catch (ServiceException se) {
                ZimbraLog.dav.error((Object)"can't get calendar items", se);
                return Collections.emptyList();
            }
        } else {
            requestedAppts = this.mAppts;
        }
        return requestedAppts.values();
    }

    protected Map<String, String> getUidToHrefMap(java.util.Collection<String> hrefs) {
        HashMap<String, String> uidmap = new HashMap<String, String>();
        for (String href : hrefs) {
            try {
                String hrefDecoded = URLDecoder.decode(href, "UTF-8");
                int start = hrefDecoded.lastIndexOf(47) + 1;
                int end = hrefDecoded.lastIndexOf(".ics");
                if (start <= 0 || end <= 0 || end <= start) continue;
                uidmap.put(hrefDecoded.substring(start, end), href);
            }
            catch (IOException e) {
                ZimbraLog.dav.warn((Object)("can't decode href " + href), e);
            }
        }
        return uidmap;
    }

    protected boolean needCalendarData(DavContext ctxt) throws DavException {
        String method = ctxt.getRequest().getMethod();
        if (method.equals("GET") || method.equals("DELETE")) {
            return true;
        }
        for (QName prop : ctxt.getRequestProp().getProps()) {
            if (sMetaProps.contains(prop)) continue;
            return true;
        }
        return false;
    }

    protected Mailbox getCalendarMailbox(DavContext ctxt) throws ServiceException, DavException {
        return this.getMailbox(ctxt);
    }

    protected Map<String, DavResource> getAppointmentMap(DavContext ctxt, TimeRange range) throws ServiceException, DavException {
        Mailbox mbox = this.getCalendarMailbox(ctxt);
        HashMap<String, DavResource> appts = new HashMap<String, DavResource>();
        ctxt.setCollectionPath(this.getUri());
        if (range == null) {
            range = new TimeRange(this.getOwner());
        }
        long start = range.getStart();
        long end = range.getEnd();
        start = start == Long.MIN_VALUE ? -1L : start;
        long l = end = end == Long.MAX_VALUE ? -1L : end;
        if (!this.needCalendarData(ctxt)) {
            ZimbraLog.dav.debug("METADATA only");
            this.mMetadataOnly = true;
            for (CalendarItem.CalendarMetadata item : mbox.getCalendarItemMetadata(ctxt.getOperationContext(), this.getId(), start, end)) {
                appts.put(item.uid, new CalendarObject.LightWeightCalendarObject(this.getUri(), this.getOwner(), item));
            }
        } else {
            for (CalendarItem calItem : mbox.getCalendarItemsForRange(ctxt.getOperationContext(), start, end, this.getId(), null)) {
                appts.put(calItem.getUid(), new CalendarObject.LocalCalendarObject(ctxt, calItem));
            }
        }
        return appts;
    }

    public java.util.Collection<DavResource> getAppointmentsByUids(DavContext ctxt, List<String> hrefs) throws ServiceException, DavException {
        Map<String, String> uidmap = this.getUidToHrefMap(hrefs);
        Mailbox mbox = this.getCalendarMailbox(ctxt);
        ArrayList<DavResource> appts = new ArrayList<DavResource>();
        ctxt.setCollectionPath(this.getUri());
        Map<String, CalendarItem> calItems = mbox.getCalendarItemsByUid(ctxt.getOperationContext(), new ArrayList<String>(uidmap.keySet()));
        for (String uid : calItems.keySet()) {
            CalendarItem calItem = calItems.get(uid);
            if (calItem == null) {
                appts.add(new DavResource.InvalidResource(uidmap.get(uid), this.getOwner()));
                continue;
            }
            appts.add(new CalendarObject.LocalCalendarObject(ctxt, calItem));
        }
        return appts;
    }

    private String findSummary(ZCalendar.ZVCalendar cal) {
        Iterator<ZCalendar.ZComponent> iter = cal.getComponentIterator();
        while (iter.hasNext()) {
            ZCalendar.ZComponent comp = iter.next();
            String summary = comp.getPropVal(ZCalendar.ICalTok.SUMMARY, null);
            if (summary == null) continue;
            return summary;
        }
        return "calendar event";
    }

    private String findEventUid(List<Invite> invites) throws DavException {
        String uid = null;
        LinkedList<Invite> inviteList = new LinkedList<Invite>();
        for (Invite i : invites) {
            byte type = i.getItemType();
            if (type == 11 || type == 15) {
                if (uid != null && uid.compareTo(i.getUid()) != 0) {
                    throw new DavException("too many events", 400, null);
                }
                uid = i.getUid();
            }
            if (i.isRecurrence()) {
                inviteList.addFirst(i);
                continue;
            }
            inviteList.addLast(i);
        }
        if (uid == null) {
            throw new DavException("no event in the request", 400, null);
        }
        invites.clear();
        invites.addAll(inviteList);
        return uid;
    }

    @Override
    public DavResource createItem(DavContext ctxt, String name) throws DavException, IOException {
        boolean useEtag;
        if (!ctxt.getUpload().getContentType().startsWith("text/calendar") || ctxt.getUpload().getSize() <= 0L) {
            throw new DavException("empty request", 400, null);
        }
        HttpServletRequest req = ctxt.getRequest();
        String etag = req.getHeader("If-Match");
        boolean bl = useEtag = etag != null;
        if (name.endsWith(".ics")) {
            name = name.substring(0, name.length() - ".ics".length());
        }
        Provisioning prov = Provisioning.getInstance();
        try {
            List<Invite> invites;
            String user = ctxt.getUser();
            Account account = prov.get(Provisioning.AccountBy.name, user);
            if (account == null) {
                throw new DavException("no such account " + user, 404, null);
            }
            InputStream is = ctxt.getUpload().getInputStream();
            try {
                ZCalendar.ZVCalendar vcalendar = ZCalendar.ZCalendarBuilder.build(is, "utf-8");
                invites = Invite.createFromCalendar(account, this.findSummary(vcalendar), vcalendar, true);
            }
            catch (ServiceException se) {
                throw new DavException("cannot parse ics", 400, se);
            }
            String uid = this.findEventUid(invites);
            if (!uid.equals(name)) {
                StringBuilder url = new StringBuilder();
                url.append(DavServlet.getDavUrl(user)).append(this.mPath).append("/").append(uid).append(".ics");
                ctxt.getResponse().sendRedirect(url.toString());
                throw new DavException("wrong url", 301, null);
            }
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
            CalendarItem calItem = mbox.getCalendarItemByUid(ctxt.getOperationContext(), name);
            if (calItem == null && useEtag) {
                throw new DavException("event not found", 404, null);
            }
            boolean isNewItem = true;
            if (useEtag) {
                String itemEtag = MailItemResource.getEtag(calItem);
                if (!itemEtag.equals(etag)) {
                    throw new DavException("CalDAV client has stale event: event has different etag (" + itemEtag + ") vs " + etag, 409);
                }
                isNewItem = false;
            }
            int flags = 0;
            long tags = 0L;
            List<CalendarItem.ReplyInfo> replies = null;
            if (calItem != null) {
                flags = calItem.getFlagBitmask();
                tags = calItem.getTagBitmask();
                replies = calItem.getAllReplies();
            }
            Mailbox.SetCalendarItemData scidDefault = new Mailbox.SetCalendarItemData();
            Mailbox.SetCalendarItemData[] scidExceptions = null;
            if (invites.size() > 1) {
                scidExceptions = new Mailbox.SetCalendarItemData[invites.size() - 1];
            }
            int idxExceptions = 0;
            boolean first = true;
            for (Invite i : invites) {
                ZOrganizer org;
                if (i.getUid() == null) {
                    i.setUid(uid);
                }
                if ((i.hasOrganizer() || i.hasOtherAttendees()) && (org = i.getOrganizer()) == null) {
                    org = new ZOrganizer(ctxt.getAuthAccount().getName(), null);
                    i.setOrganizer(org);
                }
                if (first) {
                    scidDefault.mInv = i;
                    first = false;
                    continue;
                }
                Mailbox.SetCalendarItemData scid = new Mailbox.SetCalendarItemData();
                scid.mInv = i;
                scidExceptions[idxExceptions++] = scid;
            }
            calItem = mbox.setCalendarItem(ctxt.getOperationContext(), this.mId, flags, tags, scidDefault, scidExceptions, replies, 0L);
            return new CalendarObject.LocalCalendarObject(ctxt, calItem, isNewItem);
        }
        catch (ServiceException e) {
            throw new DavException("cannot create icalendar item", 500, e);
        }
    }

    public String getFreeBusyReport(DavContext ctxt, TimeRange range) throws ServiceException, DavException {
        Mailbox mbox = this.getCalendarMailbox(ctxt);
        FreeBusy fb = mbox.getFreeBusy(ctxt.getOperationContext(), range.getStart(), range.getEnd(), -1);
        return fb.toVCalendar(FreeBusy.Method.REPLY, ctxt.getAuthAccount().getName(), mbox.getAccount().getName(), null);
    }

    static {
        sMetaProps.add(DavElements.E_GETETAG);
        sMetaProps.add(DavElements.E_RESOURCETYPE);
        sMetaProps.add(DavElements.E_DISPLAYNAME);
    }
}

