/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.PhantomResource;
import com.zimbra.cs.dav.resource.SearchWrapper;
import com.zimbra.cs.index.BrowseTerm;
import com.zimbra.cs.mailbox.BrowseResult;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseWrapper
extends PhantomResource {
    private BrowseBy mAction;

    BrowseWrapper(String uri, String owner) {
        this(uri, owner, BrowseWrapper.parseUri(uri));
    }

    BrowseWrapper(String uri, String owner, List<String> tokens) {
        super(uri, owner, tokens);
        String name = (String)this.mTokens.get(this.mTokens.size() - 1);
        this.mAction = tokens.size() == 1 ? BrowseBy.menu : (name.equals("by-date") ? BrowseBy.date : (name.equals("by-type") ? BrowseBy.type : (name.equals("by-sender") ? BrowseBy.sender : BrowseBy.date)));
    }

    @Override
    public InputStream getContent(DavContext ctxt) {
        return null;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public List<DavResource> getChildren(DavContext ctxt) {
        try {
            switch (this.mAction) {
                case menu: {
                    return this.generateMenu(ctxt);
                }
                case date: {
                    return this.browseByDate(ctxt);
                }
                case sender: {
                    return this.browseBySender(ctxt);
                }
                case type: {
                    return this.browseByType(ctxt);
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.dav.error((Object)("can't generate browse resource: uri=" + this.getUri()), e);
        }
        catch (IOException e) {
            ZimbraLog.dav.error((Object)("can't generate browse resource: uri=" + this.getUri()), e);
        }
        return Collections.emptyList();
    }

    private String generateUri(String path) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getUri());
        if (buf.charAt(buf.length() - 1) != '/') {
            buf.append("/");
        }
        buf.append(path);
        return buf.toString();
    }

    private List<DavResource> generateMenu(DavContext ctxt) {
        ArrayList<DavResource> menu = new ArrayList<DavResource>();
        menu.add(new BrowseWrapper(this.generateUri("by-date"), this.getOwner()));
        menu.add(new BrowseWrapper(this.generateUri("by-type"), this.getOwner()));
        menu.add(new BrowseWrapper(this.generateUri("by-sender"), this.getOwner()));
        return menu;
    }

    private List<DavResource> browseByDate(DavContext ctxt) {
        ArrayList<DavResource> res = new ArrayList<DavResource>();
        res.add(new SearchWrapper(this.generateUri("today"), this.getOwner()));
        res.add(new SearchWrapper(this.generateUri("last-week"), this.getOwner()));
        res.add(new SearchWrapper(this.generateUri("last-month"), this.getOwner()));
        res.add(new SearchWrapper(this.generateUri("last-year"), this.getOwner()));
        return res;
    }

    private List<DavResource> browseBySender(DavContext ctxt) throws IOException, ServiceException {
        ArrayList<DavResource> res = new ArrayList<DavResource>();
        String user = ctxt.getUser();
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        BrowseResult br = mbox.browse(ctxt.getOperationContext(), Mailbox.BrowseBy.domains, "", 0);
        for (BrowseTerm bt : br.getResult()) {
            BrowseResult.DomainItem di;
            if (!(bt instanceof BrowseResult.DomainItem) || !(di = (BrowseResult.DomainItem)bt).isFrom()) continue;
            res.add(new BrowseWrapper(this.generateUri(di.getDomain()), this.getOwner()));
        }
        return res;
    }

    private List<DavResource> browseByType(DavContext ctxt) throws IOException, ServiceException {
        ArrayList<DavResource> res = new ArrayList<DavResource>();
        String user = ctxt.getUser();
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, user);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        BrowseResult br = mbox.browse(ctxt.getOperationContext(), Mailbox.BrowseBy.attachments, "", 0);
        for (BrowseTerm bt : br.getResult()) {
            String ctype = bt.term;
            int index = ctype.indexOf(47);
            if (index != -1 || ctype.equals("message") || ctype.equals("none")) continue;
            res.add(new BrowseWrapper(this.generateUri(ctype), this.getOwner()));
        }
        res.add(new BrowseWrapper(this.generateUri("word"), this.getOwner()));
        res.add(new BrowseWrapper(this.generateUri("excel"), this.getOwner()));
        res.add(new BrowseWrapper(this.generateUri("ppt"), this.getOwner()));
        res.add(new BrowseWrapper(this.generateUri("pdf"), this.getOwner()));
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BrowseBy {
        menu,
        date,
        type,
        sender;

    }
}

