/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.PhantomResource;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment
extends PhantomResource {
    private byte[] mContent;

    public Attachment(String uri, String owner, long date, int contentLength) {
        this(uri, owner, Attachment.parseUri(uri));
        this.setCreationDate(date);
        this.setLastModifiedDate(date);
        this.setProperty("getcontentlength", Integer.toString(contentLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attachment(String uri, String owner, List<String> tokens, DavContext ctxt) throws DavException {
        block13: {
            this(uri, owner, tokens);
            user = ctxt.getUser();
            prov = Provisioning.getInstance();
            name = tokens.get(tokens.size() - 1);
            query = new StringBuilder();
            needQuotes = name.indexOf(32) > 0;
            query.append("filename:");
            if (needQuotes) {
                query.append("'");
            }
            query.append(name);
            if (needQuotes) {
                query.append("'");
            }
            zqr = null;
            found = false;
            try {
                try {
                    account = prov.get(Provisioning.AccountBy.name, user);
                    mbox = MailboxManager.getInstance().getMailboxByAccount(account);
                    zqr = mbox.search(ctxt.getOperationContext(), query.toString(), Attachment.SEARCH_TYPES, SortBy.NAME_ASCENDING, 10);
                    if (zqr.hasNext() && (hit = zqr.getNext()) instanceof MessageHit) {
                        message = ((MessageHit)hit).getMessage();
                        this.setCreationDate(message.getDate());
                        this.setLastModifiedDate(message.getChangeDate());
                        msg = message.getMimeMessage();
                        parts = Mime.getParts(msg);
                        for (MPartInfo p : parts) {
                            fname = p.getFilename();
                            if (!name.equals(fname)) continue;
                            partName = p.getPartName();
                            this.mContent = ByteUtil.getContent(Mime.getMimePart((MimePart)msg, partName).getInputStream(), 0);
                            this.setProperty("getcontentlength", Integer.toString(this.mContent.length));
                            this.setProperty("getcontenttype", p.getContentType());
                            found = true;
                            break;
                        }
                    }
                    var23_23 = null;
                    if (zqr == null) break block13;
                }
                catch (Exception e) {
                    ZimbraLog.dav.error((Object)("can't search for: attachment=" + name), e);
                    var23_24 = null;
                    if (zqr != null) {
                        try {
                            zqr.doneWithSearchResults();
                        }
                        catch (ServiceException e) {}
                    }
                    break block13;
                }
            }
            catch (Throwable var22_29) {
                var23_25 = null;
                if (zqr == null) throw var22_29;
                ** try [egrp 2[TRYBLOCK] [4 : 394->404)] { 
lbl57:
                // 1 sources

                zqr.doneWithSearchResults();
                throw var22_29;
lbl59:
                // 1 sources

                catch (ServiceException e) {
                    // empty catch block
                }
                throw var22_29;
            }
            try {}
            catch (ServiceException e) {}
            zqr.doneWithSearchResults();
        }
        if (found != false) return;
        throw new DavException("invalid uri", 404, null);
    }

    public Attachment(String uri, String owner, List<String> tokens) {
        super(uri, owner, tokens);
    }

    @Override
    public InputStream getContent(DavContext ctxt) {
        return new ByteArrayInputStream(this.mContent);
    }

    @Override
    public boolean isCollection() {
        return false;
    }
}

