/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.calendar.cache.CtagInfo;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.QName;

public class AddressbookCollection
extends Collection {
    private String mCtag;
    private static QName[] SUPPORTED_REPORTS = new QName[]{DavElements.CardDav.E_ADDRESSBOOK_MULTIGET, DavElements.CardDav.E_ADDRESSBOOK_QUERY, DavElements.E_ACL_PRINCIPAL_PROP_SET, DavElements.E_PRINCIPAL_MATCH, DavElements.E_PRINCIPAL_PROPERTY_SEARCH, DavElements.E_PRINCIPAL_SEARCH_PROPERTY_SET, DavElements.E_EXPAND_PROPERTY};

    public AddressbookCollection(DavContext ctxt, Folder f) throws DavException, ServiceException {
        super(ctxt, f);
        Account acct = f.getAccount();
        Locale lc = acct.getLocale();
        String description = L10nUtil.getMessage(L10nUtil.MsgKey.carddavAddressbookDescription, lc, acct.getAttr("displayName"), f.getName());
        ResourceProperty rp = new ResourceProperty(DavElements.CardDav.E_ADDRESSBOOK_DESCRIPTION);
        rp.setMessageLocale(lc);
        rp.setStringValue(description);
        rp.setProtected(false);
        this.addProperty(rp);
        rp = new ResourceProperty(DavElements.CardDav.E_SUPPORTED_ADDRESS_DATA);
        Element vcard = rp.addChild(DavElements.CardDav.E_ADDRESS_DATA);
        vcard.addAttribute("content-type", "text/vcard");
        vcard.addAttribute("version", "3.0");
        rp.setProtected(true);
        this.addProperty(rp);
        long maxSize = Provisioning.getInstance().getLocalServer().getLongAttr("zimbraFileUploadMaxSize", -1L);
        if (maxSize > 0L) {
            rp = new ResourceProperty(DavElements.CardDav.E_MAX_RESOURCE_SIZE_ADDRESSBOOK);
            rp.setStringValue(Long.toString(maxSize));
            rp.setProtected(true);
            this.addProperty(rp);
        }
        if (f.getDefaultView() == 6) {
            this.addResourceType(DavElements.CardDav.E_ADDRESSBOOK);
        }
        this.mCtag = CtagInfo.makeCtag(f);
        this.setProperty(DavElements.E_GETCTAG, this.mCtag);
    }

    protected QName[] getSupportedReports() {
        return SUPPORTED_REPORTS;
    }
}

