/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.resource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.CardDavProperty;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.MailItemResource;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.service.formatter.VCard;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressObject
extends MailItemResource {
    public static final String VCARD_EXTENSION = ".vcf";

    public AddressObject(DavContext ctxt, Contact item) throws ServiceException {
        super(ctxt, item);
        this.setProperty("getcontenttype", "text/vcard");
        this.setProperty("getcontentlength", Integer.toString(this.mId));
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public ResourceProperty getProperty(Element prop) {
        if (prop.getQName().equals(DavElements.CardDav.E_ADDRESS_DATA)) {
            return CardDavProperty.getAddressbookData(prop, this);
        }
        return super.getProperty(prop);
    }

    @Override
    protected InputStream getRawContent(DavContext ctxt) throws DavException, IOException {
        try {
            return new ByteArrayInputStream(this.toVCard(ctxt).getBytes("UTF-8"));
        }
        catch (ServiceException e) {
            ZimbraLog.dav.warn("can't get content for Contact %d", (Object)this.mId, e);
            return null;
        }
    }

    public String toVCard(DavContext ctxt) throws ServiceException, DavException {
        Contact contact = (Contact)this.getMailItem(ctxt);
        return VCard.formatContact((Contact)contact, null, (boolean)true).formatted;
    }

    public String toVCard(DavContext ctxt, Collection<String> attrs) throws ServiceException, DavException {
        if (attrs == null || attrs.isEmpty()) {
            return this.toVCard(ctxt);
        }
        Contact contact = (Contact)this.getMailItem(ctxt);
        return VCard.formatContact((Contact)contact, attrs, (boolean)true).formatted;
    }
}

