/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.property;

import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.httpclient.URLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProperty {
    private boolean mProtected;
    private boolean mVisible;
    private boolean mLive;
    private QName mName;
    private Locale mLocale;
    private String mValue;
    protected ArrayList<Element> mChildren;

    public ResourceProperty(String name) {
        this(QName.get(name, DavElements.WEBDAV_NS));
    }

    public ResourceProperty(QName name) {
        this.mName = name;
        this.mChildren = new ArrayList();
    }

    public ResourceProperty(Element elem) {
        this(elem.getQName());
        this.mValue = elem.getText();
        for (Object o : elem.elements()) {
            if (!(o instanceof Element)) continue;
            this.mChildren.add((Element)o);
        }
    }

    public QName getName() {
        return this.mName;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean isLive() {
        return this.mLive;
    }

    public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
        Element elem = parent.addElement(this.mName);
        if (nameOnly) {
            return elem;
        }
        if (this.mValue != null) {
            if (this.mLocale != null) {
                elem.addAttribute(DavElements.E_LANG, this.mLocale.toString());
            }
            elem.setText(this.mValue);
        } else {
            for (Element child : this.mChildren) {
                elem.add(child.createCopy());
            }
        }
        return elem;
    }

    public void setMessageLocale(Locale locale) {
        this.mLocale = locale;
    }

    public void setStringValue(String value) {
        this.mValue = value;
    }

    public String getStringValue() {
        return this.mValue;
    }

    public Element addChild(QName e) {
        DefaultElement child = new DefaultElement(e);
        this.mChildren.add(child);
        return child;
    }

    public List<Element> getChildren() {
        return this.mChildren;
    }

    public void setProtected(boolean pr) {
        this.mProtected = pr;
        this.mVisible = !pr;
    }

    public void setVisible(boolean v) {
        this.mVisible = v;
    }

    protected Element createHref(String path) {
        Element e = DocumentHelper.createElement(DavElements.E_HREF);
        e.setText(URLUtil.urlEscape(path));
        return e;
    }

    public String toString() {
        return "ResourceProperty: " + this.mName + (this.mValue != null ? ": '" + this.mValue + "'" : "");
    }
}

