/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.property;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.AddressObject;
import java.util.ArrayList;
import org.dom4j.Element;
import org.dom4j.QName;

public class CardDavProperty
extends ResourceProperty {
    public static ResourceProperty getAddressbookHomeSet(String user) {
        return new AddressbookHomeSet(user);
    }

    public static ResourceProperty getAddressbookData(Element prop, AddressObject contact) {
        return new AddressbookData(prop, contact);
    }

    protected CardDavProperty(QName name) {
        super(name);
        this.setProtected(true);
        this.setVisible(true);
    }

    private static class AddressbookData
    extends CardDavProperty {
        ArrayList<String> props = new ArrayList();
        AddressObject contact;

        public AddressbookData(Element prop, AddressObject c) {
            super(DavElements.CardDav.E_ADDRESS_DATA);
            for (Object child : prop.elements()) {
                Element e;
                if (!(child instanceof Element) || !(e = (Element)child).getQName().equals(DavElements.CardDav.E_PROP)) continue;
                this.props.add(e.attributeValue("name"));
            }
            this.contact = c;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element abd = super.toElement(ctxt, parent, nameOnly);
            try {
                abd.setText(this.contact.toVCard(ctxt, this.props));
            }
            catch (Exception e) {
                ZimbraLog.dav.warn((Object)"can't get vcard content", e);
            }
            return abd;
        }
    }

    private static class AddressbookHomeSet
    extends CardDavProperty {
        public AddressbookHomeSet(String user) {
            super(DavElements.CardDav.E_ADDRESSBOOK_HOME_SET);
            this.mChildren.add(this.createHref("/dav/" + user + "/"));
        }
    }
}

