/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.property;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.CalendarObject;
import com.zimbra.cs.dav.resource.Principal;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalDavProperty
extends ResourceProperty {
    private static final CalComponent[] sSUPPORTED_COMPONENTS = new CalComponent[]{CalComponent.VCALENDAR, CalComponent.VTIMEZONE, CalComponent.VFREEBUSY};
    private static final String INDIVIDUAL = "INDIVIDUAL";
    private static final String RESOURCE = "RESOURCE";
    private static final String ROOM = "ROOM";
    private static final String UNKNOWN = "UNKNOWN";

    public static ResourceProperty getSupportedCalendarComponentSet(byte view) {
        return new SupportedCalendarComponentSet(view);
    }

    public static ResourceProperty getSupportedCalendarData() {
        return new SupportedCalendarData();
    }

    public static ResourceProperty getSupportedCollationSet() {
        return new SupportedCollationSet();
    }

    public static ResourceProperty getCalendarData(CalendarObject obj) {
        return new CalendarData(obj);
    }

    public static ResourceProperty getCalendarHomeSet(String user) {
        return new CalendarHomeSet(user);
    }

    public static ResourceProperty getScheduleInboxURL(String user) {
        return new ScheduleInboxURL(user);
    }

    public static ResourceProperty getScheduleOutboxURL(String user) {
        return new ScheduleOutboxURL(user);
    }

    public static ResourceProperty getCalendarUserAddressSet(Collection<String> addrs) {
        return new CalendarUserAddressSet(addrs);
    }

    public static ResourceProperty getCalendarFreeBusySet(String user, Collection<Folder> folders) {
        return new CalendarFreeBusySet(user, folders);
    }

    public static ResourceProperty getCalendarUserType(Principal p) {
        return new CalendarUserType(p);
    }

    protected CalDavProperty(QName name) {
        super(name);
        this.setProtected(true);
    }

    public static CalComponent getCalComponent(String comp) {
        return CalComponent.valueOf(comp);
    }

    private static class CalendarUserType
    extends CalDavProperty {
        public CalendarUserType(Principal p) {
            super(DavElements.E_CALENDAR_USER_TYPE);
            String resType = p.getAccount().getAttr("zimbraCalResType");
            if (resType == null) {
                this.setStringValue(CalDavProperty.INDIVIDUAL);
            } else if (resType.compareTo("Equipment") == 0) {
                this.setStringValue(CalDavProperty.RESOURCE);
            } else if (resType.compareTo("Location") == 0) {
                this.setStringValue(CalDavProperty.ROOM);
            } else {
                this.setStringValue(CalDavProperty.UNKNOWN);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarFreeBusySet
    extends CalDavProperty {
        public CalendarFreeBusySet(String user, Collection<Folder> folders) {
            super(DavElements.E_CALENDAR_FREE_BUSY_SET);
            this.setProtected(false);
            this.setVisible(false);
            ArrayList<Integer> parentIds = new ArrayList<Integer>();
            try {
                String[] homeSets = Provisioning.getInstance().getConfig().getMultiAttr("zimbraCalendarCalDavAlternateCalendarHomeSet");
                if (homeSets != null) {
                    for (Folder f : folders) {
                        String name = f.getName();
                        for (String homeset : homeSets) {
                            if (name.compareTo(homeset) != 0) continue;
                            parentIds.add(f.getId());
                        }
                    }
                }
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"can't generate calendar home set", se);
            }
            for (Folder f : folders) {
                if (f.getDefaultView() != 11 && f.getDefaultView() != 15 || parentIds.isEmpty() && f.getFolderId() != 1 || !parentIds.isEmpty() && !parentIds.contains(f.getFolderId()) || (f.getFlagBitmask() & Flag.BITMASK_EXCLUDE_FREEBUSY) != 0) continue;
                this.mChildren.add(this.createHref("/dav/" + user + f.getPath() + "/"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarUserAddressSet
    extends CalDavProperty {
        public CalendarUserAddressSet(Collection<String> addrs) {
            super(DavElements.E_CALENDAR_USER_ADDRESS_SET);
            for (String addr : addrs) {
                Element e = DocumentHelper.createElement(DavElements.E_HREF);
                if (!(addr.startsWith("http:") || addr.startsWith("mailto:") || addr.startsWith("/"))) {
                    addr = "mailto:" + addr;
                }
                e.setText(addr);
                this.mChildren.add(e);
            }
        }
    }

    private static class ScheduleOutboxURL
    extends CalDavProperty {
        private String mUser;

        public ScheduleOutboxURL(String user) {
            super(DavElements.E_SCHEDULE_OUTBOX_URL);
            this.mUser = user;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element outboxUrl = super.toElement(ctxt, parent, nameOnly);
            String authUser = ctxt.getAuthAccount().getName();
            try {
                authUser = Principal.getOwner(ctxt.getAuthAccount(), ctxt.getUri());
            }
            catch (ServiceException se) {
                // empty catch block
            }
            String url = "/dav/" + authUser + "/Sent/";
            outboxUrl.add(this.createHref(url));
            return outboxUrl;
        }
    }

    private static class ScheduleInboxURL
    extends CalDavProperty {
        private String mUser;

        public ScheduleInboxURL(String user) {
            super(DavElements.E_SCHEDULE_INBOX_URL);
            this.mUser = user;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element inboxUrl = super.toElement(ctxt, parent, nameOnly);
            String authUser = ctxt.getAuthAccount().getName();
            try {
                authUser = Principal.getOwner(ctxt.getAuthAccount(), ctxt.getUri());
            }
            catch (ServiceException se) {
                // empty catch block
            }
            String url = "/dav/" + authUser + "/Inbox/";
            if (!authUser.equals(this.mUser)) {
                url = url + this.mUser + "/";
            }
            inboxUrl.add(this.createHref(url));
            return inboxUrl;
        }
    }

    private static class CalendarHomeSet
    extends CalDavProperty {
        public CalendarHomeSet(String user) {
            super(DavElements.E_CALENDAR_HOME_SET);
            String[] homeSets = null;
            try {
                homeSets = Provisioning.getInstance().getConfig().getMultiAttr("zimbraCalendarCalDavAlternateCalendarHomeSet");
            }
            catch (ServiceException se) {
                // empty catch block
            }
            if (homeSets == null || homeSets.length == 0) {
                this.mChildren.add(this.createHref("/dav/" + user + "/"));
            } else {
                for (String calHome : homeSets) {
                    this.mChildren.add(this.createHref("/dav/" + user + "/" + calHome + "/"));
                }
            }
        }
    }

    private static class CalendarData
    extends CalDavProperty {
        CalendarObject rs;

        public CalendarData(CalendarObject calobj) {
            super(DavElements.E_CALENDAR_DATA);
            this.rs = calobj;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            if (this.getStringValue() == null) {
                try {
                    this.setStringValue(this.rs.getVcalendar(ctxt, null));
                }
                catch (IOException e) {
                    this.setStringValue("");
                    ZimbraLog.dav.warn((Object)"can't get appt data", e);
                }
                catch (DavException e) {
                    this.setStringValue("");
                    ZimbraLog.dav.warn((Object)"can't get appt data", e);
                }
            }
            return super.toElement(ctxt, parent, nameOnly);
        }
    }

    private static class SupportedCollationSet
    extends CalDavProperty {
        public SupportedCollationSet() {
            super(DavElements.E_SUPPORTED_COLLATION_SET);
            Element e = DocumentHelper.createElement(DavElements.E_SUPPORTED_COLLATION);
            e.setText("i;ascii-casemap");
            this.mChildren.add(e);
            e = DocumentHelper.createElement(DavElements.E_SUPPORTED_COLLATION);
            e.setText("i;octet");
            this.mChildren.add(e);
        }
    }

    private static class SupportedCalendarData
    extends CalDavProperty {
        public SupportedCalendarData() {
            super(DavElements.E_SUPPORTED_CALENDAR_DATA);
            Element e = DocumentHelper.createElement(DavElements.E_CALENDAR_DATA);
            e.addAttribute("content-type", "text/calendar");
            e.addAttribute("version", "2.0");
            this.mChildren.add(e);
        }
    }

    private static class SupportedCalendarComponentSet
    extends CalDavProperty {
        public SupportedCalendarComponentSet(byte view) {
            super(DavElements.E_SUPPORTED_CALENDAR_COMPONENT_SET);
            ArrayList<CalComponent> comps = new ArrayList<CalComponent>();
            Collections.addAll(comps, sSUPPORTED_COMPONENTS);
            Provisioning prov = Provisioning.getInstance();
            boolean useDistinctCollectionType = false;
            try {
                useDistinctCollectionType = prov.getConfig().getBooleanAttr("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", false);
            }
            catch (ServiceException se) {
                ZimbraLog.dav.warn((Object)"can't get zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection in globalConfig", se);
            }
            if (!useDistinctCollectionType) {
                comps.add(CalComponent.VEVENT);
                comps.add(CalComponent.VTODO);
            } else if (view == 11) {
                comps.add(CalComponent.VEVENT);
            } else if (view == 15) {
                comps.add(CalComponent.VTODO);
            }
            for (CalComponent comp : comps) {
                Element e = DocumentHelper.createElement(DavElements.E_COMP);
                e.addAttribute("name", comp.name());
                this.mChildren.add(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CalComponent {
        VCALENDAR,
        VEVENT,
        VTODO,
        VJOURNAL,
        VTIMEZONE,
        VFREEBUSY;

    }
}

