/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.property;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acl
extends ResourceProperty {
    protected ACL mAcl;
    protected String mOwner;
    protected static HashMap<String, Short> sRightsMap = new HashMap();
    private static final short RIGHT_UNSUPPORTED = 0;

    public static Set<ResourceProperty> getAclProperties(DavResource rs, Folder folder) throws ServiceException, DavException {
        HashSet<ResourceProperty> props = new HashSet<ResourceProperty>();
        if (folder == null) {
            return props;
        }
        String owner = rs.getOwner();
        ACL acl = folder.getEffectiveACL();
        props.add(Acl.getSupportedPrivilegeSet());
        if (folder != null) {
            if (folder.getDefaultView() != 11 || folder.getUrl() == null || folder.getUrl().equals("")) {
                props.add(Acl.getCurrentUserPrivilegeSet(acl, folder.getAccount()));
            } else {
                props.add(Acl.getCurrentUserPrivilegeSet((short)1));
            }
            props.add(Acl.getPrincipalCollectionSet());
        }
        props.add(Acl.getAcl(acl, owner));
        props.add(Acl.getAclRestrictions());
        ResourceProperty p = new ResourceProperty(DavElements.E_OWNER);
        p.setProtected(true);
        Element href = p.addChild(DavElements.E_HREF);
        href.setText(UrlNamespace.getPrincipalUrl(owner));
        props.add(p);
        p = new ResourceProperty(DavElements.E_GROUP);
        p.setProtected(true);
        props.add(p);
        p = new ResourceProperty(DavElements.E_INHERITED_ACL_SET);
        p.setProtected(true);
        props.add(p);
        return props;
    }

    public static ResourceProperty getPrincipalUrl(DavResource rs) {
        return new PrincipalUrl(rs);
    }

    public static ResourceProperty getAcl(ACL acl, String owner) {
        return new Acl(acl, owner);
    }

    public static ResourceProperty getSupportedPrivilegeSet() {
        return new SupportedPrivilegeSet();
    }

    public static ResourceProperty getCurrentUserPrivilegeSet(ACL acl, Account owner) {
        return new CurrentUserPrivilegeSet(acl, owner);
    }

    public static ResourceProperty getCurrentUserPrivilegeSet(short rights) {
        return new CurrentUserPrivilegeSet(rights);
    }

    public static ResourceProperty getMountpointTargetPrivilegeSet(short rights) {
        return new MountpointTargetPrivilegeSet(rights);
    }

    public static ResourceProperty getAclRestrictions() {
        return new AclRestrictions();
    }

    public static ResourceProperty getPrincipalCollectionSet() {
        return new PrincipalCollectionSet();
    }

    public static ResourceProperty getCurrentUserPrincipal() {
        return new CurrentUserPrincipal();
    }

    private Acl(ACL acl, String owner) {
        this(DavElements.E_ACL, acl, owner);
    }

    private Acl(QName name, ACL acl, String owner) {
        super(name);
        this.setProtected(true);
        this.mAcl = acl;
        this.mOwner = owner;
    }

    @Override
    public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
        Element acl = super.toElement(ctxt, parent, true);
        if (this.mAcl == null) {
            return acl;
        }
        Account ownerAccount = null;
        Account authAccount = ctxt.getAuthAccount();
        try {
            ownerAccount = Provisioning.getInstance().getAccountByName(this.mOwner);
        }
        catch (ServiceException se) {
            // empty catch block
        }
        for (ACL.Grant g : this.mAcl.getGrants()) {
            try {
                if (ownerAccount != null && authAccount.compareTo(ownerAccount) != 0 && g.getGrantedRights(authAccount) == 0) continue;
                Element ace = acl.addElement(DavElements.E_ACE);
                Element principal = ace.addElement(DavElements.E_PRINCIPAL);
                switch (g.getGranteeType()) {
                    case 1: {
                        Element e = principal.addElement(DavElements.E_HREF);
                        e.setText(UrlNamespace.getAclUrl(g.getGranteeId(), "/principals/users/"));
                        break;
                    }
                    case 7: {
                        Element e = principal.addElement(DavElements.E_HREF);
                        e.setText(UrlNamespace.getAclUrl(g.getGranteeId(), "/principals/guests/"));
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 3: {
                        principal.addElement(DavElements.E_AUTHENTICATED);
                        break;
                    }
                    case 5: {
                        Element e = principal.addElement(DavElements.E_HREF);
                        e.setText(UrlNamespace.getAclUrl(g.getGranteeId(), "/principals/cos/"));
                        break;
                    }
                    case 4: {
                        Element e = principal.addElement(DavElements.E_HREF);
                        e.setText(UrlNamespace.getAclUrl(g.getGranteeId(), "/principals/domain/"));
                        break;
                    }
                    case 2: {
                        Element e = principal.addElement(DavElements.E_HREF);
                        e.setText(UrlNamespace.getAclUrl(g.getGranteeId(), "/principals/groups/"));
                        break;
                    }
                    case 6: {
                        principal.addElement(DavElements.E_UNAUTHENTICATED);
                    }
                }
                this.addGrantDeny(ace, g, true);
            }
            catch (DavException e) {
                ZimbraLog.dav.error((Object)("can't add principal: grantee=" + g.getGranteeId()), e);
            }
            catch (ServiceException e) {
                ZimbraLog.dav.error((Object)("can't add principal: grantee=" + g.getGranteeId()), e);
            }
        }
        return acl;
    }

    protected Element addGrantDeny(Element ace, ACL.Grant g, boolean isGrant) {
        Element grant = isGrant ? ace.addElement(DavElements.E_GRANT) : ace.addElement(DavElements.E_DENY);
        this.addPrivileges(grant, g.getGrantedRights());
        return grant;
    }

    protected Element addPrivileges(Element grant, short rights) {
        grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_READ_CURRENT_USER_PRIVILEGE_SET);
        if ((rights & 1) > 0) {
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_READ);
        }
        if ((rights & 2) > 0) {
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_WRITE);
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_WRITE_CONTENT);
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_WRITE_PROPERTIES);
        }
        if ((rights & 4) > 0) {
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_BIND);
        }
        if ((rights & 8) > 0) {
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_UNBIND);
        }
        if ((rights & 0x100) > 0) {
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_UNLOCK);
            grant.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_WRITE_ACL);
        }
        return grant;
    }

    static {
        sRightsMap.put("read", (short)1);
        sRightsMap.put("read-current-user-privilege-set", (short)1);
        sRightsMap.put("read-free-busy", (short)0);
        sRightsMap.put("bind", (short)2);
        sRightsMap.put("unbind", (short)2);
        sRightsMap.put("write", (short)2);
        sRightsMap.put("write-acl", (short)256);
        sRightsMap.put("write-content", (short)2);
        sRightsMap.put("write-properties", (short)2);
        sRightsMap.put("unlock", (short)256);
    }

    public static class Ace {
        private String mPrincipalUrl;
        private String mId;
        private short mRights;
        private byte mGranteeType;

        public Ace(Element a) throws DavException {
            Element elem = a.element(DavElements.E_PRINCIPAL);
            if (elem == null) {
                throw new DavException("missing principal element", 400);
            }
            List principal = elem.elements();
            if (principal.size() != 1) {
                throw new DavException("invalid principal element", 400);
            }
            for (Element p : principal) {
                QName name = p.getQName();
                if (name.equals(DavElements.E_HREF)) {
                    this.mPrincipalUrl = elem.getText();
                    this.mGranteeType = 1;
                    try {
                        Account acc = UrlNamespace.getPrincipal(this.mPrincipalUrl);
                        if (acc == null) {
                            throw new DavException("invalid principal: " + this.mPrincipalUrl, 400);
                        }
                        this.mId = acc.getId();
                        continue;
                    }
                    catch (ServiceException se) {
                        throw new DavException("can't find principal: " + this.mPrincipalUrl, 500, se);
                    }
                }
                if (name.equals(DavElements.E_ALL)) {
                    this.mGranteeType = (byte)6;
                    continue;
                }
                if (name.equals(DavElements.E_UNAUTHENTICATED)) {
                    this.mGranteeType = (byte)6;
                    continue;
                }
                if (name.equals(DavElements.E_AUTHENTICATED)) {
                    this.mGranteeType = (byte)3;
                    continue;
                }
                throw new DavException("unsupported principal: " + name.getName(), 501);
            }
            if (elem != null) {
                elem = elem.element(DavElements.E_HREF);
            }
            this.mRights = 0;
            elem = a.element(DavElements.E_GRANT);
            if (elem == null) {
                throw new DavException("missing grant element", 400);
            }
            List priv = elem.elements(DavElements.E_PRIVILEGE);
            for (Element p : priv) {
                List right = p.elements();
                if (right.size() != 1) {
                    throw new DavException("number of right elements contained in privilege element is not one", 400);
                }
                this.mRights = (short)(this.mRights | sRightsMap.get(((Element)right.get(0)).getName()));
            }
        }

        public Ace(String id, short rights, byte type) {
            this.mId = id;
            this.mRights = rights;
            this.mGranteeType = type;
        }

        public String getPrincipalUrl() {
            if (this.mPrincipalUrl != null) {
                return this.mPrincipalUrl;
            }
            switch (this.mGranteeType) {
                case 1: {
                    try {
                        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mId);
                        this.mPrincipalUrl = UrlNamespace.getPrincipalCollectionUrl(acct);
                        break;
                    }
                    catch (ServiceException se) {
                        ZimbraLog.dav.warn((Object)("can't lookup account " + this.mId), se);
                    }
                }
            }
            return this.mPrincipalUrl;
        }

        public String getZimbraId() {
            return this.mId;
        }

        public byte getGranteeType() {
            return this.mGranteeType;
        }

        public short getRights() {
            return this.mRights;
        }

        public boolean hasHref() {
            return this.mGranteeType == 1;
        }
    }

    private static class AclRestrictions
    extends Acl {
        public AclRestrictions() {
            super(DavElements.E_ACL_RESTRICTIONS, null, null);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element ar = parent.addElement(this.getName());
            ar.addElement(DavElements.E_GRANT_ONLY);
            ar.addElement(DavElements.E_NO_INVERT);
            return ar;
        }
    }

    private static class CurrentUserPrincipal
    extends Acl {
        public CurrentUserPrincipal() {
            super(DavElements.E_CURRENT_USER_PRINCIPAL, null, null);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element cup = parent.addElement(this.getName());
            cup.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(ctxt.getAuthAccount()));
            return cup;
        }
    }

    private static class PrincipalUrl
    extends Acl {
        private Account mAccount;

        public PrincipalUrl(DavResource rs) {
            super(DavElements.E_PRINCIPAL_URL, null, null);
            try {
                this.mAccount = Provisioning.getInstance().get(Provisioning.AccountBy.name, rs.getOwner());
            }
            catch (ServiceException e) {
                ZimbraLog.dav.warn((Object)("can't get account " + rs.getOwner()), e);
            }
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element pu = parent.addElement(this.getName());
            if (this.mAccount != null) {
                pu.addElement(DavElements.E_HREF).setText(UrlNamespace.getPrincipalUrl(this.mAccount));
            }
            return pu;
        }
    }

    private static class MountpointTargetPrivilegeSet
    extends Acl {
        private short mRights;

        public MountpointTargetPrivilegeSet(short rights) {
            super(DavElements.E_MOUNTPOINT_TARGET_PRIVILEGE_SET, null, null);
            this.mRights = rights;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element mtps = parent.addElement(this.getName());
            if (nameOnly) {
                return mtps;
            }
            this.addPrivileges(mtps, this.mRights);
            return mtps;
        }
    }

    private static class CurrentUserPrivilegeSet
    extends Acl {
        private String mOwnerId;
        private short mRights;

        public CurrentUserPrivilegeSet(ACL acl, Account owner) {
            super(DavElements.E_CURRENT_USER_PRIVILEGE_SET, acl, owner.getName());
            this.mOwnerId = owner.getId();
            this.mRights = (short)-1;
        }

        public CurrentUserPrivilegeSet(short rights) {
            super(DavElements.E_CURRENT_USER_PRIVILEGE_SET, null, null);
            this.mRights = rights;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element cups = parent.addElement(this.getName());
            if (nameOnly) {
                return cups;
            }
            if (this.mRights > 0) {
                this.addPrivileges(cups, this.mRights);
                if ((this.mRights & 2) == 0) {
                    cups.addElement(DavElements.E_PRIVILEGE).addElement(DavElements.E_WRITE_PROPERTIES);
                }
                return cups;
            }
            if (ctxt.getAuthAccount().getId().equals(this.mOwnerId)) {
                this.addPrivileges(cups, (short)15);
                return cups;
            }
            if (this.mAcl == null) {
                return cups;
            }
            for (ACL.Grant g : this.mAcl.getGrants()) {
                try {
                    short rights = g.getGrantedRights(ctxt.getAuthAccount());
                    if (rights <= 0) continue;
                    this.addPrivileges(cups, rights);
                    break;
                }
                catch (ServiceException e) {
                    ZimbraLog.dav.error((Object)("can't add principal: grantee=" + g.getGranteeId()), e);
                }
            }
            return cups;
        }
    }

    private static class SupportedPrivilegeSet
    extends Acl {
        public SupportedPrivilegeSet() {
            super(DavElements.E_SUPPORTED_PRIVILEGE_SET, null, null);
        }

        public Element addPrivilege(Element parent, QName name, String description) {
            Element priv = parent.addElement(DavElements.E_SUPPORTED_PRIVILEGE);
            priv.addElement(DavElements.E_PRIVILEGE).addElement(name);
            Element desc = priv.addElement(DavElements.E_DESCRIPTION);
            desc.addAttribute(DavElements.E_LANG, "en-us");
            desc.setText(description);
            return priv;
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element sps = parent.addElement(this.getName());
            if (nameOnly) {
                return sps;
            }
            if (this.mAcl == null) {
                return sps;
            }
            Element all = this.addPrivilege(sps, DavElements.E_ALL, "any operation");
            this.addPrivilege(all, DavElements.E_READ, "read calendar, attachment, notebook");
            this.addPrivilege(all, DavElements.E_WRITE, "add calendar appointment, upload attachment");
            this.addPrivilege(all, DavElements.E_UNLOCK, "unlock your own resources locked by someone else");
            return sps;
        }
    }

    private static class PrincipalCollectionSet
    extends ResourceProperty {
        public PrincipalCollectionSet() {
            super(DavElements.E_PRINCIPAL_COLLECTION_SET);
            this.setProtected(true);
        }

        public Element toElement(DavContext ctxt, Element parent, boolean nameOnly) {
            Element pcs = parent.addElement(this.getName());
            Element e = pcs.addElement(DavElements.E_HREF);
            try {
                e.setText(UrlNamespace.getPrincipalCollectionUrl(ctxt.getAuthAccount()));
            }
            catch (ServiceException ex) {
                ZimbraLog.dav.warn((Object)"can't generate principal-collection-url", ex);
            }
            return pcs;
        }
    }
}

