/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.client;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.client.DavObject;
import com.zimbra.cs.dav.client.DavRequest;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.util.BuildInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavClient {
    private String mUserAgent;
    private String mBaseUrl;
    private String mUsername;
    private String mPassword;
    private HttpClient mClient;
    private boolean mDebugEnabled = false;

    public WebDavClient(String baseUrl) {
        this(baseUrl, "ZCS");
    }

    public WebDavClient(String baseUrl, String app) {
        this.mBaseUrl = baseUrl;
        this.mClient = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        HttpProxyUtil.configureProxy(this.mClient);
        this.setAppName(app);
    }

    public Collection<DavObject> listObjects(String path, Collection<QName> extraProps) throws IOException, DavException {
        DavRequest propfind = DavRequest.PROPFIND(path);
        propfind.setDepth(DavContext.Depth.one);
        if (extraProps == null) {
            propfind.addRequestProp(DavElements.E_DISPLAYNAME);
            propfind.addRequestProp(DavElements.E_RESOURCETYPE);
            propfind.addRequestProp(DavElements.E_CREATIONDATE);
            propfind.addRequestProp(DavElements.E_GETCONTENTLENGTH);
            propfind.addRequestProp(DavElements.E_GETCONTENTLANGUAGE);
            propfind.addRequestProp(DavElements.E_GETCONTENTTYPE);
            propfind.addRequestProp(DavElements.E_GETETAG);
            propfind.addRequestProp(DavElements.E_GETLASTMODIFIED);
        } else {
            for (QName p : extraProps) {
                propfind.addRequestProp(p);
            }
        }
        return this.sendMultiResponseRequest(propfind);
    }

    public Collection<DavObject> sendMultiResponseRequest(DavRequest req) throws IOException, DavException {
        ArrayList<DavObject> ret = new ArrayList<DavObject>();
        HttpMethod m = null;
        try {
            try {
                m = this.executeFollowRedirect(req);
                int status = m.getStatusCode();
                if (status >= 400) {
                    throw new DavException("DAV server returned an error: " + status, status);
                }
                Document doc = com.zimbra.common.soap.Element.getSAXReader().read(m.getResponseBodyAsStream());
                Element top = doc.getRootElement();
                for (Object obj : top.elements(DavElements.E_RESPONSE)) {
                    if (!(obj instanceof Element)) continue;
                    ret.add(new DavObject((Element)obj));
                }
                Object var10_10 = null;
                if (m != null) {
                    m.releaseConnection();
                }
            }
            catch (DocumentException e) {
                throw new DavException("can't parse response", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (m != null) {
                m.releaseConnection();
            }
            throw throwable;
        }
        return ret;
    }

    public UserServlet.HttpInputStream sendRequest(DavRequest req) throws IOException, DavException {
        HttpMethod m = this.executeFollowRedirect(req);
        return new UserServlet.HttpInputStream(m);
    }

    public UserServlet.HttpInputStream sendGet(String href) throws IOException {
        GetMethod get = new GetMethod(this.mBaseUrl + href);
        this.executeMethod(get, DavContext.Depth.zero);
        return new UserServlet.HttpInputStream(get);
    }

    public UserServlet.HttpInputStream sendPut(String href, byte[] buf, String contentType, String etag, Collection<Pair<String, String>> headers) throws IOException {
        boolean done = false;
        PutMethod put = null;
        while (!done) {
            Header newLocation;
            put = new PutMethod(this.mBaseUrl + href);
            put.setRequestEntity(new ByteArrayRequestEntity(buf, contentType));
            if (this.mDebugEnabled && contentType.startsWith("text")) {
                ZimbraLog.dav.debug("PUT payload: \n" + new String(buf, "UTF-8"));
            }
            if (etag != null) {
                put.setRequestHeader("If-Match", etag);
            }
            if (headers != null) {
                for (Pair<String, String> h : headers) {
                    put.addRequestHeader(h.getFirst(), h.getSecond());
                }
            }
            this.executeMethod(put, DavContext.Depth.zero);
            int ret = put.getStatusCode();
            if ((ret == 301 || ret == 302) && (newLocation = put.getResponseHeader("Location")) != null) {
                href = newLocation.getValue();
                ZimbraLog.dav.debug("redirect to new url = " + href);
                put.releaseConnection();
                continue;
            }
            done = true;
        }
        return new UserServlet.HttpInputStream(put);
    }

    protected HttpMethod executeFollowRedirect(DavRequest req) throws IOException {
        HttpMethod method = null;
        boolean done = false;
        while (!done) {
            Header newLocation;
            method = this.execute(req);
            int ret = method.getStatusCode();
            if ((ret == 301 || ret == 302) && (newLocation = method.getResponseHeader("Location")) != null) {
                String uri = newLocation.getValue();
                ZimbraLog.dav.debug("redirect to new url = " + uri);
                method.releaseConnection();
                req.setRedirectUrl(uri);
                continue;
            }
            done = true;
        }
        return method;
    }

    protected HttpMethod execute(DavRequest req) throws IOException {
        if (this.mDebugEnabled) {
            ZimbraLog.dav.debug("Request payload: \n" + req.getRequestMessageString());
        }
        HttpMethod m = req.getHttpMethod(this.mBaseUrl);
        for (Pair<String, String> header : req.getRequestHeaders()) {
            m.addRequestHeader(header.getFirst(), header.getSecond());
        }
        return this.executeMethod(m, req.getDepth());
    }

    protected HttpMethod executeMethod(HttpMethod m, DavContext.Depth d) throws IOException {
        ZimbraLog.dav.debug("WebDAV request (depth=" + (Object)((Object)d) + "): " + m.getPath());
        HttpMethodParams p = m.getParams();
        if (p != null) {
            p.setCredentialCharset("UTF-8");
        }
        m.setDoAuthentication(true);
        m.setRequestHeader("User-Agent", this.mUserAgent);
        String depth = "0";
        switch (d) {
            case one: {
                depth = "1";
                break;
            }
            case infinity: {
                depth = "infinity";
            }
        }
        m.setRequestHeader("Depth", depth);
        this.mClient.executeMethod(m);
        if (this.mDebugEnabled && m.getResponseBody() != null) {
            ZimbraLog.dav.debug("WebDAV response:\n" + new String(m.getResponseBody(), "UTF-8"));
        }
        return m;
    }

    public void setCredential(String user, String pass) {
        this.mUsername = user;
        this.mPassword = pass;
        HttpState state = new HttpState();
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(this.mUsername, this.mPassword);
        state.setCredentials(AuthScope.ANY, cred);
        this.mClient.setState(state);
        ArrayList<String> authPrefs = new ArrayList<String>();
        authPrefs.add("Basic");
        this.mClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        this.mClient.getParams().setAuthenticationPreemptive(true);
    }

    public void setAuthCookie(ZAuthToken auth) {
        Map<String, String> cookieMap = auth.cookieMap(false);
        if (cookieMap != null) {
            String host = null;
            try {
                host = new URL(this.mBaseUrl).getHost();
            }
            catch (Exception e) {
                // empty catch block
            }
            HttpState state = new HttpState();
            for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                state.addCookie(new Cookie(host, ck.getKey(), ck.getValue(), "/", null, false));
            }
            this.mClient.setState(state);
            this.mClient.getParams().setCookiePolicy("compatibility");
        }
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setDebugEnabled(boolean b) {
        this.mDebugEnabled = b;
    }

    public void setAppName(String app) {
        this.mUserAgent = "Zimbra " + app + "/" + BuildInfo.VERSION + " (" + BuildInfo.DATE + ")";
    }
}

