/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.client;

import com.zimbra.common.util.Pair;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavRequest {
    private Document mDoc;
    private String mUri;
    private String mRedirectUrl;
    private String mMethod;
    private DavContext.Depth mDepth;
    private ArrayList<Pair<String, String>> mHeaders;
    private static final String PROPFIND = "PROPFIND";
    private static final String REPORT = "REPORT";
    private static final String DELETE = "DELETE";
    private static final String MKCOL = "MKCOL";
    private static final String MKCALENDAR = "MKCALENDAR";
    private static final String PROPPATCH = "PROPPATCH";
    private static final String OPTION = "OPTION";

    public DavRequest(String uri, String method) {
        this.mUri = uri;
        this.mMethod = method;
        this.mDepth = DavContext.Depth.zero;
        this.mHeaders = new ArrayList();
    }

    public Document getRequestMessage() {
        return this.mDoc;
    }

    public void setRedirectUrl(String url) {
        this.mRedirectUrl = url;
    }

    public void setRequestMessage(Element root) {
        if (this.mDoc == null) {
            this.mDoc = DocumentHelper.createDocument();
        }
        this.mDoc.setRootElement(root);
    }

    public void addRequestProp(QName p) {
        if (this.mDoc == null) {
            return;
        }
        Element prop = this.mDoc.getRootElement().element(DavElements.E_PROP);
        if (prop == null) {
            return;
        }
        prop.addElement(p);
    }

    public void addHref(String href) {
        if (this.mDoc == null) {
            return;
        }
        Element el = this.mDoc.getRootElement().addElement(DavElements.E_HREF);
        el.setText(href);
    }

    public void addRequestElement(Element e) {
        if (this.mDoc == null) {
            return;
        }
        this.mDoc.getRootElement().add(e);
    }

    public void addRequestHeader(String name, String value) {
        this.mHeaders.add(new Pair<String, String>(name, value));
    }

    public ArrayList<Pair<String, String>> getRequestHeaders() {
        return this.mHeaders;
    }

    public void setDepth(DavContext.Depth d) {
        this.mDepth = d;
    }

    public DavContext.Depth getDepth() {
        return this.mDepth;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getMethod() {
        return this.mMethod;
    }

    public String getRequestMessageString() throws IOException {
        if (this.mDoc != null) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            format.setOmitEncoding(false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(this.mDoc);
            return new String(out.toByteArray(), "UTF-8");
        }
        return "";
    }

    public HttpMethod getHttpMethod(String baseUrl) {
        String url = this.mRedirectUrl;
        if (url == null) {
            url = baseUrl + this.mUri;
        }
        if (this.mDoc == null) {
            return new GetMethod(url){

                public String getName() {
                    return DavRequest.this.mMethod;
                }
            };
        }
        PutMethod m = new PutMethod(url){
            RequestEntity re;

            public String getName() {
                return DavRequest.this.mMethod;
            }

            protected RequestEntity generateRequestEntity() {
                return this.re;
            }

            public void setRequestEntity(RequestEntity requestEntity) {
                this.re = requestEntity;
                super.setRequestEntity(requestEntity);
            }
        };
        DocumentRequestEntity re = new DocumentRequestEntity(this.mDoc);
        m.setRequestEntity(re);
        return m;
    }

    public static DavRequest PROPFIND(String uri) {
        DavRequest req = new DavRequest(uri, PROPFIND);
        Element root = DocumentHelper.createElement(DavElements.E_PROPFIND);
        root.addElement(DavElements.E_PROP);
        req.setRequestMessage(root);
        return req;
    }

    public static DavRequest CALENDARMULTIGET(String uri) {
        DavRequest req = new DavRequest(uri, REPORT);
        Element root = DocumentHelper.createElement(DavElements.E_CALENDAR_MULTIGET);
        root.addElement(DavElements.E_PROP);
        req.setRequestMessage(root);
        return req;
    }

    public static DavRequest EXPAND(String uri) {
        DavRequest req = new DavRequest(uri, REPORT);
        Element root = DocumentHelper.createElement(DavElements.E_EXPAND_PROPERTY);
        req.setRequestMessage(root);
        return req;
    }

    public static DavRequest CALENDARQUERY(String uri) {
        DavRequest req = new DavRequest(uri, REPORT);
        Element root = DocumentHelper.createElement(DavElements.E_CALENDAR_QUERY);
        root.addElement(DavElements.E_PROP);
        root.addElement(DavElements.E_FILTER).addElement(DavElements.E_COMP_FILTER).addAttribute("name", "VCALENDAR");
        req.setRequestMessage(root);
        return req;
    }

    public static DavRequest DELETE(String uri) {
        DavRequest req = new DavRequest(uri, DELETE);
        return req;
    }

    public static DavRequest MKCOL(String uri) {
        DavRequest req = new DavRequest(uri, MKCOL);
        return req;
    }

    public static DavRequest MKCALENDAR(String uri) {
        DavRequest req = new DavRequest(uri, MKCALENDAR);
        return req;
    }

    public static DavRequest PROPPATCH(String uri) {
        DavRequest req = new DavRequest(uri, PROPPATCH);
        Element root = DocumentHelper.createElement(DavElements.E_PROPERTYUPDATE);
        root.addElement(DavElements.E_SET).addElement(DavElements.E_PROP);
        req.setRequestMessage(root);
        return req;
    }

    public static DavRequest OPTION(String uri) {
        DavRequest req = new DavRequest(uri, OPTION);
        return req;
    }

    public static class DocumentRequestEntity
    implements RequestEntity {
        private Document doc;
        private byte[] buffer;

        public DocumentRequestEntity(Document d) {
            this.doc = d;
            this.buffer = null;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            if (this.buffer == null) {
                try {
                    this.getContents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.buffer == null) {
                return -1L;
            }
            return this.buffer.length;
        }

        public String getContentType() {
            return "text/xml";
        }

        public void writeRequest(OutputStream out) throws IOException {
            if (this.buffer != null) {
                out.write(this.buffer);
                return;
            }
            OutputFormat format = OutputFormat.createCompactFormat();
            format.setTrimText(false);
            format.setOmitEncoding(false);
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(this.doc);
        }

        private void getContents() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeRequest(out);
            this.buffer = out.toByteArray();
        }
    }
}

