/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.client;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavElements;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavObject {
    private String mHref;
    private HashMap<Integer, Element> mProps = new HashMap();

    public DavObject(Element objElem) {
        if (!objElem.getQName().equals(DavElements.E_RESPONSE)) {
            return;
        }
        Element href = objElem.element(DavElements.E_HREF);
        if (href != null) {
            this.mHref = href.getText();
        }
        for (Object obj : objElem.elements(DavElements.E_PROPSTAT)) {
            Element propStat = (Element)obj;
            Integer status = null;
            Element statusElem = propStat.element(DavElements.E_STATUS);
            if (statusElem != null) {
                status = this.parseStatusCode(statusElem.getText());
            }
            this.mProps.put(status, propStat.element(DavElements.E_PROP));
        }
    }

    public String getHref() {
        return this.mHref;
    }

    private int parseStatusCode(String str) {
        int status = 400;
        String[] tokens = str.split(" ");
        try {
            if (tokens.length > 2) {
                status = Integer.parseInt(tokens[1]);
            }
        }
        catch (NumberFormatException e) {
            ZimbraLog.dav.warn((Object)("can't parse status code: " + str), e);
        }
        return status;
    }

    public Element getProperty(QName prop) {
        Element p = this.mProps.get(200);
        if (p == null) {
            return null;
        }
        return p.element(prop);
    }

    public String getPropertyText(QName prop) {
        Element e = this.getProperty(prop);
        if (e != null) {
            return e.getText();
        }
        return null;
    }

    public long getPropertyLong(QName prop) {
        String val = this.getPropertyText(prop);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public Collection<Element> getProperties(int code) {
        Element prop = this.mProps.get(code);
        if (prop == null) {
            return Collections.emptyList();
        }
        List ret = prop.elements();
        return ret;
    }

    public boolean isResourceType(QName prop) {
        Element rtype = this.getProperty(DavElements.E_RESOURCETYPE);
        if (rtype == null) {
            return false;
        }
        return rtype.element(prop) != null;
    }

    public boolean isFolder() {
        return this.isResourceType(DavElements.E_COLLECTION);
    }

    public boolean isCalendarFolder() {
        return this.isResourceType(DavElements.E_CALENDAR);
    }

    public String getDisplayName() {
        return this.getPropertyText(DavElements.E_DISPLAYNAME);
    }

    public String getEtag() {
        return this.getPropertyText(DavElements.E_GETETAG);
    }

    public long getContentLength() {
        return this.getPropertyLong(DavElements.E_GETCONTENTLENGTH);
    }

    public String getContentLanguage() {
        return this.getPropertyText(DavElements.E_GETCONTENTLANGUAGE);
    }

    public String getContentType() {
        return this.getPropertyText(DavElements.E_GETCONTENTTYPE);
    }

    public String getCreationDate() {
        return this.getPropertyText(DavElements.E_GETCREATIONDATE);
    }

    public String getLastModifiedDate() {
        return this.getPropertyText(DavElements.E_GETLASTMODIFIED);
    }
}

