/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.client;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.client.DavObject;
import com.zimbra.cs.dav.client.DavRequest;
import com.zimbra.cs.dav.client.WebDavClient;
import com.zimbra.cs.service.UserServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalDavClient
extends WebDavClient {
    private static Collection<QName> CALENDAR_PROPS = new ArrayList<QName>();
    private HashSet<String> mCalendarHomeSet;
    private boolean mSchedulingEnabled = false;
    private String mScheduleInbox;
    private String mScheduleOutbox;

    public CalDavClient(String baseUrl) {
        super(baseUrl);
    }

    public void enableScheduling(boolean enable) {
        this.mSchedulingEnabled = enable;
    }

    public void login(String principalUrl) throws IOException, DavException {
        DavRequest propfind = DavRequest.PROPFIND(principalUrl);
        propfind.addRequestProp(DavElements.E_DISPLAYNAME);
        propfind.addRequestProp(DavElements.E_CALENDAR_HOME_SET);
        propfind.addRequestProp(DavElements.E_SCHEDULE_INBOX_URL);
        propfind.addRequestProp(DavElements.E_SCHEDULE_OUTBOX_URL);
        Collection<DavObject> response = this.sendMultiResponseRequest(propfind);
        if (response.size() != 1) {
            throw new DavException("invalid response to propfind on principal url", null);
        }
        DavObject resp = response.iterator().next();
        this.mCalendarHomeSet = new HashSet();
        Element homeSet = resp.getProperty(DavElements.E_CALENDAR_HOME_SET);
        if (homeSet != null) {
            for (Object href : homeSet.elements(DavElements.E_HREF)) {
                this.mCalendarHomeSet.add(((Element)href).getText());
            }
        }
        if (this.mCalendarHomeSet.isEmpty()) {
            throw new DavException("dav response from principal url does not contain calendar-home-set", null);
        }
        Element elem = resp.getProperty(DavElements.E_SCHEDULE_INBOX_URL);
        if (elem != null && elem.element(DavElements.E_HREF) != null) {
            this.mScheduleInbox = elem.element(DavElements.E_HREF).getText();
        }
        if ((elem = resp.getProperty(DavElements.E_SCHEDULE_OUTBOX_URL)) != null && elem.element(DavElements.E_HREF) != null) {
            this.mScheduleOutbox = elem.element(DavElements.E_HREF).getText();
        }
    }

    public Collection<String> getCalendarHomeSet() {
        return this.mCalendarHomeSet;
    }

    public Map<String, DavObject> getCalendars() throws IOException, DavException {
        HashMap<String, DavObject> calendars = new HashMap<String, DavObject>();
        for (String calHome : this.mCalendarHomeSet) {
            for (DavObject obj : this.listObjects(calHome, CALENDAR_PROPS)) {
                String href = obj.getHref();
                String displayName = obj.getDisplayName();
                if (!obj.isCalendarFolder() || displayName == null || href == null) continue;
                calendars.put(displayName, obj);
            }
        }
        return calendars;
    }

    public Collection<Appointment> getEtags(String calendarUri) throws IOException, DavException {
        ArrayList<Appointment> etags = new ArrayList<Appointment>();
        DavRequest propfind = DavRequest.PROPFIND(calendarUri);
        propfind.setDepth(DavContext.Depth.one);
        propfind.addRequestProp(DavElements.E_GETETAG);
        propfind.addRequestProp(DavElements.E_RESOURCETYPE);
        Collection<DavObject> response = this.sendMultiResponseRequest(propfind);
        for (DavObject obj : response) {
            String href = obj.getHref();
            String etag = obj.getPropertyText(DavElements.E_GETETAG);
            if (obj.isFolder() || etag == null || href == null) continue;
            etags.add(new Appointment(href, etag));
        }
        return etags;
    }

    public Appointment getCalendarData(Appointment appt) throws IOException {
        UserServlet.HttpInputStream resp = this.sendGet(appt.href);
        appt.data = null;
        if (resp.getStatusCode() == 200) {
            byte[] res = ByteUtil.getContent(resp, resp.getContentLength());
            appt.data = new String(res, "UTF-8");
        }
        return appt;
    }

    public Appointment getEtag(String url) throws IOException, DavException {
        Appointment appt = new Appointment(url, null);
        DavRequest propfind = DavRequest.PROPFIND(url);
        propfind.setDepth(DavContext.Depth.zero);
        propfind.addRequestProp(DavElements.E_GETETAG);
        propfind.addRequestProp(DavElements.E_RESOURCETYPE);
        Collection<DavObject> response = this.sendMultiResponseRequest(propfind);
        for (DavObject obj : response) {
            String href = obj.getHref();
            if (!href.equals(url)) continue;
            appt.etag = obj.getPropertyText(DavElements.E_GETETAG);
            return appt;
        }
        return appt;
    }

    public String sendCalendarData(Appointment appt) throws IOException, DavException {
        UserServlet.HttpInputStream resp = this.sendPut(appt.href, appt.data.getBytes("UTF-8"), "text/calendar", appt.etag, null);
        String etag = resp.getHeader("ETag");
        ZimbraLog.dav.debug("ETags: " + appt.etag + ", " + etag);
        int status = resp.getStatusCode();
        if (status != 200 && status != 201 && status != 204) {
            throw new DavException("Can't send calendar data (status=" + status + ")", status);
        }
        if (this.mSchedulingEnabled) {
            this.sendSchedulingMessage(appt);
        }
        return etag;
    }

    private void sendSchedulingMessage(Appointment appt) throws IOException, DavException {
    }

    public Collection<Appointment> getCalendarData(String url, Collection<Appointment> hrefs) throws IOException, DavException {
        ArrayList<Appointment> appts = new ArrayList<Appointment>();
        DavRequest multiget = DavRequest.CALENDARMULTIGET(url);
        multiget.addRequestProp(DavElements.E_GETETAG);
        multiget.addRequestProp(DavElements.E_CALENDAR_DATA);
        for (Appointment appt : hrefs) {
            multiget.addHref(appt.href);
        }
        Collection<DavObject> response = this.sendMultiResponseRequest(multiget);
        for (DavObject obj : response) {
            String href = obj.getHref();
            String etag = obj.getPropertyText(DavElements.E_GETETAG);
            String calData = obj.getPropertyText(DavElements.E_CALENDAR_DATA);
            if (href == null || calData == null) continue;
            appts.add(new Appointment(href, etag, calData));
        }
        return appts;
    }

    public Collection<Appointment> getAllCalendarData(String url) throws IOException, DavException {
        ArrayList<Appointment> appts = new ArrayList<Appointment>();
        DavRequest query = DavRequest.CALENDARQUERY(url);
        query.addRequestProp(DavElements.E_GETETAG);
        query.addRequestProp(DavElements.E_CALENDAR_DATA);
        Collection<DavObject> response = this.sendMultiResponseRequest(query);
        for (DavObject obj : response) {
            String href = obj.getHref();
            String etag = obj.getPropertyText(DavElements.E_GETETAG);
            String calData = obj.getPropertyText(DavElements.E_CALENDAR_DATA);
            if (href == null || calData == null) continue;
            appts.add(new Appointment(href, etag, calData));
        }
        return appts;
    }

    static {
        CALENDAR_PROPS.add(DavElements.E_DISPLAYNAME);
        CALENDAR_PROPS.add(DavElements.E_RESOURCETYPE);
        CALENDAR_PROPS.add(DavElements.E_GETCTAG);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Appointment {
        public String href;
        public String etag;
        public String data;
        public Collection<String> recipients;

        public Appointment(String h, String e) {
            this.href = h;
            this.etag = e;
        }

        public Appointment(String h, String e, String d) {
            this(h, e);
            this.data = d;
        }

        public Appointment(String h, String e, String d, Collection<String> r) {
            this(h, e, d);
            this.recipients = r;
        }
    }
}

