/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.carddav;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.resource.AddressObject;
import com.zimbra.cs.dav.resource.AddressbookCollection;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.gal.GalSearchResultCallback;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Contact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter {
    protected String mName;
    protected boolean mIsNotDefinedSet;
    protected HashSet<PropFilter> mProps = new HashSet();
    protected HashSet<ParamFilter> mParams = new HashSet();
    protected TextMatch mTextMatch;
    protected Filter mEnclosingFilter;
    private static final HashMap<String, AttrMapping> sAttrMappings = new HashMap();

    public Filter(Element elem) {
        this.mName = elem.attributeValue("name");
        this.parse(elem);
    }

    public String getName() {
        return this.mName;
    }

    public String getNameAsContactAttr() {
        return this.mName;
    }

    protected void parse(Element elem) {
        for (Object o : elem.elements()) {
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            QName name = e.getQName();
            if (this.canHavePropFilter() && name.equals(DavElements.CardDav.E_PROP_FILTER)) {
                this.mProps.add(new PropFilter(e));
                continue;
            }
            if (this.canHaveParamFilter() && name.equals(DavElements.CardDav.E_PARAM_FILTER)) {
                this.mParams.add(new ParamFilter(e, this));
                continue;
            }
            if (name.equals(DavElements.CardDav.E_TEXT_MATCH)) {
                this.mTextMatch = new TextMatch(e, this);
                continue;
            }
            if (name.equals(DavElements.CardDav.E_IS_NOT_DEFINED)) {
                this.mIsNotDefinedSet = true;
                continue;
            }
            ZimbraLog.dav.info("unrecognized filter " + name.getNamespaceURI() + ":" + name.getName());
        }
    }

    public Collection<AddressObject> match(DavContext ctxt, AddressbookCollection folder) {
        return null;
    }

    public boolean mIsNotDefinedSet() {
        return this.mIsNotDefinedSet;
    }

    protected boolean runTextMatch(String text) {
        boolean matched = true;
        return matched;
    }

    protected boolean canHavePropFilter() {
        return true;
    }

    protected boolean canHaveParamFilter() {
        return true;
    }

    static {
        AttrMapping m = AttrMapping.createStructured("FN");
        m.addSubType("name", "fullName", "firstName", "lastName");
        AttrMapping.createSimple("NICKNAME", "nickname");
        AttrMapping.createSimple("TITLE", "jobTitle");
        AttrMapping.createSimple("NOTE", "notes");
        AttrMapping.createStructured("ADR", "home", "homeStreet", "work", "workStreet");
        AttrMapping.createStructured("URL", "home", "homeURL", "work", "workURL");
        m = AttrMapping.createStructured("TEL", "car", "carPhone", "cell", "mobilePhone", "pager", "pager", "other", "otherPhone");
        m.addSubType("work", "workPhone", "workPhone2");
        m.addSubType("home", "homePhone", "homePhone2");
        m.addSubType("fax", "homeFax", "workFax");
        m = AttrMapping.createStructured("EMAIL");
        m.addSubType("internet", "email", "email2", "email3");
        m = AttrMapping.createStructured("ORG");
        m.addSubType("work", "company", "department");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropFilter
    extends Filter {
        public PropFilter(Element elem) {
            super(elem);
        }

        public boolean match(Contact contact) {
            String val = contact.get(this.mName);
            if (val == null) {
                return this.mIsNotDefinedSet;
            }
            boolean matched = true;
            for (ParamFilter pf : this.mParams) {
                matched &= pf.match(val);
            }
            return matched &= this.runTextMatch(val);
        }

        @Override
        public Collection<AddressObject> match(DavContext ctxt, AddressbookCollection folder) {
            if (!this.mIsNotDefinedSet) {
                if (this.mTextMatch != null) {
                    return this.mTextMatch.match(ctxt, folder);
                }
                if (this.mParams != null) {
                    ArrayList<AddressObject> result = new ArrayList<AddressObject>();
                    for (ParamFilter f : this.mParams) {
                        result.addAll(f.match(ctxt, folder));
                    }
                    return result;
                }
            }
            return null;
        }

        @Override
        protected boolean canHavePropFilter() {
            return false;
        }
    }

    public static class ParamFilter
    extends Filter {
        public ParamFilter(Element elem, Filter parent) {
            super(elem);
        }

        public boolean match(String prop) {
            return this.runTextMatch(prop);
        }

        protected boolean canHavePropFilter() {
            return false;
        }

        protected boolean canHaveParamFilter() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextMatch
    extends Filter {
        private String mText;
        private boolean mNegate;
        private MatchType mMatch;

        public TextMatch(Element elem, Filter parent) {
            super(elem);
            this.mEnclosingFilter = parent;
            this.mNegate = elem.attributeValue("negate-condition", "no").equals("yes");
            this.mText = elem.getText();
            this.mMatch = MatchType.fromString(elem.attributeValue("match-type"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<AddressObject> match(DavContext ctxt, AddressbookCollection folder) {
            block23: {
                block22: {
                    result = new ArrayList<AddressObject>();
                    search = new StringBuilder();
                    if (this.mNegate) {
                        search.append("!");
                    }
                    if ((mapping = (AttrMapping)Filter.access$000().get(this.mEnclosingFilter.getName().toUpperCase())) == null) {
                        return result;
                    }
                    attrs = mapping.getAttrs();
                    search.append("(");
                    first = true;
                    for (String var11_15 : attrs) {
                        if (!first) {
                            search.append(" OR ");
                        }
                        search.append("#").append(var11_15).append(":");
                        if (this.mMatch == MatchType.contains || this.mMatch == MatchType.ends_with) {
                            search.append("*");
                        }
                        search.append(this.mText);
                        if (this.mMatch == MatchType.contains || this.mMatch == MatchType.starts_with) {
                            search.append("*");
                        }
                        first = false;
                    }
                    search.append(")");
                    filter = search.toString();
                    ZimbraLog.dav.debug("Search Filter: %s", new Object[]{filter});
                    zqr = null;
                    try {
                        try {
                            mbox = ctxt.getTargetMailbox();
                            if (mbox == null) {
                                ZimbraLog.dav.debug("Can't get target mailbox for %s", new Object[]{ctxt.getUser()});
                                var11_16 = result;
                                var13_21 = null;
                                if (zqr == null) return var11_16;
                                break block22;
                            }
                            zqr = mbox.search(ctxt.getOperationContext(), filter, new byte[]{6}, SortBy.NAME_ASCENDING, 100);
                            while (zqr.hasNext()) {
                                var11_18 = zqr.getNext();
                                if (!(var11_18 instanceof ContactHit)) continue;
                                result.add(new AddressObject(ctxt, ((ContactHit)var11_18).getContact()));
                            }
                            break block23;
                        }
                        catch (Exception e) {
                            ZimbraLog.dav.warn((Object)"can't get target mailbox", e);
                            var11_19 = result;
                            var13_23 = null;
                            if (zqr == null) return var11_19;
                            try {
                                zqr.doneWithSearchResults();
                                return var11_19;
                            }
                            catch (ServiceException e) {
                                // empty catch block
                            }
                            return var11_19;
                        }
                    }
                    catch (Throwable var12_30) {
                        var13_24 = null;
                        if (zqr == null) throw var12_30;
                        ** try [egrp 2[TRYBLOCK] [6 : 403->413)] { 
lbl68:
                        // 1 sources

                        zqr.doneWithSearchResults();
                        throw var12_30;
lbl70:
                        // 1 sources

                        catch (ServiceException e) {
                            // empty catch block
                        }
                        throw var12_30;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [6 : 403->413)] { 
lbl75:
                // 1 sources

                zqr.doneWithSearchResults();
                return var11_16;
lbl77:
                // 1 sources

                catch (ServiceException e) {
                    // empty catch block
                }
                return var11_16;
            }
            var13_22 = null;
            if (zqr != null) {
                try {}
                catch (ServiceException e) {}
                zqr.doneWithSearchResults();
            }
            if ((includeGal = true) == false) return result;
            var11_20 = new StringBuilder();
            if (this.mMatch == MatchType.contains || this.mMatch == MatchType.ends_with) {
                var11_20.append("*");
            }
            var11_20.append(this.mText);
            if (this.mMatch == MatchType.contains || this.mMatch == MatchType.starts_with) {
                var11_20.append("*");
            }
            ZimbraLog.dav.debug("Gal query: %s", new Object[]{var11_20.toString()});
            params = new GalSearchParams(ctxt.getAuthAccount());
            params.setType(Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT);
            params.setQuery(var11_20.toString());
            params.setResultCallback(new Callback(ctxt, result, params));
            gal = new GalSearchControl(params);
            try {
                gal.search();
                return result;
            }
            catch (ServiceException e) {
                ZimbraLog.dav.error("Can't get gal search result for %s", new Object[]{ctxt.getUser()});
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Callback
        extends GalSearchResultCallback {
            DavContext ctxt;
            ArrayList<AddressObject> result;

            public Callback(DavContext ctxt, ArrayList<AddressObject> result, GalSearchParams params) {
                super(params);
                this.ctxt = ctxt;
                this.result = result;
            }

            @Override
            public com.zimbra.common.soap.Element handleContact(Contact c) {
                try {
                    this.result.add(new AddressObject(this.ctxt, c));
                }
                catch (ServiceException e) {
                    ZimbraLog.dav.error((Object)"can't include gal search result", e);
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        equals,
        contains,
        starts_with,
        ends_with;


        public static MatchType fromString(String s) {
            try {
                if (s != null) {
                    return MatchType.valueOf(s.replace('-', '_'));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return contains;
        }
    }

    private static final class AttrMapping {
        public String name;
        public MappingType type;
        public String contactAttr;
        public HashMap<String, String[]> structures;

        private AttrMapping() {
        }

        public static AttrMapping createSimple(String n, String attr) {
            AttrMapping m = new AttrMapping();
            m.type = MappingType.simple;
            m.name = n;
            m.contactAttr = attr;
            sAttrMappings.put(n, m);
            return m;
        }

        public static AttrMapping createStructured(String n, String ... args) {
            AttrMapping m = new AttrMapping();
            m.type = MappingType.structured;
            m.name = n;
            m.structures = new HashMap();
            for (int pos = 0; pos <= args.length - 2; pos += 2) {
                m.structures.put(args[pos], new String[]{args[pos + 1]});
            }
            sAttrMappings.put(n, m);
            return m;
        }

        public static AttrMapping createStructured(String n) {
            AttrMapping m = new AttrMapping();
            m.type = MappingType.structured;
            m.name = n;
            m.structures = new HashMap();
            sAttrMappings.put(n, m);
            return m;
        }

        public void addSubType(String k, String ... vals) {
            if (this.type == MappingType.simple) {
                return;
            }
            String[] v = new String[vals.length];
            int i = 0;
            for (String val : vals) {
                v[i++] = val;
            }
            this.structures.put(k, v);
        }

        public String[] getAttrs() {
            if (this.type == MappingType.simple) {
                return new String[]{this.contactAttr};
            }
            HashSet ret = new HashSet();
            for (String[] val : this.structures.values()) {
                Collections.addAll(ret, val);
            }
            return ret.toArray(new String[0]);
        }

        public String[] getAttrs(String key) {
            if (this.type == MappingType.simple) {
                return new String[]{this.contactAttr};
            }
            return this.structures.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MappingType {
        simple,
        structured;

    }
}

