/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.caldav;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.dom4j.Element;

public class TimeRange {
    private long mStart;
    private long mEnd;

    public TimeRange(String name) {
        try {
            Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, name);
            if (acct != null) {
                this.mStart = acct.getTimeInterval("zimbraCalendarCalDavSyncStart", 0L);
                this.mEnd = acct.getTimeInterval("zimbraCalendarCalDavSyncEnd", 0L);
            }
        }
        catch (ServiceException se) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        this.mStart = this.mStart == 0L ? Long.MIN_VALUE : now - this.mStart;
        this.mEnd = this.mEnd == 0L ? Long.MAX_VALUE : now + this.mEnd;
    }

    public TimeRange(Element elem) {
        this.mEnd = 0L;
        this.mStart = 0L;
        if (elem != null && elem.getQName().equals(DavElements.E_TIME_RANGE)) {
            String s = elem.attributeValue("start");
            if (s != null) {
                this.mStart = TimeRange.parseDateWithUTCTime(s);
            }
            if ((s = elem.attributeValue("end")) != null) {
                this.mEnd = TimeRange.parseDateWithUTCTime(s);
            }
        }
        if (this.mStart == 0L) {
            this.mStart = Long.MIN_VALUE;
        }
        if (this.mEnd == 0L) {
            this.mEnd = Long.MAX_VALUE;
        }
    }

    private static long parseDateWithUTCTime(String time) {
        if (time.length() != 8 && time.length() != 16) {
            return 0L;
        }
        if (!time.endsWith("Z")) {
            return 0L;
        }
        TimeZone tz = TimeZone.getTimeZone("GMT");
        int index = 0;
        int year = Integer.parseInt(time.substring(index, index + 4));
        int month = Integer.parseInt(time.substring(index += 4, index + 2)) - 1;
        int date = Integer.parseInt(time.substring(index += 2, index + 2));
        index += 2;
        int sec = 0;
        int min = 0;
        int hour = 0;
        if (time.length() == 16) {
            if (time.charAt(index) == 'T') {
                ++index;
            }
            hour = Integer.parseInt(time.substring(index, index + 2));
            min = Integer.parseInt(time.substring(index += 2, index + 2));
            sec = Integer.parseInt(time.substring(index += 2, index + 2));
            index += 2;
        }
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.clear();
        calendar.set(year, month, date, hour, min, sec);
        return calendar.getTimeInMillis();
    }

    public void intersection(TimeRange another) {
        if (this.mStart < another.mStart) {
            this.mStart = another.mStart;
        }
        if (this.mEnd > another.mEnd) {
            this.mEnd = another.mEnd;
        }
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public boolean matches(long mboxId, int itemId, long apptRangeStart, long apptRangeEnd) {
        if (apptRangeStart >= this.mStart && apptRangeEnd <= this.mEnd) {
            return true;
        }
        if (mboxId == 0L || itemId == 0) {
            return true;
        }
        try {
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
            CalendarItem item = mbox.getCalendarItemById(new OperationContext(mbox), itemId);
            for (CalendarItem.Instance instance : item.expandInstances(this.mStart, this.mEnd, false)) {
                if ((instance.getStart() < this.mStart || instance.getStart() > this.mEnd) && (instance.getEnd() < this.mStart || instance.getEnd() > this.mEnd)) continue;
                return true;
            }
        }
        catch (ServiceException se) {
            ZimbraLog.dav.warn((Object)("error getting calendar item " + itemId + " from mailbox " + mboxId), se);
        }
        return false;
    }
}

