/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.caldav;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.caldav.TimeRange;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.util.Collection;
import java.util.HashSet;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class Filter {
    protected String mName;
    protected boolean mIsNotDefinedSet;
    protected TimeRange mTimeRange;
    protected HashSet<CompFilter> mComps;
    protected HashSet<PropFilter> mProps = new HashSet();
    protected HashSet<ParamFilter> mParams;
    protected HashSet<TextMatch> mTextMatches;

    public Filter(Element elem) {
        this.mComps = new HashSet();
        this.mParams = new HashSet();
        this.mTextMatches = new HashSet();
        this.mName = elem.attributeValue("name");
        this.parse(elem);
    }

    public String getName() {
        return this.mName;
    }

    protected void parse(Element elem) {
        for (Object o : elem.elements()) {
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            QName name = e.getQName();
            if (this.canHaveCompFilter() && name.equals(DavElements.E_COMP_FILTER)) {
                this.mComps.add(new CompFilter(e));
                continue;
            }
            if (this.canHavePropFilter() && name.equals(DavElements.E_PROP_FILTER)) {
                this.mProps.add(new PropFilter(e));
                continue;
            }
            if (this.canHaveParamFilter() && name.equals(DavElements.E_PARAM_FILTER)) {
                this.mParams.add(new ParamFilter(e));
                continue;
            }
            if (name.equals(DavElements.E_TEXT_MATCH)) {
                this.mTextMatches.add(new TextMatch(e));
                continue;
            }
            if (name.equals(DavElements.E_TIME_RANGE)) {
                this.mTimeRange = new TimeRange(e);
                continue;
            }
            if (name.equals(DavElements.E_IS_NOT_DEFINED)) {
                this.mIsNotDefinedSet = true;
                continue;
            }
            ZimbraLog.dav.info("unrecognized filter " + name.getNamespaceURI() + ":" + name.getName());
        }
    }

    public boolean match(ZCalendar.ZComponent comp) {
        return comp.getName().equals(this.mName);
    }

    public boolean mIsNotDefinedSet() {
        return this.mIsNotDefinedSet;
    }

    protected boolean runTextMatch(String text) {
        boolean matched = true;
        for (TextMatch tm : this.mTextMatches) {
            matched &= tm.match(text);
        }
        return matched;
    }

    public TimeRange getTimeRange() {
        TimeRange tr;
        if (this.mTimeRange != null) {
            return this.mTimeRange;
        }
        for (CompFilter compFilter : this.mComps) {
            tr = compFilter.getTimeRange();
            if (tr == null) continue;
            return tr;
        }
        for (PropFilter propFilter : this.mProps) {
            tr = propFilter.getTimeRange();
            if (tr == null) continue;
            return tr;
        }
        return null;
    }

    protected boolean canHaveCompFilter() {
        return true;
    }

    protected boolean canHavePropFilter() {
        return true;
    }

    protected boolean canHaveParamFilter() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompFilter
    extends Filter {
        public CompFilter(Element elem) {
            super(elem);
        }

        @Override
        public boolean match(ZCalendar.ZComponent comp) {
            boolean matched = true;
            if (this.mName.equals("VCALENDAR")) {
                if (this.mComps.size() > 0) {
                    matched = false;
                    for (CompFilter cf : this.mComps) {
                        matched |= cf.match(comp);
                    }
                }
                return matched;
            }
            matched = super.match(comp);
            if (matched && this.mComps.size() > 0) {
                matched = false;
                for (CompFilter cf : this.mComps) {
                    ZCalendar.ZComponent sub;
                    ZCalendar.ICalTok tok = ZCalendar.ICalTok.lookup(cf.mName);
                    if (tok == null || (sub = comp.getComponent(tok)) == null) continue;
                    matched |= cf.match(sub);
                }
            }
            if (matched && this.mProps.size() > 0) {
                for (PropFilter pf : this.mProps) {
                    matched &= pf.match(comp);
                }
            }
            return matched;
        }

        @Override
        protected boolean canHaveParamFilter() {
            return false;
        }

        public Collection<PropFilter> getPropFilters() {
            return this.mProps;
        }

        public Collection<CompFilter> getCompFilters() {
            return this.mComps;
        }
    }

    public static class PropFilter
    extends Filter {
        public PropFilter(Element elem) {
            super(elem);
        }

        public boolean match(ZCalendar.ZComponent comp) {
            ZCalendar.ICalTok tok = ZCalendar.ICalTok.lookup(this.mName);
            if (tok == null) {
                return false;
            }
            boolean matched = true;
            ZCalendar.ZProperty prop = comp.getProperty(tok);
            if (prop == null) {
                return this.mIsNotDefinedSet;
            }
            for (ParamFilter pf : this.mParams) {
                matched &= pf.match(prop);
            }
            return matched &= this.runTextMatch(prop.getValue());
        }

        protected boolean canHaveCompFilter() {
            return false;
        }

        protected boolean canHavePropFilter() {
            return false;
        }
    }

    public static class ParamFilter
    extends Filter {
        public ParamFilter(Element elem) {
            super(elem);
        }

        public boolean match(ZCalendar.ZProperty prop) {
            ZCalendar.ICalTok tok = ZCalendar.ICalTok.lookup(this.mName);
            if (tok == null) {
                return false;
            }
            ZCalendar.ZParameter param = prop.getParameter(tok);
            if (param == null) {
                return this.mIsNotDefinedSet;
            }
            return this.runTextMatch(param.getValue());
        }

        protected boolean canHaveCompFilter() {
            return false;
        }

        protected boolean canHavePropFilter() {
            return false;
        }

        protected boolean canHaveParamFilter() {
            return false;
        }
    }

    public static class TextMatch {
        private String mCollation;
        private String mText;
        private boolean mNegate;

        public TextMatch(Element elem) {
            this.mCollation = elem.attributeValue("collation", "i;ascii-casemap");
            this.mNegate = elem.attributeValue("negate-condition", "no").equals("yes");
            this.mText = elem.getText();
        }

        public boolean match(String val) {
            boolean ignoreCase = this.mCollation.equals("i;ascii-casemap");
            boolean ret = ignoreCase ? val.equalsIgnoreCase(this.mText) : val.equals(this.mText);
            if (this.mNegate) {
                return !ret;
            }
            return ret;
        }
    }
}

