/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav;

import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockMgr {
    private static LockMgr sInstance;
    private HashMap<String, List<String>> mLockedResources = new HashMap();
    private LRUMap mLocks = new LRUMap(100);
    private static final int sDEFAULTTIMEOUT = 600000;
    private static final String sTIMEOUTINFINITE = "Infinite";
    private static final String sTIMEOUTSEC = "Second-";
    private static final String sTOKEN_PREFIX = "urn:uuid:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LockMgr getInstance() {
        if (sInstance != null) return sInstance;
        Class<LockMgr> clazz = LockMgr.class;
        synchronized (LockMgr.class) {
            if (sInstance != null) return sInstance;
            sInstance = new LockMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private LockMgr() {
    }

    public synchronized List<Lock> getLocks(String path) {
        ArrayList<Lock> locks = new ArrayList<Lock>();
        List<String> lockTokens = this.mLockedResources.get(path);
        if (lockTokens != null) {
            for (String token : lockTokens) {
                Lock l = (Lock)this.mLocks.get((Object)token);
                if (l == null) continue;
                if (l.isExpired()) {
                    locks.remove(l);
                    continue;
                }
                locks.add(l);
            }
        }
        return locks;
    }

    private synchronized Lock hasLock(String owner, String path, LockType type, LockScope scope) throws DavException {
        for (Lock l : this.getLocks(path)) {
            if (l == null) continue;
            if (l.owner.compareTo(owner) == 0) {
                return l;
            }
            if (scope == LockScope.exclusive) {
                throw new DavException("already locked " + path, 423);
            }
            if (scope != LockScope.shared || l.scope != LockScope.exclusive) continue;
            throw new DavException("shared lock exists " + path, 423);
        }
        return null;
    }

    public synchronized Lock createLock(DavContext ctxt, String owner, String path, LockType type, LockScope scope, String depth) throws DavException {
        Lock l = this.hasLock(owner, path, type, scope);
        if (l != null) {
            return l;
        }
        l = new Lock(type, scope, depth, owner);
        l.token = sTOKEN_PREFIX + UUID.randomUUID().toString();
        List<String> locks = this.mLockedResources.get(path);
        if (locks == null) {
            locks = new ArrayList<String>();
            this.mLockedResources.put(path, locks);
        }
        locks.add(l.token);
        this.mLocks.put((Object)l.token, (Object)l);
        return l;
    }

    public synchronized void deleteLock(DavContext ctxt, String path, String token) {
        List<String> locks = this.mLockedResources.get(path);
        if (locks == null) {
            return;
        }
        if (!locks.contains(token)) {
            return;
        }
        if (this.mLocks.containsKey((Object)token)) {
            this.mLocks.remove((Object)token);
            locks.remove(token);
        }
    }

    public static class Lock {
        public LockType type;
        public LockScope scope;
        public String depth;
        public String owner;
        public long expiration;
        public String token;

        public Lock(LockType t, LockScope s, String d, String o) {
            this.type = t;
            this.scope = s;
            this.depth = d;
            this.owner = o;
            this.expiration = System.currentTimeMillis() + 600000L;
        }

        public boolean isExpired() {
            return this.expiration < System.currentTimeMillis();
        }

        public String getTimeoutStr() {
            long timeoutInSec = (this.expiration - System.currentTimeMillis()) / 1000L;
            if (timeoutInSec < 0L) {
                return LockMgr.sTIMEOUTINFINITE;
            }
            return LockMgr.sTIMEOUTSEC + timeoutInSec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockScope {
        exclusive,
        shared;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockType {
        write;

    }
}

