/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavProtocol {
    private static HashMap<Compliance, String> sComplianceStrMap = new HashMap();
    public static Compliance[] COMPLIANCES;
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String XML_CONTENT_TYPE2 = "application/xml";
    public static final String DAV_CONTENT_TYPE = "text/xml; charset=\"UTF-8\"";
    public static final String VCARD_CONTENT_TYPE = "text/vcard";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String ENCODING_GZIP = "gzip";
    public static final String VCARD_VERSION = "3.0";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_ALLOW = "Allow";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String NO_CACHE = "no-cache";
    public static final String HEADER_DAV = "DAV";
    public static final String HEADER_DEPTH = "Depth";
    public static final String HEADER_DESTINATION = "Destination";
    public static final String HEADER_IF = "If";
    public static final String HEADER_LOCK_TOKEN = "Lock-Token";
    public static final String HEADER_OVERWRITE = "Overwrite";
    public static final String HEADER_STATUS_URI = "Status-URI";
    public static final String HEADER_TIMEOUT = "Timeout";
    public static final String HEADER_IF_MATCH = "If-Match";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_ORIGINATOR = "Originator";
    public static final String HEADER_RECIPIENT = "Recipient";
    public static final int STATUS_PROCESSING = 102;
    public static final int STATUS_MULTI_STATUS = 207;
    public static final int STATUS_UNPROCESSABLE_ENTITY = 422;
    public static final int STATUS_LOCKED = 423;
    public static final int STATUS_FAILED_DEPENDENCY = 424;
    public static final int STATUS_INSUFFICIENT_STORAGE = 507;

    public static String getDefaultComplianceString() {
        return DavProtocol.getComplianceString(Arrays.asList(COMPLIANCES));
    }

    public static String getComplianceString(Collection<Compliance> comp) {
        if (comp == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Compliance c : comp) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(sComplianceStrMap.get((Object)c));
        }
        return buf.toString();
    }

    static {
        sComplianceStrMap.put(Compliance.one, "1");
        sComplianceStrMap.put(Compliance.two, "2");
        sComplianceStrMap.put(Compliance.three, "3");
        sComplianceStrMap.put(Compliance.update, "update");
        sComplianceStrMap.put(Compliance.bind, "bind");
        sComplianceStrMap.put(Compliance.access_control, "access-control");
        sComplianceStrMap.put(Compliance.calendar_access, "calendar-access");
        sComplianceStrMap.put(Compliance.calendar_schedule, "calendar-schedule");
        sComplianceStrMap.put(Compliance.version_control, "version-control");
        sComplianceStrMap.put(Compliance.calendar_proxy, "calendar-proxy");
        sComplianceStrMap.put(Compliance.calendarserver_principal_property_search, "calendarserver-principal-property-search");
        sComplianceStrMap.put(Compliance.addressbook, "addressbook");
        sComplianceStrMap.put(Compliance.extended_mkcol, "extended-mkcol");
        COMPLIANCES = new Compliance[]{Compliance.one, Compliance.two, Compliance.three, Compliance.calendar_access, Compliance.calendar_proxy, Compliance.calendarserver_principal_property_search, Compliance.access_control, Compliance.addressbook};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compliance {
        one,
        two,
        three,
        update,
        bind,
        access_control,
        calendar_access,
        calendar_schedule,
        version_control,
        addressbook,
        extended_mkcol,
        calendar_proxy,
        calendarserver_principal_property_search;

    }
}

