/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav;

import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DomUtil;
import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class DavException
extends Exception {
    protected boolean mStatusIsSet;
    protected int mStatus;
    protected Document mErrMsg;

    public DavException(String msg, int status) {
        super(msg);
        this.mStatus = status;
        this.mStatusIsSet = true;
    }

    public DavException(String msg, Throwable cause) {
        super(msg, cause);
        this.mStatusIsSet = false;
    }

    public DavException(String msg, int status, Throwable cause) {
        super(msg, cause);
        this.mStatus = status;
        this.mStatusIsSet = true;
    }

    public boolean isStatusSet() {
        return this.mStatusIsSet;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean hasErrorMessage() {
        return this.mErrMsg != null;
    }

    public Element getErrorMessage() {
        if (this.mErrMsg == null) {
            return null;
        }
        return this.mErrMsg.getRootElement();
    }

    public void writeErrorMsg(OutputStream out) throws IOException {
        DomUtil.writeDocumentToStream(this.mErrMsg, out);
    }

    public static class CannotModifyProtectedProperty
    extends DavExceptionWithErrorMessage {
        public CannotModifyProtectedProperty(QName prop) {
            super("property " + prop.getName() + " is protected", 403);
            this.setError(DavElements.E_CANNOT_MODIFY_PROTECTED_PROPERTY);
        }
    }

    protected static class DavExceptionWithErrorMessage
    extends DavException {
        protected DavExceptionWithErrorMessage(String msg, int status) {
            super(msg, status);
            this.mErrMsg = DocumentHelper.createDocument();
            this.mErrMsg.addElement(DavElements.E_ERROR);
        }

        protected void setError(QName error) {
            this.mErrMsg.getRootElement().addElement(error);
        }
    }
}

